/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.impl;

import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.serialization.JpsGlobalElementSaver;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsModelSerializationDataService;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.jps.model.serialization.JpsSerializationManager;

public final class JpsSerializationManagerImpl
extends JpsSerializationManager {
    @Override
    @NotNull
    public JpsModel loadModel(@NotNull String projectPath, @Nullable String optionsPath, boolean loadUnloadedModules) throws IOException {
        JpsModel model = JpsElementFactory.getInstance().createModel();
        if (optionsPath != null) {
            JpsGlobalLoader.loadGlobalSettings(model.getGlobal(), optionsPath);
        }
        Map<String, String> pathVariables = JpsModelSerializationDataService.computeAllPathVariables(model.getGlobal());
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, projectPath, loadUnloadedModules);
        return model;
    }

    @Override
    @NotNull
    public JpsProject loadProject(@NotNull String projectPath, @NotNull Map<String, String> pathVariables) throws IOException {
        JpsModel model = JpsElementFactory.getInstance().createModel();
        JpsProjectLoader.loadProject(model.getProject(), pathVariables, projectPath);
        return model.getProject();
    }

    @Override
    public void saveGlobalSettings(@NotNull JpsGlobal global, @NotNull String optionsPath) throws IOException {
        JpsGlobalElementSaver.saveGlobalElement(global, optionsPath);
    }
}

