/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsExcludePatternImpl;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryCollectionImpl;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.module.impl.JpsDependenciesListImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleReferenceImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceRootRole;
import org.jetbrains.jps.model.module.impl.JpsSdkReferencesTableImpl;

public class JpsModuleImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsModuleImpl<P>>
implements JpsTypedModule<P> {
    private static final JpsUrlListRole CONTENT_ROOTS_ROLE = new JpsUrlListRole("content roots");
    private static final JpsUrlListRole EXCLUDED_ROOTS_ROLE = new JpsUrlListRole("excluded roots");
    private static final JpsElementChildRole<JpsDependenciesListImpl> DEPENDENCIES_LIST_CHILD_ROLE = JpsElementChildRoleBase.create((String)"dependencies");
    private static final JpsElementCollectionRole<JpsExcludePattern> EXCLUDE_PATTERNS_ROLE = JpsElementCollectionRole.create((JpsElementChildRole)JpsElementChildRoleBase.create((String)"exclude patterns"));
    private final JpsModuleType<P> myModuleType;
    private final JpsLibraryCollection myLibraryCollection;

    public JpsModuleImpl(JpsModuleType<P> type, @NotNull String name, @NotNull P properties) {
        super(name);
        this.myModuleType = type;
        this.myContainer.setChild(this.myModuleType.getPropertiesRole(), properties);
        this.myContainer.setChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
        this.myContainer.setChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
        this.myContainer.setChild(DEPENDENCIES_LIST_CHILD_ROLE, (JpsElement)new JpsDependenciesListImpl());
        this.getDependenciesList().addModuleSourceDependency();
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.setChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
        this.myContainer.setChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        this.myContainer.setChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    private JpsModuleImpl(JpsModuleImpl<P> original) {
        super(original);
        this.myModuleType = original.myModuleType;
        this.myLibraryCollection = new JpsLibraryCollectionImpl((JpsElementCollection<JpsLibrary>)((JpsElementCollection)this.myContainer.getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE)));
    }

    @NotNull
    public JpsModuleImpl<P> createCopy() {
        return new JpsModuleImpl<P>(this);
    }

    public JpsElementType<P> getType() {
        return this.myModuleType;
    }

    @NotNull
    public P getProperties() {
        return (P)this.myContainer.getChild(this.myModuleType.getPropertiesRole());
    }

    public <P extends JpsElement> JpsTypedModule<P> asTyped(@NotNull JpsModuleType<P> type) {
        return this.myModuleType.equals(type) ? this : null;
    }

    @NotNull
    public JpsUrlList getContentRootsList() {
        return (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)CONTENT_ROOTS_ROLE);
    }

    @NotNull
    public JpsUrlList getExcludeRootsList() {
        return (JpsUrlList)this.myContainer.getChild((JpsElementChildRole)EXCLUDED_ROOTS_ROLE);
    }

    @NotNull
    public List<JpsModuleSourceRoot> getSourceRoots() {
        return ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElements();
    }

    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedModuleSourceRoot<P>> getSourceRoots(@NotNull JpsModuleSourceRootType<P> type) {
        return ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).getElementsOfType(type);
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType) {
        return this.addSourceRoot(url, rootType, (JpsElement)rootType.createDefaultProperties());
    }

    @NotNull
    public <P extends JpsElement> JpsModuleSourceRoot addSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType<P> rootType, @NotNull P properties) {
        JpsModuleSourceRootImpl<P> root = new JpsModuleSourceRootImpl<P>(url, rootType, properties);
        this.addSourceRoot((JpsModuleSourceRoot)root);
        return root;
    }

    public void addSourceRoot(@NotNull JpsModuleSourceRoot root) {
        ((JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE)).addChild((JpsElement)root);
    }

    public void removeSourceRoot(@NotNull String url, @NotNull JpsModuleSourceRootType rootType) {
        JpsElementCollection roots = (JpsElementCollection)this.myContainer.getChild(JpsModuleSourceRootRole.ROOT_COLLECTION_ROLE);
        for (JpsModuleSourceRoot root : roots.getElements()) {
            if (!root.getRootType().equals(rootType) || !root.getUrl().equals(url)) continue;
            roots.removeChild((JpsElement)root);
            break;
        }
    }

    public void addExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        ((JpsElementCollection)this.myContainer.getOrSetChild(EXCLUDE_PATTERNS_ROLE)).addChild((JpsElement)new JpsExcludePatternImpl(baseDirUrl, pattern));
    }

    public void removeExcludePattern(@NotNull String baseDirUrl, @NotNull String pattern) {
        JpsElementCollection child = (JpsElementCollection)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE);
        if (child != null) {
            for (JpsExcludePattern excludePattern : child.getElements()) {
                if (!excludePattern.getBaseDirUrl().equals(baseDirUrl) || !excludePattern.getPattern().equals(pattern)) continue;
                child.removeChild((JpsElement)excludePattern);
            }
        }
    }

    public List<JpsExcludePattern> getExcludePatterns() {
        JpsElementCollection child = (JpsElementCollection)this.myContainer.getChild(EXCLUDE_PATTERNS_ROLE);
        return child != null ? child.getElements() : Collections.emptyList();
    }

    @NotNull
    public JpsDependenciesList getDependenciesList() {
        return (JpsDependenciesList)this.myContainer.getChild(DEPENDENCIES_LIST_CHILD_ROLE);
    }

    @NotNull
    public JpsSdkReferencesTable getSdkReferencesTable() {
        return (JpsSdkReferencesTable)this.myContainer.getChild((JpsElementChildRole)JpsSdkReferencesTableImpl.ROLE);
    }

    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(@NotNull JpsSdkType<P> type) {
        JpsSdkReference sdkReference = this.getSdkReferencesTable().getSdkReference(type);
        if (sdkReference != null) {
            return sdkReference;
        }
        JpsProject project = this.getProject();
        if (project != null) {
            return project.getSdkReferencesTable().getSdkReference(type);
        }
        return null;
    }

    public <P extends JpsElement> JpsSdk<P> getSdk(@NotNull JpsSdkType<P> type) {
        JpsSdkReference<P> reference = this.getSdkReference(type);
        if (reference == null) {
            return null;
        }
        JpsTypedLibrary library = (JpsTypedLibrary)reference.resolve();
        return library != null ? (JpsSdk)library.getProperties() : null;
    }

    public void delete() {
        ((JpsElementCollection)this.myParent).removeChild((JpsElement)this);
    }

    @NotNull
    public JpsModuleReference createReference() {
        return new JpsModuleReferenceImpl(this.getName());
    }

    @NotNull
    public <P extends JpsElement, Type extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addModuleLibrary(@NotNull String name, @NotNull Type type) {
        return this.myLibraryCollection.addLibrary(name, type);
    }

    public void addModuleLibrary(@NotNull JpsLibrary library) {
        this.myLibraryCollection.addLibrary(library);
    }

    @NotNull
    public JpsLibraryCollection getLibraryCollection() {
        return this.myLibraryCollection;
    }

    @Nullable
    public JpsProject getProject() {
        JpsModel model = this.getModel();
        return model != null ? model.getProject() : null;
    }

    @NotNull
    public JpsModuleType<P> getModuleType() {
        return this.myModuleType;
    }
}

