/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependenciesRootsEnumerator;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesEnumerationHandler;
import org.jetbrains.jps.model.java.impl.JpsJavaDependenciesRootsEnumeratorImpl;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.impl.JpsDependenciesEnumeratorBase;

public class JpsJavaDependenciesEnumeratorImpl
extends JpsDependenciesEnumeratorBase<JpsJavaDependenciesEnumeratorImpl>
implements JpsJavaDependenciesEnumerator {
    private boolean myProductionOnly;
    private boolean myRuntimeOnly;
    private boolean myCompileOnly;
    private boolean myExportedOnly;
    private boolean myRecursivelyExportedOnly;
    private JpsJavaClasspathKind myClasspathKind;
    private final List<JpsJavaDependenciesEnumerationHandler> myHandlers;

    public JpsJavaDependenciesEnumeratorImpl(Collection<JpsModule> rootModules) {
        super(rootModules);
        List<JpsJavaDependenciesEnumerationHandler> handlers = JpsJavaDependenciesEnumerationHandler.createHandlers(rootModules);
        this.myHandlers = handlers != null ? handlers : Collections.emptyList();
    }

    @NotNull
    public JpsJavaDependenciesEnumerator productionOnly() {
        this.myProductionOnly = true;
        return this;
    }

    @NotNull
    public JpsJavaDependenciesEnumerator compileOnly() {
        this.myCompileOnly = true;
        return this;
    }

    @NotNull
    public JpsJavaDependenciesEnumerator runtimeOnly() {
        this.myRuntimeOnly = true;
        return this;
    }

    @NotNull
    public JpsJavaDependenciesEnumerator exportedOnly() {
        if (this.myRecursively) {
            this.myRecursivelyExportedOnly = true;
        } else {
            this.myExportedOnly = true;
        }
        return this;
    }

    @NotNull
    public JpsJavaDependenciesEnumerator recursivelyExportedOnly() {
        return ((JpsJavaDependenciesEnumeratorImpl)this.recursively()).exportedOnly();
    }

    @NotNull
    public JpsJavaDependenciesEnumerator includedIn(@NotNull JpsJavaClasspathKind classpathKind) {
        this.myClasspathKind = classpathKind;
        return this;
    }

    @NotNull
    public JpsJavaDependenciesRootsEnumerator classes() {
        return new JpsJavaDependenciesRootsEnumeratorImpl(this, JpsOrderRootType.COMPILED);
    }

    @NotNull
    public JpsJavaDependenciesRootsEnumerator sources() {
        return new JpsJavaDependenciesRootsEnumeratorImpl(this, JpsOrderRootType.SOURCES);
    }

    @NotNull
    public JpsJavaDependenciesRootsEnumerator annotations() {
        return new JpsJavaDependenciesRootsEnumeratorImpl(this, (JpsOrderRootType)JpsAnnotationRootType.INSTANCE);
    }

    @Override
    protected JpsJavaDependenciesEnumeratorImpl self() {
        return this;
    }

    @Override
    protected boolean shouldProcessDependenciesRecursively() {
        return JpsJavaDependenciesEnumerationHandler.shouldProcessDependenciesRecursively(this.myHandlers);
    }

    @Override
    protected boolean shouldProcess(JpsModule module, JpsDependencyElement element) {
        boolean exported = !(element instanceof JpsSdkDependency);
        JpsJavaDependencyExtension extension = JpsJavaExtensionService.getInstance().getDependencyExtension(element);
        if (extension != null) {
            boolean forTestCompile;
            exported = extension.isExported();
            JpsJavaDependencyScope scope = extension.getScope();
            boolean bl = forTestCompile = scope.isIncludedIn(JpsJavaClasspathKind.TEST_COMPILE) || scope == JpsJavaDependencyScope.RUNTIME && this.shouldAddRuntimeDependenciesToTestCompilationClasspath();
            if (this.myCompileOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_COMPILE) && !forTestCompile || this.myRuntimeOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME) && !scope.isIncludedIn(JpsJavaClasspathKind.TEST_RUNTIME) || this.myClasspathKind != null && !scope.isIncludedIn(this.myClasspathKind) && (this.myClasspathKind != JpsJavaClasspathKind.TEST_COMPILE || !forTestCompile)) {
                return false;
            }
            if (this.myProductionOnly && (!scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_COMPILE) && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME) || this.myCompileOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_COMPILE) || this.myRuntimeOnly && !scope.isIncludedIn(JpsJavaClasspathKind.PRODUCTION_RUNTIME))) {
                return false;
            }
        }
        if (!exported) {
            if (this.myExportedOnly) {
                return false;
            }
            if ((this.myRecursivelyExportedOnly || element instanceof JpsSdkDependency) && !this.isEnumerationRootModule(module)) {
                return false;
            }
        }
        return true;
    }

    public boolean isProductionOnly() {
        return this.myProductionOnly || this.myClasspathKind == JpsJavaClasspathKind.PRODUCTION_RUNTIME || this.myClasspathKind == JpsJavaClasspathKind.PRODUCTION_COMPILE;
    }

    public boolean isProductionOnTests(JpsDependencyElement element) {
        for (JpsJavaDependenciesEnumerationHandler handler : this.myHandlers) {
            if (!handler.isProductionOnTestsDependency(element)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        for (JpsJavaDependenciesEnumerationHandler handler : this.myHandlers) {
            if (handler.shouldIncludeTestsFromDependentModulesToTestClasspath()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        for (JpsJavaDependenciesEnumerationHandler handler : this.myHandlers) {
            if (!handler.shouldAddRuntimeDependenciesToTestCompilationClasspath()) continue;
            return true;
        }
        return false;
    }
}

