/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleIndex;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JavaModuleIndexImpl
extends JpsElementBase<JavaModuleIndexImpl>
implements JavaModuleIndex {
    private static final String SOURCE_SUFFIX = ":S";
    private static final String TEST_SUFFIX = ":T";
    private static final String MODULE_INFO_FILE = "module-info.java";
    private final Map<String, File> myMapping = new HashMap<String, File>();
    private final JpsCompilerExcludes myExcludes;

    public JavaModuleIndexImpl(@NotNull JpsCompilerExcludes excludes) {
        this.myExcludes = excludes;
    }

    @NotNull
    public JavaModuleIndexImpl createCopy() {
        JavaModuleIndexImpl copy = new JavaModuleIndexImpl(this.myExcludes);
        copy.myMapping.putAll(this.myMapping);
        return copy;
    }

    public void applyChanges(@NotNull JavaModuleIndexImpl modified) {
    }

    @Nullable
    public File getModuleInfoFile(@NotNull JpsModule module, boolean forTests) {
        String key = module.getName() + (forTests ? TEST_SUFFIX : SOURCE_SUFFIX);
        if (this.myMapping.containsKey(key)) {
            return this.myMapping.get(key);
        }
        File file = this.findModuleInfoFile(module, forTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
        this.myMapping.put(key, file);
        return file;
    }

    private File findModuleInfoFile(JpsModule module, JavaSourceRootType rootType) {
        for (JpsModuleSourceRoot root : module.getSourceRoots()) {
            File file;
            if (!rootType.equals(root.getRootType()) || !(file = new File(JpsPathUtil.urlToOsPath((String)root.getUrl()), MODULE_INFO_FILE)).isFile() || this.myExcludes.isExcluded(file)) continue;
            return file;
        }
        return null;
    }

    public void dropCache() {
        this.myMapping.clear();
    }
}

