/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl.elements;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.elements.JpsLibraryFilesPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElementFactory;
import org.jetbrains.jps.model.artifact.elements.ex.JpsComplexPackagingElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.JpsOrderRootType;

public class JpsLibraryFilesPackagingElementImpl
extends JpsComplexPackagingElementBase<JpsLibraryFilesPackagingElementImpl>
implements JpsLibraryFilesPackagingElement {
    private static final JpsElementChildRole<JpsLibraryReference> LIBRARY_REFERENCE_CHILD_ROLE = JpsElementChildRoleBase.create((String)"library reference");

    public JpsLibraryFilesPackagingElementImpl(@NotNull JpsLibraryReference reference) {
        this.myContainer.setChild(LIBRARY_REFERENCE_CHILD_ROLE, (JpsElement)reference);
    }

    private JpsLibraryFilesPackagingElementImpl(JpsLibraryFilesPackagingElementImpl original) {
        super((JpsComplexPackagingElementBase)original);
    }

    @NotNull
    public JpsLibraryFilesPackagingElementImpl createCopy() {
        return new JpsLibraryFilesPackagingElementImpl(this);
    }

    @NotNull
    public JpsLibraryReference getLibraryReference() {
        return (JpsLibraryReference)this.myContainer.getChild(LIBRARY_REFERENCE_CHILD_ROLE);
    }

    public List<JpsPackagingElement> getSubstitution() {
        JpsLibrary library = (JpsLibrary)this.getLibraryReference().resolve();
        if (library == null) {
            return Collections.emptyList();
        }
        ArrayList<JpsPackagingElement> result = new ArrayList<JpsPackagingElement>();
        for (File file : library.getFiles(JpsOrderRootType.COMPILED)) {
            String path = FileUtil.toSystemIndependentName((String)file.getAbsolutePath());
            if (file.isDirectory()) {
                result.add((JpsPackagingElement)JpsPackagingElementFactory.getInstance().createDirectoryCopy(path));
                continue;
            }
            result.add((JpsPackagingElement)JpsPackagingElementFactory.getInstance().createFileCopy(path, null));
        }
        return result;
    }
}

