/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;
    private final Map<String, T> myHashBangMap;

    private FileTypeAssocTable(@NotNull Map<? extends CharSequence, ? extends T> extensionMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameMappings, @NotNull Map<? extends CharSequence, ? extends T> exactFileNameAnyCaseMappings, @NotNull Map<String, ? extends T> hashBangMap, @NotNull List<? extends Pair<FileNameMatcher, T>> matchingMappings) {
        this.myExtensionMappings = CollectionFactory.createCharSequenceMap((boolean)false, (int)Math.max(10, extensionMappings.size()), (float)0.5f);
        this.myExtensionMappings.putAll(extensionMappings);
        this.myExactFileNameMappings = CollectionFactory.createCharSequenceMap((boolean)true, (int)Math.max(10, exactFileNameMappings.size()), (float)0.5f);
        this.myExactFileNameMappings.putAll(exactFileNameMappings);
        this.myExactFileNameAnyCaseMappings = CollectionFactory.createCharSequenceMap((boolean)false, (int)Math.max(10, exactFileNameAnyCaseMappings.size()), (float)0.5f);
        this.myExactFileNameAnyCaseMappings.putAll(exactFileNameAnyCaseMappings);
        this.myHashBangMap = new Object2ObjectOpenHashMap(Math.max(10, hashBangMap.size()), 0.5f);
        this.myHashBangMap.putAll(hashBangMap);
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    boolean isAssociatedWith(@NotNull T type, @NotNull FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return this.findAssociatedFileType(matcher) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            mapToUse.put(exactFileNameMatcher.getFileName(), type);
        } else {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
        }
    }

    void addHashBangPattern(@NotNull String hashBang, @NotNull T type) {
        this.myHashBangMap.put(hashBang, type);
    }

    void removeHashBangPattern(@NotNull String hashBang, @NotNull T type) {
        this.myHashBangMap.remove(hashBang, type);
    }

    void removeAssociation(@NotNull FileNameMatcher matcher, @NotNull T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return;
            }
            return;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            Map<CharSequence, T> mapToUse;
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String fileName = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> map = mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (mapToUse.get(fileName) == type) {
                mapToUse.remove(fileName);
            }
            return;
        }
        this.myMatchingMappings.removeIf(assoc -> matcher.equals(assoc.getFirst()));
    }

    void removeAllAssociations(@NotNull T type) {
        this.removeAssociationsFromMap(this.myExtensionMappings, type);
        this.removeAssociationsFromMap(this.myExactFileNameAnyCaseMappings, type);
        this.removeAssociationsFromMap(this.myExactFileNameMappings, type);
        this.myMatchingMappings.removeIf(assoc -> assoc.getSecond() == type);
        this.myHashBangMap.entrySet().removeIf(e -> e.getValue().equals(type));
    }

    private void removeAssociationsFromMap(@NotNull Map<CharSequence, T> extensionMappings, @NotNull T type) {
        extensionMappings.entrySet().removeIf(entry -> entry.getValue() == type);
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        T t;
        if (!this.myExactFileNameMappings.isEmpty() && (t = this.myExactFileNameMappings.get(fileName)) != null) {
            return t;
        }
        if (!this.myExactFileNameAnyCaseMappings.isEmpty() && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        for (int i = 0; i < this.myMatchingMappings.size(); ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!((FileNameMatcher)mapping.getFirst()).acceptsCharSequence(fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.findByExtension(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    T findAssociatedFileTypeByHashBang(@NotNull CharSequence content) {
        for (Map.Entry<String, T> entry : this.myHashBangMap.entrySet()) {
            String hashBang = entry.getKey();
            if (!FileUtil.isHashBangLine((CharSequence)content, (String)hashBang)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    T findAssociatedFileType(@NotNull FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.findByExtension(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            return mapToUse.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    T findByExtension(@NotNull CharSequence extension) {
        return this.myExtensionMappings.get(extension);
    }

    String @NotNull [] getAssociatedExtensions(@NotNull T type) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Map.Entry<CharSequence, T> entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            extensions.add(entry.getKey().toString());
        }
        return ArrayUtilRt.toStringArray(extensions);
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        return new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myHashBangMap, this.myMatchingMappings);
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), false));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExactFileNameMatcher(((CharSequence)entry.getKey()).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add((FileNameMatcher)new ExtensionFileNameMatcher(((CharSequence)entry.getKey()).toString()));
        }
        return result;
    }

    @NotNull
    public List<String> getHashBangPatterns(@NotNull T type) {
        return this.myHashBangMap.entrySet().stream().filter(e -> e.getValue().equals(type)).map(e -> (String)e.getKey()).collect(Collectors.toList());
    }

    boolean hasAssociationsFor(@NotNull T fileType) {
        if (this.myExtensionMappings.containsValue(fileType) || this.myExactFileNameMappings.containsValue(fileType) || this.myHashBangMap.containsValue(fileType) || this.myExactFileNameAnyCaseMappings.containsValue(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    @NotNull
    Map<FileNameMatcher, T> getRemovedMappings(@NotNull FileTypeAssocTable<T> newTable, @NotNull Collection<? extends T> keys) {
        HashMap<FileNameMatcher, T> map = new HashMap<FileNameMatcher, T>();
        for (T key : keys) {
            List<FileNameMatcher> associations = this.getAssociations(key);
            associations.removeAll(newTable.getAssociations(key));
            for (FileNameMatcher matcher : associations) {
                map.put(matcher, key);
            }
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return this.myExtensionMappings.equals(that.myExtensionMappings) && this.myMatchingMappings.equals(that.myMatchingMappings) && this.myExactFileNameMappings.equals(that.myExactFileNameMappings) && this.myHashBangMap.equals(that.myHashBangMap) && this.myExactFileNameAnyCaseMappings.equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = this.myExtensionMappings.hashCode();
        result = 31 * result + this.myMatchingMappings.hashCode();
        result = 31 * result + this.myHashBangMap.hashCode();
        result = 31 * result + this.myExactFileNameMappings.hashCode();
        result = 31 * result + this.myExactFileNameAnyCaseMappings.hashCode();
        return result;
    }

    @NotNull
    Map<String, T> getAllHashBangPatterns() {
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectOpenHashMap(this.myHashBangMap));
    }
}

