/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.plugins.idea;

import androidx.compose.plugins.idea.ComposableCallCheckerKt;
import androidx.compose.plugins.idea.ComposeErrors;
import androidx.compose.plugins.idea.ComposeFqNamesKt;
import androidx.compose.plugins.idea.ComposeWritableSlices;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J$\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Landroidx/compose/plugins/idea/ComposableCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "Lorg/jetbrains/kotlin/extensions/StorageComponentContainerContributor;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "illegalCall", "callEl", "functionEl", "registerModuleComponents", "container", "Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "intellij.android.compose-ide-plugin"})
public class ComposableCallChecker
implements CallChecker,
AdditionalTypeChecker,
StorageComponentContainerContributor {
    public void registerModuleComponents(@NotNull StorageComponentContainer container, @NotNull TargetPlatform platform, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        DslKt.useInstance((StorageComponentContainer)container, (Object)this);
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!ComposableCallCheckerKt.isComposableInvocation(resolvedCall)) {
            return;
        }
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        PsiElement node = reportOn;
        while (node != null) {
            PsiElement psiElement;
            PsiElement psiElement2 = node;
            if (!(psiElement2 instanceof KtFunctionLiteral)) {
                boolean composable;
                SimpleFunctionDescriptor descriptor;
                if (psiElement2 instanceof KtLambdaExpression) {
                    boolean inlined;
                    descriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)((KtLambdaExpression)node).getFunctionLiteral());
                    if (descriptor == null) {
                        ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                        return;
                    }
                    composable = ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)descriptor, bindingContext2);
                    if (composable) {
                        return;
                    }
                    KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)node).getFunctionLiteral();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"node.functionLiteral");
                    ValueParameterDescriptor arg = ComposableCallCheckerKt.access$getArgumentDescriptor((KtFunction)ktFunctionLiteral, bindingContext2);
                    ValueParameterDescriptor valueParameterDescriptor = arg;
                    if (Intrinsics.areEqual((Object)(valueParameterDescriptor != null && (valueParameterDescriptor = valueParameterDescriptor.getType()) != null ? ComposeFqNamesKt.composablePreventCaptureContract((Annotated)valueParameterDescriptor) : null), (Object)true)) {
                        context.getTrace().record(ComposeWritableSlices.INSTANCE.getLAMBDA_CAPABLE_OF_COMPOSER_CAPTURE(), (Object)descriptor, (Object)false);
                        context.getTrace().report((Diagnostic)ComposeErrors.CAPTURED_COMPOSABLE_INVOCATION.on(reportOn, (Object)arg, (Object)arg.getContainingDeclaration()));
                        return;
                    }
                    boolean bl = inlined = arg != null && InlineUtil.canBeInlineArgument((PsiElement)((PsiElement)((KtLambdaExpression)node).getFunctionLiteral())) && InlineUtil.isInline((DeclarationDescriptor)((DeclarationDescriptor)arg.getContainingDeclaration())) && InlineUtil.isInlineParameter((ParameterDescriptor)((ParameterDescriptor)arg));
                    if (!inlined) {
                        ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                        return;
                    }
                    context.getTrace().record(ComposeWritableSlices.INSTANCE.getLAMBDA_CAPABLE_OF_COMPOSER_CAPTURE(), (Object)descriptor, (Object)true);
                } else {
                    if (psiElement2 instanceof KtFunction) {
                        descriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)node);
                        if (descriptor == null) {
                            ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                            return;
                        }
                        composable = ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)descriptor, bindingContext2);
                        if (!composable) {
                            PsiElement psiElement3 = ((KtFunction)node).getNameIdentifier();
                            if (psiElement3 == null) {
                                psiElement3 = node;
                            }
                            this.illegalCall(context, reportOn, psiElement3);
                        }
                        return;
                    }
                    if (psiElement2 instanceof KtProperty) {
                        descriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)node);
                        if (!(descriptor instanceof LocalVariableDescriptor)) {
                            List list = ((KtProperty)node).getAnnotationEntries();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"node.annotationEntries");
                            if (ComposableCallCheckerKt.hasComposableAnnotation(list, bindingContext2)) {
                                ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                                return;
                            }
                        }
                    } else {
                        if (psiElement2 instanceof KtPropertyAccessor) {
                            KtProperty ktProperty = ((KtPropertyAccessor)node).getProperty();
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"node.property");
                            KtProperty property = ktProperty;
                            List list = property.getAnnotationEntries();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"property.annotationEntries");
                            if (!ComposableCallCheckerKt.hasComposableAnnotation(list, bindingContext2)) {
                                PsiElement psiElement4 = property.getNameIdentifier();
                                if (psiElement4 == null) {
                                    psiElement4 = (PsiElement)property;
                                }
                                this.illegalCall(context, reportOn, psiElement4);
                            }
                            return;
                        }
                        if (psiElement2 instanceof KtFile) {
                            ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                            return;
                        }
                        if (psiElement2 instanceof KtClass) {
                            ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                            return;
                        }
                    }
                }
            }
            if (!((psiElement = node.getParent()) instanceof KtElement)) {
                psiElement = null;
            }
            node = (PsiElement)((KtElement)psiElement);
        }
    }

    private final void illegalCall(CallCheckerContext context, PsiElement callEl, PsiElement functionEl) {
        context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_INVOCATION.on(callEl));
        if (functionEl != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_EXPECTED.on(functionEl));
        }
    }

    static /* synthetic */ void illegalCall$default(ComposableCallChecker composableCallChecker, CallCheckerContext callCheckerContext, PsiElement psiElement, PsiElement psiElement2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: illegalCall");
        }
        if ((n & 4) != 0) {
            psiElement2 = null;
        }
        composableCallChecker.illegalCall(callCheckerContext, psiElement, psiElement2);
    }

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
        Intrinsics.checkParameterIsNotNull((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        BindingTrace bindingTrace = c.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"c.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"c.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"c.expectedType");
        KotlinType expectedType = kotlinType;
        if (expectedType == TypeUtils.NO_EXPECTED_TYPE) {
            return;
        }
        if (expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
            return;
        }
        boolean expectedComposable = ComposeFqNamesKt.hasComposableAnnotation(expectedType);
        if (expression instanceof KtLambdaExpression) {
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)((KtLambdaExpression)expression).getFunctionLiteral());
            if (simpleFunctionDescriptor == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"bindingContext[BindingCo\u2026                ?: return");
            SimpleFunctionDescriptor descriptor = simpleFunctionDescriptor;
            boolean isComposable = ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)descriptor, bindingContext2);
            if (expectedComposable != isComposable) {
                KtExpression ktExpression;
                KtFunction ktFunction = (KtFunction)((KtLambdaExpression)expression).getFunctionLiteral();
                BindingTrace bindingTrace2 = c.trace;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"c.trace");
                boolean isInlineable = InlineUtil.isInlinedArgument((KtFunction)ktFunction, (BindingContext)bindingTrace2.getBindingContext(), (boolean)true);
                if (isInlineable) {
                    return;
                }
                if (((KtLambdaExpression)expression).getParent() instanceof KtAnnotatedExpression) {
                    PsiElement psiElement = ((KtLambdaExpression)expression).getParent();
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    ktExpression = (KtExpression)psiElement;
                } else {
                    ktExpression = expression;
                }
                KtExpression reportOn = ktExpression;
                c.trace.report((Diagnostic)Errors.TYPE_MISMATCH.on((PsiElement)reportOn, (Object)expectedType, (Object)expressionTypeWithSmartCast));
            }
            return;
        }
        SimpleType simpleType = TypeUtilsKt.getBuiltIns((KotlinType)expectedType).getNullableAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType, (String)"expectedType.builtIns.nullableAnyType");
        SimpleType nullableAnyType = simpleType;
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns((KotlinType)expectedType).getAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"expectedType.builtIns.anyType");
        SimpleType anyType = simpleType2;
        if (Intrinsics.areEqual((Object)anyType, (Object)FlexibleTypesKt.lowerIfFlexible((KotlinType)expectedType)) && Intrinsics.areEqual((Object)nullableAnyType, (Object)FlexibleTypesKt.upperIfFlexible((KotlinType)expectedType))) {
            return;
        }
        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns((KotlinType)expectedType).getNullableNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"expectedType.builtIns.nullableNothingType");
        SimpleType nullableNothingType = simpleType3;
        if (expectedType.isMarkedNullable() && Intrinsics.areEqual((Object)expressionTypeWithSmartCast, (Object)nullableNothingType)) {
            return;
        }
        boolean isComposable = ComposeFqNamesKt.hasComposableAnnotation(expressionType);
        if (expectedComposable != isComposable) {
            KtExpression ktExpression;
            if (expression.getParent() instanceof KtAnnotatedExpression) {
                PsiElement psiElement = expression.getParent();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                ktExpression = (KtExpression)psiElement;
            } else {
                ktExpression = expression;
            }
            KtExpression reportOn = ktExpression;
            c.trace.report((Diagnostic)Errors.TYPE_MISMATCH.on((PsiElement)reportOn, (Object)expectedType, (Object)expressionTypeWithSmartCast));
        }
    }

    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull((Object)receiverParameter, (String)"receiverParameter");
        Intrinsics.checkParameterIsNotNull((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, (String)"c");
        AdditionalTypeChecker.DefaultImpls.checkReceiver((AdditionalTypeChecker)this, (ReceiverParameterDescriptor)receiverParameter, (ReceiverValue)receiverArgument, (boolean)safeAccess, c);
    }
}

