/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.reload;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.reload.ApkReloadException;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SdkUpdater {
    @NotNull
    private Project myProject;
    @Nullable
    private File mySdkPath;
    @NotNull
    private AndroidSdkSetup mySdkSetup;

    SdkUpdater(@NotNull Project project, @NotNull IdeSdks ideSdks) {
        this(project, ideSdks, new AndroidSdkSetup());
    }

    @VisibleForTesting
    SdkUpdater(@NotNull Project project, @NotNull IdeSdks ideSdks, @NotNull AndroidSdkSetup sdkSetup) {
        this.myProject = project;
        this.mySdkPath = ideSdks.getAndroidSdkPath();
        this.mySdkSetup = sdkSetup;
    }

    public void updateSdkInModule(@NotNull Module module, @NotNull ApkFacet apkFacet, @NotNull String newSdkVersion) throws ApkReloadException {
        if (this.mySdkPath == null) {
            throw new ApkReloadException("SDK path not selected");
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(this.myProject);
        ModifiableRootModel rootModel = modelsProvider.getModifiableRootModel(module);
        Sdk selectedSdk = this.mySdkSetup.setUpSdk(newSdkVersion, this.mySdkPath, apkFacet, rootModel);
        if (selectedSdk == null) {
            modelsProvider.dispose();
            throw new ApkReloadException("Failed to set SDK version " + newSdkVersion);
        }
        this.commitChanges((IdeModifiableModelsProvider)modelsProvider);
    }

    private void commitChanges(final @NotNull IdeModifiableModelsProvider modelsProvider) {
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                modelsProvider.commit();
            }
        });
    }
}

