/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.PathMappingNode;
import com.android.tools.idea.apk.editor.PathMappingRootNode;
import com.android.tools.idea.apk.editor.PathMappingTreeTableViewModel;
import com.android.tools.idea.apk.symbols.ui.FilePathTreeCellRenderer;
import com.android.tools.idea.apk.symbols.ui.PathMapping;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PathMappingTreeTableView
extends TreeTableView {
    static final String PATH_MAPPINGS_PROPERTY = "pathMappings";
    private final PathMappingRootNode myRootNode;

    @NotNull
    static PathMappingTreeTableView create(@NotNull NativeLibrary library, @NotNull Project project) {
        return new PathMappingTreeTableView(new PathMappingTreeTableViewModel(library, project));
    }

    @VisibleForTesting
    PathMappingTreeTableView(@NotNull PathMappingTreeTableViewModel model) {
        super((ListTreeTableModelOnColumns)model);
        this.myRootNode = model.getRoot();
        TreeTableTree tree = this.getTree();
        TreeUtil.installActions((JTree)tree);
        tree.setToggleClickCount(0);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setCellRenderer((TreeCellRenderer)((Object)new FilePathTreeCellRenderer((JTree)tree)));
        this.setRowHeight(new TextFieldWithBrowseButton().getButton().getPreferredSize().height);
        this.getTableHeader().setReorderingAllowed(false);
        this.updateContents();
        model.view = this;
        new TreeTableSpeedSearch((TreeTable)this, (Convertor)new PathToStringConvertor());
    }

    void tableChanged() {
        if (this.myRootNode != null) {
            NativeLibrary library = this.myRootNode.getLibrary();
            Map<String, String> mappings = this.getEnteredPathMappings();
            this.firePropertyChange(PATH_MAPPINGS_PROPERTY, library.pathMappings, mappings);
        }
    }

    @NotNull
    PathMappingRootNode getRootNode() {
        return this.myRootNode;
    }

    @NotNull
    Map<String, String> getEnteredPathMappings() {
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        TreeUtil.traverse((TreeNode)this.myRootNode, node -> {
            if (node instanceof PathMappingNode) {
                File path;
                PathMappingNode pathMappingNode = (PathMappingNode)node;
                PathMapping pathMapping = pathMappingNode.getPathMapping();
                String selectedPath = pathMapping.getSelectedPath();
                if (pathMappingNode.isLeaf()) {
                    mappings.put(pathMapping.getOriginalPath(), selectedPath);
                } else if (!selectedPath.isEmpty() && !PathMappingTreeTableView.isParentSelectedPathAncestor(pathMappingNode) && (path = new File(selectedPath)).isDirectory()) {
                    mappings.put(pathMapping.getOriginalPath(), selectedPath);
                }
            }
            return true;
        });
        return mappings;
    }

    private static boolean isParentSelectedPathAncestor(@NotNull PathMappingNode pathMappingNode) {
        PathMapping pathMapping = pathMappingNode.getPathMapping();
        String selectedPath = pathMapping.getSelectedPath();
        String parentSelectedPath = PathMappingTreeTableView.getSelectedPathFromParent(pathMappingNode);
        return StringUtil.isNotEmpty((String)parentSelectedPath) && FileUtil.isAncestor((String)parentSelectedPath, (String)selectedPath, (boolean)true);
    }

    @Nullable
    private static String getSelectedPathFromParent(@NotNull PathMappingNode pathMappingNode) {
        TreeNode parent = pathMappingNode.getParent();
        if (parent instanceof PathMappingNode) {
            return ((PathMappingNode)parent).getPathMapping().getSelectedPath();
        }
        return null;
    }

    void updateContents() {
        this.myRootNode.updateChildren();
        this.updateUI();
        TreeUtil.expandAll((JTree)this.getTree());
    }

    void updatePathMapping(@NotNull String originalPath, @NotNull String selectedPath) {
        TreeUtil.traverse((TreeNode)this.myRootNode, node -> {
            PathMappingNode pathMappingNode;
            PathMapping pathMapping;
            if (node instanceof PathMappingNode && (pathMapping = (pathMappingNode = (PathMappingNode)node).getPathMapping()).getOriginalPath().equals(originalPath)) {
                pathMapping.setSelectedPath(selectedPath);
            }
            return true;
        });
    }

    @NotNull
    List<PathMapping> getInternalPathMappings() {
        ArrayList<PathMapping> pathMappings = new ArrayList<PathMapping>();
        TreeUtil.traverse((TreeNode)this.myRootNode, node -> {
            if (node instanceof PathMappingNode) {
                pathMappings.add(((PathMappingNode)node).getPathMapping());
            }
            return true;
        });
        return pathMappings;
    }

    @Nullable
    PathMappingNode findNodeWithOriginalPath(@NotNull String originalPath) {
        return PathMappingTreeTableView.findNodeWithOriginalPath(this.myRootNode, originalPath);
    }

    @Nullable
    private static PathMappingNode findNodeWithOriginalPath(@NotNull DefaultMutableTreeNode node, @NotNull String originalPath) {
        PathMappingNode pathMappingNode;
        if (node instanceof PathMappingNode && originalPath.equals((pathMappingNode = (PathMappingNode)node).getPathMapping().getOriginalPath())) {
            return pathMappingNode;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            PathMappingNode mayBeFound = PathMappingTreeTableView.findNodeWithOriginalPath((DefaultMutableTreeNode)node.getChildAt(i), originalPath);
            if (mayBeFound == null) continue;
            return mayBeFound;
        }
        return null;
    }

    @VisibleForTesting
    static class PathToStringConvertor
    implements Convertor<TreePath, String> {
        PathToStringConvertor() {
        }

        public String convert(TreePath treePath) {
            Object component = treePath.getLastPathComponent();
            if (component instanceof PathMappingNode) {
                return ((PathMappingNode)component).getFilePath();
            }
            return (String)TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING.convert((Object)treePath);
        }
    }
}

