/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.BytesSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FullFileSource
extends BytesSource {
    public FullFileSource(String filePath, String entryName, int compressionLevel) throws IOException {
        this(filePath, entryName, compressionLevel, Symlink.FOLLOW);
    }

    public FullFileSource(String filePath, String entryName, int compressionLevel, Symlink symlinkPolicy) throws IOException {
        super(entryName);
        byte[] bytes;
        Path path2 = Paths.get(filePath, new String[0]);
        if (Files.isExecutable(path2)) {
            this.externalAttributes |= 0x490000;
        }
        if (!Files.isSymbolicLink(path2) || symlinkPolicy == Symlink.FOLLOW) {
            bytes = Files.readAllBytes(path2);
        } else {
            this.externalAttributes |= 0xA0000000;
            compressionLevel = 0;
            Path target2 = Files.readSymbolicLink(path2);
            bytes = target2.toString().getBytes(StandardCharsets.US_ASCII);
        }
        this.build(bytes, bytes.length, compressionLevel);
    }

    public static enum Symlink {
        FOLLOW,
        DO_NOT_FOLLOW;

    }
}

