/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap;

import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.StackTrace;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.Visitor;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class ClassObj
extends Instance
implements Comparable<ClassObj> {
    final String mClassName;
    private final long mStaticFieldsOffset;
    long mSuperClassId;
    long mClassLoaderId;
    Field[] mFields;
    Field[] mStaticFields;
    private int mInstanceSize;
    private boolean mIsSoftReference = false;
    TIntObjectHashMap<HeapData> mHeapData = new TIntObjectHashMap();
    Set<ClassObj> mSubclasses = new HashSet<ClassObj>();

    public ClassObj(long id, StackTrace stack, String className, long staticFieldsOffset) {
        super(id, stack);
        this.mClassName = className;
        this.mStaticFieldsOffset = staticFieldsOffset;
    }

    public final void addSubclass(ClassObj subclass) {
        this.mSubclasses.add(subclass);
    }

    public final Set<ClassObj> getSubclasses() {
        return this.mSubclasses;
    }

    public final void dumpSubclasses() {
        for (ClassObj subclass : this.mSubclasses) {
            System.out.println("     " + subclass.mClassName);
        }
    }

    public final String toString() {
        return this.mClassName.replace('/', '.');
    }

    public final void addInstance(int heapId, Instance instance) {
        HeapData heapData;
        if (instance instanceof ClassInstance) {
            instance.setSize(this.mInstanceSize);
        }
        if ((heapData = (HeapData)this.mHeapData.get(heapId)) == null) {
            heapData = new HeapData();
            this.mHeapData.put(heapId, (Object)heapData);
        }
        heapData.mInstances.add(instance);
        heapData.mShallowSize += instance.getSize();
    }

    public final void setSuperClassId(long superClass) {
        this.mSuperClassId = superClass;
    }

    public final void setClassLoaderId(long classLoader) {
        this.mClassLoaderId = classLoader;
    }

    public final long getClassLoaderId() {
        return this.mClassLoaderId;
    }

    public int getAllFieldsCount() {
        int result2 = 0;
        for (ClassObj clazz = this; clazz != null; clazz = clazz.getSuperClassObj()) {
            result2 += clazz.getFields().length;
        }
        return result2;
    }

    public Field[] getFields() {
        return this.mFields;
    }

    public void setFields(Field[] fields) {
        this.mFields = fields;
    }

    public void setStaticFields(Field[] staticFields) {
        this.mStaticFields = staticFields;
    }

    public void setInstanceSize(int size) {
        this.mInstanceSize = size;
    }

    public int getInstanceSize() {
        return this.mInstanceSize;
    }

    public int getShallowSize(int heapId) {
        HeapData heapData = (HeapData)this.mHeapData.get(heapId);
        return heapData == null ? 0 : ((HeapData)this.mHeapData.get((int)heapId)).mShallowSize;
    }

    public void setIsSoftReference() {
        this.mIsSoftReference = true;
    }

    @Override
    public boolean getIsSoftReference() {
        return this.mIsSoftReference;
    }

    public Map<Field, Object> getStaticFieldValues() {
        HashMap<Field, Object> result2 = new HashMap<Field, Object>();
        this.getBuffer().setPosition(this.mStaticFieldsOffset);
        int numEntries = this.readUnsignedShort();
        for (int i = 0; i < numEntries; ++i) {
            Field f = this.mStaticFields[i];
            this.readId();
            this.readUnsignedByte();
            Object value = this.readValue(f.getType());
            result2.put(f, value);
        }
        return result2;
    }

    public final void dump() {
        System.out.println("+----------  ClassObj dump for: " + this.mClassName);
        System.out.println("+-----  Static fields");
        Map<Field, Object> staticFields = this.getStaticFieldValues();
        for (Field field : staticFields.keySet()) {
            System.out.println(field.getName() + ": " + (Object)((Object)field.getType()) + " = " + staticFields.get(field));
        }
        System.out.println("+-----  Instance fields");
        for (Field field : this.mFields) {
            System.out.println(field.getName() + ": " + (Object)((Object)field.getType()));
        }
        if (this.getSuperClassObj() != null) {
            this.getSuperClassObj().dump();
        }
    }

    public final String getClassName() {
        return this.mClassName;
    }

    @Override
    public final void resolveReferences() {
        for (Map.Entry<Field, Object> entry : this.getStaticFieldValues().entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Instance)) continue;
            ((Instance)value).addReverseReference(entry.getKey(), this);
            this.mHardForwardReferences.add((Instance)value);
        }
    }

    @Override
    public final void accept(Visitor visitor2) {
        visitor2.visitClassObj(this);
        for (Instance instance : this.mHardForwardReferences) {
            visitor2.visitLater(this, instance);
        }
    }

    @Override
    public final int compareTo(ClassObj o) {
        if (this.getId() == o.getId()) {
            return 0;
        }
        int nameCompareResult = this.mClassName.compareTo(o.mClassName);
        if (nameCompareResult != 0) {
            return nameCompareResult;
        }
        return this.getId() - o.getId() > 0L ? 1 : -1;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ClassObj)) {
            return false;
        }
        return 0 == this.compareTo((ClassObj)o);
    }

    public int hashCode() {
        return this.mClassName.hashCode();
    }

    Object getStaticField(Type type, String name) {
        return this.getStaticFieldValues().get(new Field(type, name));
    }

    public ClassObj getSuperClassObj() {
        return this.mHeap.mSnapshot.findClass(this.mSuperClassId);
    }

    public Instance getClassLoader() {
        return this.mHeap.mSnapshot.findInstance(this.mClassLoaderId);
    }

    public List<Instance> getInstancesList() {
        int count = this.getInstanceCount();
        ArrayList<Instance> resultList = new ArrayList<Instance>(count);
        for (int heapId : this.mHeapData.keys()) {
            resultList.addAll(this.getHeapInstances(heapId));
        }
        return resultList;
    }

    public List<Instance> getHeapInstances(int heapId) {
        HeapData result2 = (HeapData)this.mHeapData.get(heapId);
        return result2 == null ? new ArrayList(0) : result2.mInstances;
    }

    public int getHeapInstancesCount(int heapId) {
        HeapData result2 = (HeapData)this.mHeapData.get(heapId);
        return result2 == null ? 0 : result2.mInstances.size();
    }

    public int getInstanceCount() {
        int count = 0;
        for (Object heapStat : this.mHeapData.getValues()) {
            count += ((HeapData)heapStat).mInstances.size();
        }
        return count;
    }

    public int getShallowSize() {
        int size = 0;
        for (Object heapStat : this.mHeapData.getValues()) {
            size += ((HeapData)heapStat).mShallowSize;
        }
        return size;
    }

    public static String getReferenceClassName() {
        return "java.lang.ref.Reference";
    }

    public List<ClassObj> getDescendantClasses() {
        ArrayList<ClassObj> descendants = new ArrayList<ClassObj>();
        Stack<ClassObj> searchStack = new Stack<ClassObj>();
        searchStack.push(this);
        while (!searchStack.isEmpty()) {
            ClassObj classObj = (ClassObj)searchStack.pop();
            descendants.add(classObj);
            for (ClassObj subClass : classObj.getSubclasses()) {
                searchStack.push(subClass);
            }
        }
        return descendants;
    }

    public static class HeapData {
        public int mShallowSize = 0;
        public List<Instance> mInstances = new ArrayList<Instance>();
    }
}

