/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.helpers;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.helpers.DefaultJavaEvaluator;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelVariant;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUAnnotation;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0016J\"\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016J-\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0(\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010)J+\u0010*\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0(\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020\rH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020/H\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010\r2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u000202H\u0016J#\u00103\u001a\b\u0012\u0004\u0012\u00020$0(2\u0006\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u00106J\u001e\u00103\u001a\b\u0012\u0004\u0012\u000208072\u0006\u00104\u001a\u0002092\u0006\u00105\u001a\u00020\u0010H\u0016J\u0014\u0010:\u001a\u0004\u0018\u00010;2\b\u0010<\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010<\u001a\u00020 H\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020;H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u00020/H\u0016J\u0012\u0010?\u001a\u0004\u0018\u00010\u000e2\u0006\u0010@\u001a\u000202H\u0016J\u0012\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010A\u001a\u0004\u0018\u00010\u00052\u0006\u0010B\u001a\u00020CJ\u0012\u0010D\u001a\u0004\u0018\u00010\r2\u0006\u0010<\u001a\u00020 H\u0016J\u0012\u0010D\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020;H\u0016J\u0014\u0010E\u001a\u0004\u0018\u00010 2\b\u0010F\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010G\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010H\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\"\u0010I\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0010H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/tools/lint/helpers/DefaultJavaEvaluator;", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "myProject", "Lcom/intellij/openapi/project/Project;", "myLintProject", "Lcom/android/tools/lint/detector/api/Project;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/lint/detector/api/Project;)V", "dependencies", "Lcom/android/tools/lint/model/LintModelDependencies;", "getDependencies", "()Lcom/android/tools/lint/model/LintModelDependencies;", "packageInfoCache", "", "", "Lcom/intellij/psi/PsiPackage;", "areSignaturesEqual", "", "method1", "Lcom/intellij/psi/PsiMethod;", "method2", "computeArgumentMapping", "", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiParameter;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "erasure", "Lcom/intellij/psi/PsiType;", "type", "extendsClass", "cls", "Lcom/intellij/psi/PsiClass;", "className", "strict", "findAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "listOwner", "Lcom/intellij/psi/PsiModifierListOwner;", "annotationNames", "", "(Lcom/intellij/psi/PsiModifierListOwner;[Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "findAnnotationInHierarchy", "findClass", "qualifiedName", "findJarPath", "element", "Lcom/intellij/psi/PsiElement;", "containingFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/uast/UElement;", "getAllAnnotations", "owner", "inHierarchy", "(Lcom/intellij/psi/PsiModifierListOwner;Z)[Lcom/intellij/psi/PsiAnnotation;", "", "Lorg/jetbrains/uast/UAnnotation;", "Lorg/jetbrains/uast/UAnnotated;", "getClassType", "Lcom/intellij/psi/PsiClassType;", "psiClass", "getInternalName", "psiClassType", "getPackage", "node", "getProject", "file", "Ljava/io/File;", "getQualifiedName", "getTypeClass", "psiType", "implementsInterface", "interfaceName", "inheritsFrom", "android.sdktools.lint-api"})
public class DefaultJavaEvaluator
extends JavaEvaluator {
    private final Map<String, PsiPackage> packageInfoCache;
    private final com.intellij.openapi.project.Project myProject;
    private final Project myLintProject;

    @Override
    @Nullable
    public LintModelDependencies getDependencies() {
        LintModelVariant variant;
        if (this.myLintProject != null && this.myLintProject.isAndroidProject() && (variant = this.myLintProject.getBuildVariant()) != null) {
            return variant.getMainArtifact().getDependencies();
        }
        return null;
    }

    @Override
    public boolean extendsClass(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    public boolean implementsInterface(@NotNull PsiClass cls, @NotNull String interfaceName, boolean strict) {
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)interfaceName);
    }

    @Override
    public boolean inheritsFrom(@Nullable PsiClass cls, @NotNull String className, boolean strict) {
        if (cls == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)cls, (boolean)strict, (String)className);
    }

    @Override
    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName) {
        com.intellij.openapi.project.Project project = this.myProject;
        if (project == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).findClass(qualifiedName, GlobalSearchScope.allScope((com.intellij.openapi.project.Project)this.myProject));
    }

    @Override
    @Nullable
    public PsiClassType getClassType(@Nullable PsiClass psiClass) {
        return this.myProject != null && psiClass != null ? JavaPsiFacade.getElementFactory((com.intellij.openapi.project.Project)this.myProject).createType(psiClass) : null;
    }

    @Override
    @Nullable
    public PsiClass getTypeClass(@Nullable PsiType psiType) {
        PsiType psiType2 = psiType;
        if (!(psiType2 instanceof PsiClassType)) {
            psiType2 = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType2;
        return psiClassType != null ? psiClassType.resolve() : null;
    }

    @Override
    @NotNull
    public List<UAnnotation> getAllAnnotations(@NotNull UAnnotated owner, boolean inHierarchy) {
        if (owner instanceof UDeclaration) {
            List annotations = owner.getUAnnotations();
            PsiAnnotation[] psiAnnotations = this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
            PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])annotations;
            boolean bl = false;
            if (!psiAnnotationArray.isEmpty()) {
                psiAnnotationArray = psiAnnotations;
                bl = false;
                if (psiAnnotationArray.length == 0) {
                    return annotations;
                }
                boolean modified = false;
                LinkedHashMap map = new LinkedHashMap();
                for (UAnnotation annotation : annotations) {
                    String string = annotation.getQualifiedName();
                    if (string == null) {
                        UIdentifier uIdentifier = annotation.getUastAnchor();
                        string = uIdentifier != null ? uIdentifier.getName() : null;
                    }
                    if (string == null) {
                        continue;
                    }
                    String name = string;
                    ((Map)map).put(name, annotation);
                }
                for (PsiAnnotation psi : psiAnnotations) {
                    String signature;
                    if (psi.getQualifiedName() == null) {
                        continue;
                    }
                    if (map.get(signature) != null) continue;
                    ((Map)map).put(signature, JavaUAnnotation.Companion.wrap(psi));
                    modified = true;
                }
                return modified ? CollectionsKt.toList((Iterable)map.values()) : annotations;
            }
            return JavaUAnnotation.Companion.wrap(psiAnnotations);
        }
        return owner.getUAnnotations();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner owner, boolean inHierarchy) {
        if (owner instanceof UDeclaration) {
            return this.getAllAnnotations(((UDeclaration)owner).getPsi(), inHierarchy);
        }
        return AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)inHierarchy, null, (boolean)false);
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, String ... annotationNames) {
        if (listOwner instanceof UDeclaration) {
            return this.findAnnotationInHierarchy(((UDeclaration)listOwner).getPsi(), Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)listOwner, (Set)Sets.newHashSet((Object[])Arrays.copyOf(annotationNames, annotationNames.length)));
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (listOwner instanceof UDeclaration) {
            return this.findAnnotation(((UDeclaration)listOwner).getPsi(), Arrays.copyOf(annotationNames, annotationNames.length));
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)listOwner, (boolean)false, (String[])Arrays.copyOf(annotationNames, annotationNames.length));
    }

    @Override
    public boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)method1, (PsiMethod)method2);
    }

    @Override
    @Nullable
    public Project getProject(@NotNull PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile virtualFile = psiFile;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
        return this.getProject(file);
    }

    @Nullable
    public final Project getProject(@NotNull File file) {
        Object v1;
        Object object = this.myLintProject;
        if (object == null || (object = ((Project)object).getClient()) == null || (object = ((LintClient)object).getKnownProjects()) == null) {
            return null;
        }
        Collection<Project> projects = object;
        if (projects.isEmpty()) {
            return null;
        }
        String path2 = file.getPath();
        Sequence $this$maxBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)projects), (Function1)((Function1)new Function1<Project, Boolean>(path2){
            final /* synthetic */ String $path;

            public final boolean invoke(@NotNull Project it) {
                return Intrinsics.areEqual((Object)this.$path, (Object)it.getDir().getPath()) || StringsKt.startsWith$default((String)this.$path, (String)(it.getDir().getPath() + File.separator), (boolean)false, (int)2, null);
            }
            {
                this.$path = string;
                super(1);
            }
        }));
        boolean $i$f$maxBy = false;
        Sequence $this$maxByOrNull$iv$iv = $this$maxBy$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv$iv = iterator$iv$iv.next();
            if (!iterator$iv$iv.hasNext()) {
                v1 = maxElem$iv$iv;
            } else {
                Project it = (Project)maxElem$iv$iv;
                boolean bl = false;
                int maxValue$iv$iv = it.getDir().getPath().length();
                do {
                    Object e$iv$iv = iterator$iv$iv.next();
                    Project it2 = (Project)e$iv$iv;
                    $i$a$-maxBy-DefaultJavaEvaluator$getProject$2 = false;
                    int v$iv$iv = it2.getDir().getPath().length();
                    if (maxValue$iv$iv >= v$iv$iv) continue;
                    maxElem$iv$iv = e$iv$iv;
                    maxValue$iv$iv = v$iv$iv;
                } while (iterator$iv$iv.hasNext());
                v1 = maxElem$iv$iv;
            }
        }
        return v1;
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return this.findJarPath(containingFile);
    }

    @Override
    @Nullable
    public String findJarPath(@NotNull UElement element) {
        UFile uFile = UastUtils.getContainingUFile((UElement)element);
        return uFile != null ? this.findJarPath(uFile.getSourcePsi()) : null;
    }

    private final String findJarPath(PsiFile containingFile) {
        String path2;
        int separatorIndex;
        VirtualFile file;
        if (containingFile instanceof PsiCompiledFile && (file = ((PsiCompiledFile)containingFile).getVirtualFile()) != null && Intrinsics.areEqual((Object)file.getFileSystem().getProtocol(), (Object)"jar") && (separatorIndex = StringsKt.indexOf$default((CharSequence)(path2 = file.getPath()), (String)"!/", (int)0, (boolean)false, (int)6, null)) >= 0) {
            String string = path2;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, separatorIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull PsiElement node) {
        PsiFile containingFile;
        PsiFile psiFile;
        PsiElement psiElement = node;
        if (!(psiElement instanceof PsiFile)) {
            psiElement = null;
        }
        if ((psiFile = (PsiFile)psiElement) == null) {
            psiFile = containingFile = node.getContainingFile();
        }
        if (containingFile != null) {
            if (containingFile instanceof PsiJavaFile) {
                return this.packageInfoCache.computeIfAbsent(((PsiJavaFile)containingFile).getPackageName(), new Function<String, PsiPackage>(this, node){
                    final /* synthetic */ DefaultJavaEvaluator this$0;
                    final /* synthetic */ PsiElement $node;

                    @NotNull
                    public final PsiPackage apply(@NotNull String name) {
                        PsiClass cls;
                        PsiClass psiClass = cls = this.this$0.findClass(name + '.' + "package-info");
                        PsiModifierList modifierList = psiClass != null ? psiClass.getModifierList() : null;
                        return (PsiPackage)new PsiPackageImpl(this, modifierList, name, this.$node.getManager(), name){
                            final /* synthetic */ getPackage.1 this$0;
                            final /* synthetic */ PsiModifierList $modifierList;
                            final /* synthetic */ String $name;

                            @Nullable
                            public PsiModifierList getAnnotationList() {
                                return this.$modifierList != null ? (PsiModifierList)new PsiCompositeModifierList(this.getManager(), CollectionsKt.listOf((Object)this.$modifierList)) : null;
                            }
                            {
                                this.this$0 = this$0;
                                this.$modifierList = $captured_local_variable$1;
                                this.$name = $captured_local_variable$2;
                                super($super_call_param$3, $super_call_param$4);
                            }
                        };
                    }
                    {
                        this.this$0 = defaultJavaEvaluator;
                        this.$node = psiElement;
                    }
                });
            }
            PsiDirectory dir = containingFile.getParent();
            if (dir != null) {
                return JavaDirectoryService.getInstance().getPackage(dir);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PsiPackage getPackage(@NotNull UElement node) {
        UFile uFile = UastUtils.getContainingUFile((UElement)node);
        return uFile != null ? this.getPackage((PsiElement)uFile.getPsi()) : null;
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClassType psiClassType) {
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getQualifiedName((PsiClassType)erased) : super.getQualifiedName(psiClassType);
    }

    @Override
    @Nullable
    public String getQualifiedName(@NotNull PsiClass psiClass) {
        return psiClass.getQualifiedName();
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClassType psiClassType) {
        PsiType erased = this.erasure((PsiType)psiClassType);
        return erased instanceof PsiClassType ? super.getInternalName((PsiClassType)erased) : super.getInternalName(psiClassType);
    }

    @Override
    @Nullable
    public String getInternalName(@NotNull PsiClass psiClass) {
        return Lint.getInternalName(psiClass);
    }

    @Override
    @Nullable
    public PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure((PsiType)type);
    }

    @Override
    @NotNull
    public Map<UExpression, PsiParameter> computeArgumentMapping(@NotNull UCallExpression call, @NotNull PsiMethod method) {
        Object parameter;
        UExpression argument;
        int j;
        Object[] parameters;
        List arguments;
        block8: {
            block7: {
                String first;
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() == 0) {
                    return MapsKt.emptyMap();
                }
                Map<UExpression, PsiParameter> kotlinMap = Lint.computeKotlinArgumentMapping(call, method);
                if (kotlinMap != null) {
                    return kotlinMap;
                }
                arguments = call.getValueArguments();
                parameters = parameterList.getParameters();
                j = 0;
                PsiParameter psiParameter = (PsiParameter)ArraysKt.firstOrNull((Object[])parameters);
                String string = first = psiParameter != null ? psiParameter.getName() : null;
                if (string != null && StringsKt.startsWith$default((String)string, (String)"$this", (boolean)false, (int)2, null)) break block7;
                String string2 = first;
                if (string2 == null) break block8;
                if (!StringsKt.startsWith$default((String)string2, (String)"$self", (boolean)false, (int)2, null)) break block8;
            }
            if (Lint.isKotlin(call.getSourcePsi())) {
                ++j;
            }
        }
        int i = 0;
        int n = Math.min(parameters.length, arguments.size());
        HashMap map = new HashMap(2 * n);
        while (j < n) {
            argument = (UExpression)arguments.get(i);
            parameter = parameters[j];
            ((Map)map).put(argument, parameter);
            ++i;
            ++j;
        }
        if (i < arguments.size() && j > 0) {
            --j;
            while (i < arguments.size()) {
                argument = (UExpression)arguments.get(i);
                parameter = parameters[j];
                ((Map)map).put(argument, parameter);
                ++i;
            }
        }
        return map;
    }

    public DefaultJavaEvaluator(@Nullable com.intellij.openapi.project.Project myProject, @Nullable Project myLintProject) {
        this.myProject = myProject;
        this.myLintProject = myLintProject;
        boolean bl = false;
        this.packageInfoCache = new LinkedHashMap();
    }
}

