/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.XmlParser;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceContext;
import com.google.common.annotations.Beta;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0017\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J2\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020+J\u0016\u0010,\u001a\u00020-2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/J*\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u000105H\u0016J6\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020/2\b\u00106\u001a\u0004\u0018\u00010\u001d2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u000e2\n\b\u0002\u00104\u001a\u0004\u0018\u000105H\u0007J4\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020/2\b\u00106\u001a\u0004\u0018\u00010\u001d2\u0006\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u000107H\u0007R\u0010\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00068"}, d2={"Lcom/android/tools/lint/detector/api/XmlContext;", "Lcom/android/tools/lint/detector/api/ResourceContext;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "project", "Lcom/android/tools/lint/detector/api/Project;", "main", "file", "Ljava/io/File;", "folderType", "Lcom/android/resources/ResourceFolderType;", "parser", "Lcom/android/tools/lint/client/api/XmlParser;", "contents", "", "document", "Lorg/w3c/dom/Document;", "(Lcom/android/tools/lint/client/api/LintDriver;Lcom/android/tools/lint/detector/api/Project;Lcom/android/tools/lint/detector/api/Project;Ljava/io/File;Lcom/android/resources/ResourceFolderType;Lcom/android/tools/lint/client/api/XmlParser;Ljava/lang/String;Lorg/w3c/dom/Document;)V", "getParser", "()Lcom/android/tools/lint/client/api/XmlParser;", "resourceFolder", "getResourceFolder", "()Ljava/io/File;", "suppressCommentPrefix", "getSuppressCommentPrefix", "()Ljava/lang/String;", "createLocationHandle", "Lcom/android/tools/lint/detector/api/Location$Handle;", "node", "Lorg/w3c/dom/Node;", "getElementLocation", "Lcom/android/tools/lint/detector/api/Location;", "element", "Lorg/w3c/dom/Element;", "namespace", "attribute", "getLocation", "textNode", "begin", "", "end", "getNameLocation", "getValueLocation", "Lorg/w3c/dom/Attr;", "isSuppressedWithComment", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "report", "", "location", "message", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "scope", "", "android.sdktools.lint-api"})
@Beta
public class XmlContext
extends ResourceContext {
    @NotNull
    private final XmlParser parser;
    @JvmField
    @NotNull
    public final Document document;

    @NotNull
    public final Location getLocation(@NotNull Node node) {
        return this.parser.getLocation(this, node);
    }

    @NotNull
    public final Location getNameLocation(@NotNull Node node) {
        return this.parser.getNameLocation(this, node);
    }

    @NotNull
    public final Location getValueLocation(@NotNull Attr node) {
        return this.parser.getValueLocation(this, node);
    }

    @NotNull
    public final Location getElementLocation(@NotNull Element element, @Nullable Node node, @Nullable String namespace, @Nullable String attribute) {
        return this.parser.getElementLocation(this, element, node, namespace, attribute);
    }

    public static /* synthetic */ Location getElementLocation$default(XmlContext xmlContext, Element element, Node node, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getElementLocation");
        }
        if ((n & 2) != 0) {
            node = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return xmlContext.getElementLocation(element, node, string, string2);
    }

    @NotNull
    public final Location getElementLocation(@NotNull Element element) {
        return XmlParser.getElementLocation$default(this.parser, this, element, null, null, null, 28, null);
    }

    @NotNull
    public final Location getLocation(@NotNull Node textNode, int begin, int end) {
        boolean bl = textNode.getNodeType() == 3 || textNode.getNodeType() == 8;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.parser.getLocation(this, textNode, begin, end);
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @Nullable Node scope, @NotNull Location location, @NotNull String message2, @Nullable LintFix quickfixData) {
        if (scope != null && this.getDriver().isSuppressed(this, issue, scope)) {
            return;
        }
        super.doReport(issue, location, message2, quickfixData);
    }

    public static /* synthetic */ void report$default(XmlContext xmlContext, Issue issue, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        xmlContext.report(issue, node, location, string, lintFix);
    }

    @JvmOverloads
    public final void report(@NotNull Issue issue, @Nullable Node scope, @NotNull Location location, @NotNull String message2) {
        XmlContext.report$default(this, issue, scope, location, message2, null, 16, null);
    }

    @Deprecated(message="Here for temporary compatibility; the new typed quickfix data parameter should be used instead", replaceWith=@ReplaceWith(imports={}, expression="report(issue, scope, location, message)"))
    public final void report(@NotNull Issue issue, @Nullable Node scope, @NotNull Location location, @NotNull String message2, @Nullable Object quickfixData) {
        XmlContext.report$default(this, issue, scope, location, message2, null, 16, null);
    }

    @Override
    public void report(@NotNull Issue issue, @NotNull Location location, @NotNull String message2, @Nullable LintFix quickfixData) {
        Object source = location.getSource();
        if (source instanceof Node) {
            this.report(issue, (Node)source, location, message2, quickfixData);
            return;
        }
        if (this.getDriver().isSuppressed(this, issue, this.document)) {
            return;
        }
        super.report(issue, location, message2, quickfixData);
    }

    @Override
    @Nullable
    protected String getSuppressCommentPrefix() {
        return "<!--suppress ";
    }

    public final boolean isSuppressedWithComment(@NotNull Node node, @NotNull Issue issue) {
        if (this.getContents() == null) {
            return false;
        }
        int start = this.parser.getNodeStartOffset(this, node);
        if (start != -1) {
            return this.isSuppressedWithComment(start, issue);
        }
        return false;
    }

    @NotNull
    public final Location.Handle createLocationHandle(@NotNull Node node) {
        return this.parser.createLocationHandle(this, node);
    }

    @Override
    @Nullable
    protected File getResourceFolder() {
        return this.getResourceFolderType() != null ? this.file.getParentFile() : null;
    }

    @NotNull
    public final XmlParser getParser() {
        return this.parser;
    }

    public XmlContext(@NotNull LintDriver driver, @NotNull Project project, @Nullable Project main, @NotNull File file, @Nullable ResourceFolderType folderType, @NotNull XmlParser parser, @NotNull String contents, @NotNull Document document) {
        super(driver, project, main, file, folderType, contents);
        this.parser = parser;
        this.document = document;
    }
}

