/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/DataBindingDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableAttributes", "", "", "isVariableType", "", "elementName", "attributeName", "visitAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Companion", "android.sdktools.lint-checks"})
public final class DataBindingDetector
extends LayoutDetector {
    @JvmField
    @NotNull
    public static final Issue ESCAPE_XML;
    public static final Companion Companion;

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        return LayoutDetector.ALL;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        String elementName = attribute.getOwnerElement().getTagName();
        String attributeName = attribute.getName();
        if (Lint.isDataBindingExpression(attribute.getValue()) || this.isVariableType(elementName, attributeName)) {
            CharSequence charSequence = context2.getContents();
            if (charSequence == null) {
                return;
            }
            CharSequence rawText = charSequence;
            int start = context2.getParser().getNodeStartOffset(context2, attribute);
            if (start == -1) {
                return;
            }
            int end = Integer.min(rawText.length(), context2.getParser().getNodeEndOffset(context2, attribute));
            boolean isContained = false;
            int n = start;
            int n2 = end;
            while (n < n2) {
                void index;
                if (rawText.charAt((int)index) == '<') {
                    isContained = true;
                    break;
                }
                ++index;
            }
            if (isContained) {
                LintFix fix = this.fix().name("Change '<' to '&lt;'").replace().text("<").with("&lt;").build();
                context2.report(ESCAPE_XML, (Node)attribute, context2.getValueLocation(attribute), "`<` must be escaped (as `&lt;`) in attribute values", fix);
            }
        }
    }

    private final boolean isVariableType(String elementName, String attributeName) {
        return Intrinsics.areEqual((Object)elementName, (Object)"variable") && Intrinsics.areEqual((Object)attributeName, (Object)"type");
    }

    static {
        Companion = new Companion(null);
        ESCAPE_XML = Issue.Companion.create("XmlEscapeNeeded", "Missing XML Escape", "\n              When a string contains characters that have special usage in XML, \\\n              you must escape the characters.\n            ", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(DataBindingDetector.class, Scope.RESOURCE_FILE_SCOPE));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/DataBindingDetector$Companion;", "", "()V", "ESCAPE_XML", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

