/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.SdkConstants;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelDependencyGraph;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelVariant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/ConstraintLayoutDetector;", "Lcom/android/tools/lint/detector/api/LayoutDetector;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class ConstraintLayoutDetector
extends LayoutDetector {
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @JvmField
    @NotNull
    public static final GradleCoordinate LATEST_KNOWN_VERSION;
    public static final Companion Companion;

    @Override
    @Nullable
    public Collection<String> getApplicableElements() {
        return SetsKt.setOf((Object[])new String[]{SdkConstants.CONSTRAINT_LAYOUT.oldName(), SdkConstants.CONSTRAINT_LAYOUT.newName(), SdkConstants.MOTION_LAYOUT.oldName(), SdkConstants.MOTION_LAYOUT.newName()});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        LintModelVariant variant = context2.getMainProject().getBuildVariant();
        GradleCoordinate latestAvailable = null;
        if (variant != null) {
            GradleCoordinate version;
            LintModelMavenName rc;
            LintModelLibrary library;
            LintModelDependencyGraph dependencies = variant.getMainArtifact().getDependencies().getCompileDependencies();
            LintModelLibrary lintModelLibrary = dependencies.findLibrary("com.android.support.constraint:constraint-layout", true);
            if (lintModelLibrary == null) {
                lintModelLibrary = library = dependencies.findLibrary("androidx.constraintlayout:constraintlayout", true);
            }
            if (library != null && library instanceof LintModelExternalLibrary && Intrinsics.areEqual((Object)"com.android.support.constraint", (Object)(rc = ((LintModelExternalLibrary)library).getResolvedCoordinates()).getGroupId()) && Intrinsics.areEqual((Object)"constraint-layout", (Object)rc.getArtifactId()) && GradleCoordinate.COMPARE_PLUS_LOWER.compare(latestAvailable = ConstraintLayoutDetector.Companion.getLatestVersion(context2), version = new GradleCoordinate(rc.getGroupId(), rc.getArtifactId(), rc.getVersion())) > 0) {
                String message2 = "Using version " + version.getRevision() + " of the constraint library, which is obsolete";
                LintFix fix = this.fix().data(ConstraintLayoutDetector.class);
                context2.report(GradleDetector.DEPENDENCY, (Node)element, context2.getLocation(element), message2, fix);
            }
        }
        if (element.hasAttributeNS("http://schemas.android.com/apk/res-auto", "layoutDescription")) {
            return;
        }
        Node child = element.getFirstChild();
        ArrayList flowList = new ArrayList();
        while (child != null) {
            if (child.getNodeType() != 1) {
                child = child.getNextSibling();
                continue;
            }
            String elementTagName = ((Element)child).getTagName();
            if (Intrinsics.areEqual((Object)elementTagName, (Object)"android.support.constraint.helper.Flow") || Intrinsics.areEqual((Object)elementTagName, (Object)"androidx.constraintlayout.helper.widget.Flow")) {
                NamedNodeMap attributes = ((Element)child).getAttributes();
                int message2 = 0;
                int fix = attributes.getLength();
                while (message2 < fix) {
                    void i;
                    Node attribute = attributes.item((int)i);
                    if (attribute.getLocalName() == null) {
                    } else {
                        String name;
                        String value = attribute.getNodeValue();
                        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"constraint_referenced_ids", (boolean)false, (int)2, null)) {
                            flowList.addAll(StringsKt.split$default((CharSequence)value, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null));
                        }
                    }
                    ++i;
                }
            }
            child = ((Element)child).getNextSibling();
        }
        child = element.getFirstChild();
        while (child != null) {
            block28: {
                boolean isConstrainedVertically;
                boolean isConstrainedHorizontally;
                Element layout;
                block27: {
                    if (child.getNodeType() != 1) {
                        child = child.getNextSibling();
                        continue;
                    }
                    layout = (Element)child;
                    String elementTagName = layout.getTagName();
                    if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(elementTagName) || SdkConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEquals(elementTagName) || Intrinsics.areEqual((Object)"include", (Object)elementTagName) || Lint.isLayoutMarkerTag(elementTagName)) {
                        child = child.getNextSibling();
                        continue;
                    }
                    CharSequence i = elementTagName;
                    boolean fix = false;
                    if (!StringsKt.isBlank((CharSequence)i) && SdkConstants.CLASS_CONSTRAINT_LAYOUT_BARRIER.isEquals(elementTagName) && ConstraintLayoutDetector.Companion.scanForBarrierConstraint(layout)) break;
                    isConstrainedHorizontally = false;
                    isConstrainedVertically = false;
                    NamedNodeMap attributes = layout.getAttributes();
                    int name = 0;
                    int n = attributes.getLength();
                    while (name < n) {
                        void i2;
                        Node attribute = attributes.item((int)i2);
                        if (attribute.getLocalName() == null) {
                        } else {
                            String value;
                            String name2;
                            if (Intrinsics.areEqual((Object)"id", (Object)name2) && flowList.contains(value = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)attribute.getNodeValue(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null)))) {
                                isConstrainedHorizontally = true;
                                isConstrainedVertically = true;
                                break;
                            }
                            if (StringsKt.startsWith$default((String)name2, (String)"layout_", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name2, (String)"_creator", (boolean)false, (int)2, null)) {
                                if (Intrinsics.areEqual((Object)"layout_width", (Object)name2) && Intrinsics.areEqual((Object)"match_parent", (Object)attribute.getNodeValue()) || StringsKt.endsWith$default((String)name2, (String)"toLeftOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toRightOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toStartOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toEndOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toCenterX", (boolean)false, (int)2, null)) {
                                    isConstrainedHorizontally = true;
                                    if (isConstrainedVertically) {
                                        break;
                                    }
                                } else if (Intrinsics.areEqual((Object)"layout_height", (Object)name2) && Intrinsics.areEqual((Object)"match_parent", (Object)attribute.getNodeValue()) || StringsKt.endsWith$default((String)name2, (String)"toTopOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toBottomOf", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toCenterY", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name2, (String)"toBaselineOf", (boolean)false, (int)2, null)) {
                                    isConstrainedVertically = true;
                                    if (isConstrainedHorizontally) break;
                                }
                            }
                        }
                        ++i2;
                    }
                    if (!isConstrainedHorizontally) break block27;
                    if (isConstrainedVertically) break block28;
                }
                String message3 = isConstrainedVertically ? "This view is not constrained horizontally: at runtime it will jump to the left unless you add a horizontal constraint" : (isConstrainedHorizontally ? "This view is not constrained vertically: at runtime it will jump to the top unless you add a vertical constraint" : "This view is not constrained. It only has designtime positions, so it will jump to (0,0) at runtime unless you add the constraints");
                XmlContext.report$default(context2, ISSUE, layout, context2.getNameLocation(layout), message3, null, 16, null);
            }
            child = child.getNextSibling();
        }
    }

    static {
        Companion = new Companion(null);
        Collection collection = null;
        EnumSet enumSet = null;
        Boolean bl = true;
        boolean bl2 = false;
        Implementation implementation = new Implementation(ConstraintLayoutDetector.class, Scope.RESOURCE_FILE_SCOPE);
        Severity severity = Severity.ERROR;
        int n = 6;
        String string = null;
        Category category = Category.CORRECTNESS;
        ISSUE = Issue.Companion.create$default(Issue.Companion, "MissingConstraints", "Missing Constraints in ConstraintLayout", "\n                    The layout editor allows you to place widgets anywhere on the canvas, \\\n                    and it records the current position with designtime attributes (such as \\\n                    `layout_editor_absoluteX`). These attributes are **not** applied at \\\n                    runtime, so if you push your layout on a device, the widgets may appear \\\n                    in a different location than shown in the editor. To fix this, make sure \\\n                    a widget has both horizontal and vertical constraints by dragging from \\\n                    the edge connections.\n                    ", implementation, string, category, n, severity, bl2, bl, enumSet, collection, 3344, null);
        LATEST_KNOWN_VERSION = new GradleCoordinate("com.android.support.constraint", "constraint-layout", "1.0.2");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ConstraintLayoutDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "LATEST_KNOWN_VERSION", "Lcom/android/ide/common/repository/GradleCoordinate;", "getLATEST_KNOWN_VERSION$annotations", "getLatestVersion", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "scanForBarrierConstraint", "", "element", "Lorg/w3c/dom/Element;", "android.sdktools.lint-checks"})
    public static final class Companion {
        public static /* synthetic */ void getLATEST_KNOWN_VERSION$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        private final boolean scanForBarrierConstraint(Element element) {
            NamedNodeMap attributes = element.getAttributes();
            int n = 0;
            int n2 = attributes.getLength();
            while (n < n2) {
                String name;
                void i;
                Node attribute = attributes.item((int)i);
                if (attribute.getLocalName() == null) {
                } else if (StringsKt.endsWith$default((String)name, (String)"barrierDirection", (boolean)false, (int)2, null)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private final GradleCoordinate getLatestVersion(XmlContext context2) {
            GradleCoordinate fromPackage;
            ProgressIndicator progress;
            RepoPackage latestPackage;
            GradleCoordinate latestAvailable = LATEST_KNOWN_VERSION;
            AndroidSdkHandler sdkHandler = context2.getClient().getSdk();
            if (sdkHandler != null && (latestPackage = SdkMavenRepository.findLatestVersion((GradleCoordinate)LATEST_KNOWN_VERSION, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)(progress = context2.getClient().getRepositoryLogger()))) != null && (fromPackage = SdkMavenRepository.getCoordinateFromSdkPath((String)latestPackage.getPath())) != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(latestAvailable, fromPackage) < 0) {
                latestAvailable = fromPackage;
            }
            return latestAvailable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

