/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.internal.AbstractArchive;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class InstantAppBundleArchive
extends AbstractArchive {
    private final Path extractedFilesPath;

    private InstantAppBundleArchive(Path path2) throws IOException {
        super(path2);
        this.extractedFilesPath = Files.createTempDirectory(path2.getFileName().toString(), new FileAttribute[0]);
        this.extractArchiveContents(path2);
    }

    private void extractArchiveContents(Path artifact) throws IOException {
        try (FileSystem fileSystem = FileUtils.createZipFilesystem((Path)artifact);){
            Files.walkFileTree(fileSystem.getPath("/", new String[0]), new CopyPathFileVisitor(fileSystem, this.extractedFilesPath));
        }
    }

    public static InstantAppBundleArchive fromZippedBundle(Path path2) throws IOException {
        return new InstantAppBundleArchive(path2);
    }

    @Override
    public Path getContentRoot() {
        return this.extractedFilesPath;
    }

    @Override
    public void close() throws IOException {
        FileUtils.deletePath((File)this.extractedFilesPath.toFile());
    }

    private static class CopyPathFileVisitor
    implements FileVisitor<Path> {
        private final Path source;
        private final Path destination;

        public CopyPathFileVisitor(FileSystem source, Path destination) {
            this.source = source.getPath("/", new String[0]);
            this.destination = destination;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path resolved = this.destination.resolve(this.source.relativize(dir).toString()).normalize();
            if (resolved.startsWith(this.destination)) {
                Files.createDirectories(resolved, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.destination.resolve(this.source.relativize(file).toString()), new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

