/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.notNullVerification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

class AuxiliaryMethodGenerator {
    private static final String STRING_CLASS_NAME = "java/lang/String";
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String EXCEPTION_INIT_SIGNATURE = "(Ljava/lang/String;)V";
    private static final String REPORTING_METHOD_DESC = "(I)V";
    private final ClassReader myOriginalClass;
    private final boolean myIsInterface;
    private final List<ReportingPlace> myReportingPlaces = new ArrayList<ReportingPlace>();
    private String myReportingMethod;
    private int myMaxArgCount;

    AuxiliaryMethodGenerator(ClassReader originalClass) {
        this.myOriginalClass = originalClass;
        this.myIsInterface = (this.myOriginalClass.getAccess() & 0x200) == 512;
    }

    private String getReportingMethodName() {
        if (this.myReportingMethod == null) {
            this.myReportingMethod = this.suggestUniqueName();
        }
        return this.myReportingMethod;
    }

    private String suggestUniqueName() {
        Set<String> existingMethods = this.populateExistingMethods();
        int i = 0;
        String name;
        while (existingMethods.contains(name = "$$$reportNull$$$" + i)) {
            ++i;
        }
        return name;
    }

    private Set<String> populateExistingMethods() {
        final HashSet<String> existingMethods = new HashSet<String>();
        this.myOriginalClass.accept(new ClassVisitor(524288){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                existingMethods.add(name);
                return null;
            }
        }, 7);
        return existingMethods;
    }

    void reportError(MethodVisitor mv, String className, String exceptionClass, String descrPattern, String[] args) {
        this.myMaxArgCount = Math.max(this.myMaxArgCount, args.length);
        int index = this.myReportingPlaces.size();
        this.myReportingPlaces.add(new ReportingPlace(exceptionClass, descrPattern, args));
        AuxiliaryMethodGenerator.pushIntConstant(mv, index);
        mv.visitMethodInsn(184, className, this.getReportingMethodName(), REPORTING_METHOD_DESC, this.myIsInterface);
    }

    private static void pushIntConstant(MethodVisitor mv, int i) {
        if (i <= 5) {
            mv.visitInsn(AuxiliaryMethodGenerator.getSmallIntConstantInstruction(i));
        } else if (i <= 127) {
            mv.visitIntInsn(16, i);
        } else {
            mv.visitIntInsn(17, i);
        }
    }

    private static int getSmallIntConstantInstruction(int i) {
        switch (i) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        throw new AssertionError(i);
    }

    void generateReportingMethod(ClassVisitor cw) {
        if (this.myReportingPlaces.isEmpty()) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(4106, this.getReportingMethodName(), REPORTING_METHOD_DESC, null, null);
        this.pushExceptionMessage(mv);
        this.createExceptionObject(mv);
        mv.visitInsn(191);
        mv.visitMaxs(0, 0);
    }

    private void createExceptionObject(final MethodVisitor mv) {
        new SwitchGenerator<String>(){

            @Override
            void generateCaseBody(String exceptionClass) {
                mv.visitTypeInsn(187, exceptionClass);
                mv.visitInsn(90);
                mv.visitInsn(95);
                mv.visitMethodInsn(183, exceptionClass, AuxiliaryMethodGenerator.CONSTRUCTOR_NAME, AuxiliaryMethodGenerator.EXCEPTION_INIT_SIGNATURE, false);
            }

            @Override
            String getSwitchedValue(ReportingPlace place) {
                return place.exceptionClass;
            }
        }.generateSwitch(mv);
    }

    private void pushExceptionMessage(MethodVisitor mv) {
        this.pushFormatPattern(mv);
        this.createFormatArgArray(mv);
        for (int i = 0; i < this.myMaxArgCount; ++i) {
            this.pushFormatArg(mv, i);
        }
        mv.visitMethodInsn(184, STRING_CLASS_NAME, "format", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", false);
    }

    private void createFormatArgArray(final MethodVisitor mv) {
        new SwitchGenerator<Integer>(){

            @Override
            void generateCaseBody(Integer argCount) {
                AuxiliaryMethodGenerator.pushIntConstant(mv, argCount);
            }

            @Override
            Integer getSwitchedValue(ReportingPlace place) {
                return place.args.length;
            }
        }.generateSwitch(mv);
        mv.visitTypeInsn(189, OBJECT_CLASS_NAME);
    }

    private void pushFormatArg(final MethodVisitor mv, final int index) {
        new SwitchGenerator<String>(){

            @Override
            protected String getSwitchedValue(ReportingPlace place) {
                return index < place.args.length ? place.args[index] : null;
            }

            @Override
            void generateCaseBody(String value) {
                if (value != null) {
                    mv.visitInsn(89);
                    AuxiliaryMethodGenerator.pushIntConstant(mv, index);
                    mv.visitLdcInsn((Object)value);
                    mv.visitInsn(83);
                }
            }
        }.generateSwitch(mv);
    }

    private void pushFormatPattern(final MethodVisitor mv) {
        new SwitchGenerator<String>(){

            @Override
            protected String getSwitchedValue(ReportingPlace place) {
                return place.descrPattern;
            }

            @Override
            void generateCaseBody(String descrPattern) {
                mv.visitLdcInsn((Object)descrPattern);
            }
        }.generateSwitch(mv);
    }

    private abstract class SwitchGenerator<T> {
        private SwitchGenerator() {
        }

        void generateSwitch(MethodVisitor mv) {
            Label[] labels = this.getCaseLabels();
            if (labels == null) {
                this.generateCaseBody(this.getSwitchedValue((ReportingPlace)AuxiliaryMethodGenerator.this.myReportingPlaces.get(0)));
            } else {
                this.reallyGenerateSwitch(mv, labels, this.deduplicateLabels(labels));
            }
        }

        private void reallyGenerateSwitch(MethodVisitor mv, Label[] labels, Map<Label, ReportingPlace> label2Place) {
            Label afterSwitch = new Label();
            mv.visitVarInsn(21, 0);
            mv.visitTableSwitchInsn(0, labels.length - 1, labels[0], labels);
            for (Map.Entry<Label, ReportingPlace> entry : label2Place.entrySet()) {
                mv.visitLabel(entry.getKey());
                this.generateCaseBody(this.getSwitchedValue(entry.getValue()));
                mv.visitJumpInsn(167, afterSwitch);
            }
            mv.visitLabel(afterSwitch);
        }

        private Map<Label, ReportingPlace> deduplicateLabels(Label[] labels) {
            LinkedHashMap<Label, ReportingPlace> label2Place = new LinkedHashMap<Label, ReportingPlace>();
            for (int i = 0; i < labels.length; ++i) {
                if (label2Place.containsKey(labels[i])) continue;
                label2Place.put(labels[i], (ReportingPlace)AuxiliaryMethodGenerator.this.myReportingPlaces.get(i));
            }
            return label2Place;
        }

        private Label[] getCaseLabels() {
            HashMap labelsByValue = new HashMap();
            Label[] labels = new Label[AuxiliaryMethodGenerator.this.myReportingPlaces.size()];
            for (int i = 0; i < AuxiliaryMethodGenerator.this.myReportingPlaces.size(); ++i) {
                labels[i] = this.getOrCreateLabel(labelsByValue, this.getSwitchedValue((ReportingPlace)AuxiliaryMethodGenerator.this.myReportingPlaces.get(i)));
            }
            return labelsByValue.size() == 1 ? null : labels;
        }

        private Label getOrCreateLabel(Map<T, Label> labelsByValue, T key) {
            Label label = labelsByValue.get(key);
            if (label == null) {
                label = new Label();
                labelsByValue.put(key, label);
            }
            return label;
        }

        abstract void generateCaseBody(T var1);

        abstract T getSwitchedValue(ReportingPlace var1);
    }

    private static class ReportingPlace {
        final String exceptionClass;
        final String descrPattern;
        final String[] args;

        ReportingPlace(String exceptionClass, String descrPattern, String[] args) {
            this.exceptionClass = exceptionClass;
            this.descrPattern = descrPattern;
            this.args = args;
        }
    }
}

