/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.jvm.JvmLibrary;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.plugins.ide.internal.resolver.GradleApiSourcesResolver;

public class DefaultGradleApiSourcesResolver
implements GradleApiSourcesResolver {
    private static final String GRADLE_LIBS_REPO_URL = "https://repo.gradle.org/gradle/list/libs-releases";
    private static final String GRADLE_LIBS_REPO_OVERRIDE_VAR = "GRADLE_LIBS_REPO_OVERRIDE";
    private final Project project;

    public DefaultGradleApiSourcesResolver(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File resolveLocalGroovySources(String jarName) {
        String version = jarName.replace("groovy-all-", "").replace(".jar", "");
        MavenArtifactRepository repository = this.addGradleLibsRepository();
        try {
            File file = this.downloadLocalGroovySources(version);
            return file;
        }
        finally {
            this.project.getRepositories().remove(repository);
        }
    }

    private File downloadLocalGroovySources(String version) {
        ArtifactResolutionResult result = this.project.getDependencies().createArtifactResolutionQuery().forModule("org.gradle.groovy", "groovy-all", version).withArtifacts(JvmLibrary.class, Collections.singletonList(SourcesArtifact.class)).execute();
        for (ComponentArtifactsResult artifactsResult : result.getResolvedComponents()) {
            for (ArtifactResult artifactResult : artifactsResult.getArtifacts(SourcesArtifact.class)) {
                if (!(artifactResult instanceof ResolvedArtifactResult)) continue;
                return ((ResolvedArtifactResult)artifactResult).getFile();
            }
        }
        return null;
    }

    private MavenArtifactRepository addGradleLibsRepository() {
        return this.project.getRepositories().maven(a -> {
            a.setName("Gradle Libs");
            a.setUrl(DefaultGradleApiSourcesResolver.gradleLibsRepoUrl());
        });
    }

    private static String gradleLibsRepoUrl() {
        String repoOverride = System.getenv(GRADLE_LIBS_REPO_OVERRIDE_VAR);
        return repoOverride != null ? repoOverride : GRADLE_LIBS_REPO_URL;
    }
}

