/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.internal.precompiled;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.configuration.CompileOperationFactory;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.ScriptCompilationHandler;
import org.gradle.initialization.ClassLoaderScopeRegistry;
import org.gradle.internal.Actions;
import org.gradle.plugin.devel.internal.precompiled.PrecompiledGroovyScript;
import org.gradle.plugin.use.internal.PluginsAwareScript;

@CacheableTask
abstract class ExtractPluginRequestsTask
extends DefaultTask {
    private final ScriptCompilationHandler scriptCompilationHandler;
    private final CompileOperationFactory compileOperationFactory;
    private final FileSystemOperations fileSystemOperations;
    private final ClassLoaderScope classLoaderScope;

    @Inject
    public ExtractPluginRequestsTask(ScriptCompilationHandler scriptCompilationHandler, ClassLoaderScopeRegistry classLoaderScopeRegistry, CompileOperationFactory compileOperationFactory, FileSystemOperations fileSystemOperations) {
        this.scriptCompilationHandler = scriptCompilationHandler;
        this.compileOperationFactory = compileOperationFactory;
        this.classLoaderScope = classLoaderScopeRegistry.getCoreAndPluginsScope();
        this.fileSystemOperations = fileSystemOperations;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @SkipWhenEmpty
    abstract ConfigurableFileCollection getScriptFiles();

    @OutputDirectory
    abstract DirectoryProperty getExtractedPluginRequestsClassesDirectory();

    @Internal
    abstract ListProperty<PrecompiledGroovyScript> getScriptPlugins();

    @TaskAction
    void extractPluginsBlocks() {
        this.fileSystemOperations.delete(spec -> spec.delete(this.getExtractedPluginRequestsClassesDirectory()));
        ((Directory)this.getExtractedPluginRequestsClassesDirectory().get()).getAsFile().mkdirs();
        for (PrecompiledGroovyScript scriptPlugin : (List)this.getScriptPlugins().get()) {
            this.compilePluginsBlock(scriptPlugin);
        }
    }

    private void compilePluginsBlock(PrecompiledGroovyScript scriptPlugin) {
        CompileOperation<?> pluginsCompileOperation = this.compileOperationFactory.getPluginsBlockCompileOperation(scriptPlugin.getScriptTarget());
        File outputDir = ((Directory)this.getExtractedPluginRequestsClassesDirectory().get()).dir(scriptPlugin.getId()).getAsFile();
        this.scriptCompilationHandler.compileToDir(scriptPlugin.getSource(), this.classLoaderScope.getExportClassLoader(), outputDir, outputDir, pluginsCompileOperation, PluginsAwareScript.class, Actions.doNothing());
    }
}

