/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.routes;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.play.internal.platform.PlayMajorVersion;
import org.gradle.play.internal.routes.RoutesCompilerAdapterV23X;
import org.gradle.play.internal.routes.RoutesCompilerAdapterV24X;
import org.gradle.play.internal.routes.VersionedRoutesCompilerAdapter;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.util.VersionNumber;

public class RoutesCompilerAdapterFactory {
    private static final Logger LOGGER = Logging.getLogger(RoutesCompilerAdapterFactory.class);

    public static VersionedRoutesCompilerAdapter createAdapter(PlayPlatform playPlatform) {
        String playVersion = playPlatform.getPlayVersion();
        String scalaVersion = playPlatform.getScalaPlatform().getScalaCompatibilityVersion();
        switch (PlayMajorVersion.forPlatform(playPlatform)) {
            case PLAY_2_3_X: {
                return new RoutesCompilerAdapterV23X(playVersion);
            }
            case PLAY_2_4_X: {
                if (VersionNumber.parse(playVersion).getMicro() < 6 && !"2.10".equals(scalaVersion)) {
                    LOGGER.warn("Asked to use scala version " + scalaVersion + " on play < 2.4.6. Will have to use the 2.10 routes compiler");
                    scalaVersion = "2.10";
                }
                return new RoutesCompilerAdapterV24X(playVersion, scalaVersion);
            }
            case PLAY_2_5_X: 
            case PLAY_2_6_X: {
                return new RoutesCompilerAdapterV24X(playVersion, scalaVersion);
            }
        }
        throw new RuntimeException("Could not create routes compile spec for Play version: " + playVersion);
    }
}

