/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.BuildLayoutParametersBuildOptions;
import org.gradle.initialization.ParallelismBuildOptions;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.util.CollectionUtils;

public class LayoutToPropertiesConverter {
    private final List<BuildOption<?>> allBuildOptions = new ArrayList();
    private final BuildLayoutFactory buildLayoutFactory;

    public LayoutToPropertiesConverter(BuildLayoutFactory buildLayoutFactory) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.allBuildOptions.addAll(BuildLayoutParametersBuildOptions.get());
        this.allBuildOptions.addAll(StartParameterBuildOptions.get());
        this.allBuildOptions.addAll(LoggingConfigurationBuildOptions.get());
        this.allBuildOptions.addAll(DaemonBuildOptions.get());
        this.allBuildOptions.addAll(ParallelismBuildOptions.get());
    }

    public Map<String, String> convert(BuildLayoutParameters layout, Map<String, String> properties) {
        this.configureFromHomeDir(layout.getGradleInstallationHomeDir(), properties);
        this.configureFromBuildDir(layout.getSearchDir(), layout.getSearchUpwards(), properties);
        this.configureFromHomeDir(layout.getGradleUserHomeDir(), properties);
        this.configureFromSystemproperties((Map)Cast.uncheckedNonnullCast(properties));
        return properties;
    }

    private void configureFromSystemproperties(Map<Object, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Serializable) || !(value instanceof Serializable) && value != null) continue;
            properties.put(key, value);
        }
    }

    private void configureFromHomeDir(File gradleUserHomeDir, Map<String, String> result) {
        this.maybeConfigureFrom(new File(gradleUserHomeDir, "gradle.properties"), result);
    }

    private void configureFromBuildDir(File currentDir, boolean searchUpwards, Map<String, String> result) {
        BuildLayout layout = this.buildLayoutFactory.getLayoutFor(currentDir, searchUpwards);
        this.maybeConfigureFrom(new File(layout.getRootDirectory(), "gradle.properties"), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeConfigureFrom(@Nullable File propertiesFile, Map<String, String> result) {
        if (propertiesFile != null && !propertiesFile.isFile()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (final Object key : properties.keySet()) {
            BuildOption<?> validOption = CollectionUtils.findFirst(this.allBuildOptions, new Spec<BuildOption<?>>(){

                @Override
                public boolean isSatisfiedBy(BuildOption<?> option) {
                    return option.getGradleProperty() != null ? option.getGradleProperty().equals(key.toString()) : false;
                }
            });
            if (validOption == null) continue;
            result.put(key.toString(), properties.get(key).toString());
        }
    }
}

