/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.typeconversion.CharSequenceNotationConverter;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.TypeConverter;

public class DefaultTypeConverter
implements TypeConverter {
    private static final Map<Class<?>, Class<?>> UNBOXED_TYPES = ImmutableMap.builder().put(Byte.class, Byte.TYPE).put(Short.class, Short.TYPE).put(Integer.class, Integer.TYPE).put(Boolean.class, Boolean.TYPE).put(Float.class, Float.TYPE).put(Character.class, Character.TYPE).put(Double.class, Double.TYPE).put(Long.class, Long.TYPE).build();
    private final Map<Class<?>, NotationParser<Object, ?>> parsers = Maps.newHashMap();

    private static <T> NotationParser<Object, T> build(NotationConverter<Object, T> converter, Class<T> type) {
        return NotationParserBuilder.toType(type).noImplicitConverters().converter(converter).toComposite();
    }

    private <T> void registerConverter(NotationConverter<Object, T> converter, Class<T> type) {
        this.parsers.put(type, DefaultTypeConverter.build(converter, type));
    }

    private <T> void registerStringConverter(NotationConverter<String, T> converter, Class<T> type) {
        this.parsers.put(type, DefaultTypeConverter.build(new CharSequenceNotationConverter(converter), type));
    }

    private void registerConverters() {
        this.registerConverter(new DoubleNumberConverter(Double.class), Double.class);
        this.registerConverter(new DoubleNumberConverter(Double.TYPE), Double.TYPE);
        this.registerConverter(new FloatNumberConverter(Float.class), Float.class);
        this.registerConverter(new FloatNumberConverter(Float.TYPE), Float.TYPE);
        this.registerConverter(new IntegerNumberConverter(Integer.class), Integer.class);
        this.registerConverter(new IntegerNumberConverter(Integer.TYPE), Integer.TYPE);
        this.registerConverter(new LongNumberConverter(Long.class), Long.class);
        this.registerConverter(new LongNumberConverter(Long.TYPE), Long.TYPE);
        this.registerConverter(new ShortNumberConverter(Short.class), Short.class);
        this.registerConverter(new ShortNumberConverter(Short.TYPE), Short.TYPE);
        this.registerConverter(new ByteNumberConverter(Byte.class), Byte.class);
        this.registerConverter(new ByteNumberConverter(Byte.TYPE), Byte.TYPE);
        this.registerConverter(new BigDecimalNumberConverter(), BigDecimal.class);
        this.registerConverter(new BigIntegerNumberConverter(), BigInteger.class);
        BooleanConverter booleanConverter = new BooleanConverter();
        this.registerStringConverter(booleanConverter, Boolean.class);
        this.registerStringConverter(booleanConverter, Boolean.TYPE);
        this.registerStringConverter(new CharacterConverter(Character.class, Character.class), Character.class);
        this.registerStringConverter(new CharacterConverter(Character.class, Character.TYPE), Character.TYPE);
        this.registerConverter(new StringConverter(), String.class);
    }

    public DefaultTypeConverter(final PathToFileResolver fileResolver) {
        this.registerConverter(new CharSequenceNotationConverter(new CharSequenceConverter<File>(File.class){

            @Override
            public void convert(String notation, NotationConvertResult<? super File> result) throws TypeConversionException {
                result.converted(fileResolver.resolve(notation));
            }
        }), File.class);
        this.registerConverters();
    }

    @Override
    public Object convert(Object notation, Class<?> type, boolean primitive) throws TypeConversionException {
        if (type.isInstance(notation)) {
            return notation;
        }
        if (!primitive && notation == null) {
            return null;
        }
        if (type.isEnum()) {
            return this.convertEnum((Class)Cast.uncheckedCast(type), notation);
        }
        NotationParser<Object, ?> parser = this.parsers.get(primitive ? UNBOXED_TYPES.get(type) : type);
        if (parser == null) {
            throw new IllegalArgumentException("Don't know how to convert to type " + type.getName());
        }
        return parser.parseNotation(notation);
    }

    private <T extends Enum<T>> T convertEnum(Class<T> type, Object notation) {
        return (T)((Enum)NotationParserBuilder.toType(type).noImplicitConverters().fromCharSequence(new EnumFromCharSequenceNotationParser<T>(type)).toComposite().parseNotation(notation));
    }

    private static class CharacterConverter
    extends CharSequenceConverter<Character> {
        private final Class<Character> target;

        public CharacterConverter(Class<Character> boxed, Class<Character> target) {
            super(boxed);
            this.target = target;
        }

        @Override
        public void convert(String notation, NotationConvertResult<? super Character> result) throws TypeConversionException {
            if (notation.length() != 1) {
                throw new TypeConversionException(String.format("Cannot convert string value '%s' with length %d to type %s", notation, notation.length(), this.target.getSimpleName()));
            }
            result.converted(Character.valueOf(notation.charAt(0)));
        }
    }

    private static class BooleanConverter
    extends CharSequenceConverter<Boolean> {
        public BooleanConverter() {
            super(Boolean.class);
        }

        @Override
        public void convert(String notation, NotationConvertResult<? super Boolean> result) throws TypeConversionException {
            result.converted((Boolean)"true".equals(notation));
        }
    }

    private static class BigIntegerNumberConverter
    extends NumberConverter<BigInteger> {
        public BigIntegerNumberConverter() {
            super(BigInteger.class);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super BigInteger> result) {
            result.converted(n.toBigIntegerExact());
        }
    }

    private static class BigDecimalNumberConverter
    extends NumberConverter<BigDecimal> {
        public BigDecimalNumberConverter() {
            super(BigDecimal.class);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super BigDecimal> result) {
            result.converted(n);
        }
    }

    private static class ByteNumberConverter
    extends NumberConverter<Byte> {
        public ByteNumberConverter(Class<Byte> cl) {
            super(cl);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super Byte> result) {
            result.converted((Byte)n.byteValueExact());
        }
    }

    private static class ShortNumberConverter
    extends NumberConverter<Short> {
        public ShortNumberConverter(Class<Short> cl) {
            super(cl);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super Short> result) {
            result.converted((Short)n.shortValueExact());
        }
    }

    private static class LongNumberConverter
    extends NumberConverter<Long> {
        public LongNumberConverter(Class<Long> cl) {
            super(cl);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super Long> result) {
            result.converted((Long)n.longValueExact());
        }
    }

    private static class IntegerNumberConverter
    extends NumberConverter<Integer> {
        public IntegerNumberConverter(Class<Integer> cl) {
            super(cl);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super Integer> result) {
            result.converted((Integer)n.intValueExact());
        }
    }

    private static class FloatNumberConverter
    extends NumberConverter<Float> {
        public FloatNumberConverter(Class<Float> cl) {
            super(cl);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super Float> result) {
            result.converted(Float.valueOf(n.floatValue()));
        }
    }

    private static class DoubleNumberConverter
    extends NumberConverter<Double> {
        public DoubleNumberConverter(Class<Double> cl) {
            super(cl);
        }

        @Override
        protected void convertNumberToNumber(BigDecimal n, NotationConvertResult<? super Double> result) {
            result.converted((Double)n.doubleValue());
        }
    }

    private static abstract class NumberConverter<T extends Number>
    implements NotationConverter<Object, T> {
        private final Class<T> type;

        protected NumberConverter(Class<T> type) {
            this.type = type;
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("A String or CharSequence");
            visitor.candidate("Any Number");
        }

        @Override
        public void convert(Object notation, NotationConvertResult<? super T> result) throws TypeConversionException {
            if (notation instanceof CharSequence) {
                try {
                    this.convertNumberToNumber(new BigDecimal(notation.toString().trim()), result);
                }
                catch (ArithmeticException | NumberFormatException e) {
                    throw new TypeConversionException(String.format("Cannot convert value '%s' to type %s", notation, this.type.getSimpleName()), e);
                }
            }
            if (notation instanceof Number) {
                try {
                    this.convertNumberToNumber(NumberConverter.toBigDecimal((Number)notation), result);
                }
                catch (ArithmeticException e) {
                    throw new TypeConversionException(String.format("Cannot convert value '%s' to type %s", notation, this.type.getSimpleName()), e);
                }
            }
        }

        private static BigDecimal toBigDecimal(Number notation) {
            if (notation instanceof BigDecimal) {
                return (BigDecimal)notation;
            }
            if (notation instanceof BigInteger) {
                return new BigDecimal((BigInteger)notation);
            }
            if (notation instanceof Float) {
                return new BigDecimal(notation.floatValue());
            }
            if (notation instanceof Double) {
                return new BigDecimal(notation.doubleValue());
            }
            return new BigDecimal(notation.longValue());
        }

        protected abstract void convertNumberToNumber(BigDecimal var1, NotationConvertResult<? super T> var2);
    }

    private static class StringConverter
    implements NotationConverter<Object, String> {
        private StringConverter() {
        }

        @Override
        public void convert(Object notation, NotationConvertResult<? super String> result) throws TypeConversionException {
            if (notation instanceof CharSequence || notation instanceof Number || notation instanceof Boolean || notation instanceof Character || notation instanceof File) {
                result.converted(notation.toString());
            }
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("A String or CharSequence or Character");
            visitor.candidate("Any Number");
            visitor.candidate("A Boolean");
            visitor.candidate("A File");
        }
    }

    private static abstract class CharSequenceConverter<T>
    implements NotationConverter<String, T> {
        final Class<T> type;

        public CharSequenceConverter(Class<T> type) {
            this.type = type;
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("A String or CharSequence");
            visitor.candidate("A " + this.type.getSimpleName());
        }
    }
}

