/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Deque;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;

public class RelativePathStringTracker {
    private final Deque<String> relativePathStrings = Lists.newLinkedList();
    private boolean root = true;

    public void enter(CompleteFileSystemLocationSnapshot snapshot) {
        this.enter(snapshot.getName());
    }

    public void enter(String name) {
        if (!this.root) {
            String previous = this.relativePathStrings.peekLast();
            if (previous == null) {
                this.relativePathStrings.addLast(name);
            } else {
                this.relativePathStrings.addLast(previous + '/' + name);
            }
        }
        this.root = false;
    }

    public void leave() {
        if (!this.relativePathStrings.isEmpty()) {
            this.relativePathStrings.removeLast();
        }
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getRelativePathString() {
        return this.relativePathStrings.getLast();
    }
}

