/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.reflect.MessageFormattingTypeValidationContext;
import org.gradle.internal.reflect.TypeValidationContext;

public class DefaultTypeValidationContext
extends MessageFormattingTypeValidationContext {
    private final boolean cacheable;
    private final ImmutableMap.Builder<String, TypeValidationContext.Severity> problems = ImmutableMap.builder();

    public static DefaultTypeValidationContext withRootType(Class<?> rootType, boolean cacheable) {
        return new DefaultTypeValidationContext(rootType, cacheable);
    }

    public static DefaultTypeValidationContext withoutRootType(boolean cacheable) {
        return new DefaultTypeValidationContext(null, cacheable);
    }

    private DefaultTypeValidationContext(@Nullable Class<?> rootType, boolean cacheable) {
        super(rootType);
        this.cacheable = cacheable;
    }

    @Override
    protected void recordProblem(TypeValidationContext.Severity severity, String message) {
        if (severity == TypeValidationContext.Severity.CACHEABILITY_WARNING && !this.cacheable) {
            return;
        }
        this.problems.put((Object)message, (Object)severity.toReportableSeverity());
    }

    public ImmutableMap<String, TypeValidationContext.Severity> getProblems() {
        return this.problems.build();
    }
}

