/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.IncrementalChangesContext;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.UpToDateResult;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipUpToDateStep<C extends IncrementalChangesContext>
implements Step<C, UpToDateResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipUpToDateStep.class);
    private static final ImmutableList<String> CHANGE_TRACKING_DISABLED = ImmutableList.of((Object)"Change tracking is disabled.");
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public SkipUpToDateStep(Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public UpToDateResult execute(C context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Determining if {} is up-to-date", (Object)context.getWork().getDisplayName());
        }
        return context.getChanges().map(changes -> {
            ImmutableList<String> reasons = changes.getAllChangeMessages();
            if (reasons.isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Skipping {} as it is up-to-date.", (Object)context.getWork().getDisplayName());
                }
                final AfterPreviousExecutionState afterPreviousExecutionState = context.getAfterPreviousExecutionState().get();
                return new UpToDateResult(){

                    @Override
                    public ImmutableList<String> getExecutionReasons() {
                        return ImmutableList.of();
                    }

                    public ImmutableSortedMap<String, FileCollectionFingerprint> getFinalOutputs() {
                        return afterPreviousExecutionState.getOutputFileProperties();
                    }

                    @Override
                    public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                        return Optional.of(afterPreviousExecutionState.getOriginMetadata());
                    }

                    @Override
                    public Try<ExecutionOutcome> getOutcome() {
                        return Try.successful(ExecutionOutcome.UP_TO_DATE);
                    }
                };
            }
            return this.executeBecause(reasons, context);
        }).orElseGet(() -> this.executeBecause(CHANGE_TRACKING_DISABLED, context));
    }

    private UpToDateResult executeBecause(final ImmutableList<String> reasons, C context) {
        this.logExecutionReasons((List<String>)reasons, context.getWork());
        final CurrentSnapshotResult result = this.delegate.execute(context);
        return new UpToDateResult(){

            @Override
            public ImmutableList<String> getExecutionReasons() {
                return reasons;
            }

            @Override
            public ImmutableSortedMap<String, ? extends FileCollectionFingerprint> getFinalOutputs() {
                return result.getFinalOutputs();
            }

            @Override
            public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                return result.isReused() ? Optional.of(result.getOriginMetadata()) : Optional.empty();
            }

            @Override
            public Try<ExecutionOutcome> getOutcome() {
                return result.getOutcome();
            }
        };
    }

    private void logExecutionReasons(List<String> reasons, UnitOfWork work) {
        if (LOGGER.isInfoEnabled()) {
            Formatter formatter = new Formatter();
            formatter.format("%s is not up-to-date because:", StringUtils.capitalize((String)work.getDisplayName()));
            for (String message : reasons) {
                formatter.format("%n  %s", message);
            }
            LOGGER.info(formatter.toString());
        }
    }
}

