/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.NoMatchingCapabilitiesException;
import org.gradle.internal.component.NoMatchingConfigurationSelectionException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ShadowedCapability;
import org.gradle.internal.component.external.model.ShadowedCapabilityOnly;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DescriberSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.SelectedByVariantMatchingConfigurationMetadata;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public abstract class AttributeConfigurationSelector {
    public static ConfigurationMetadata selectConfigurationUsingAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        return AttributeConfigurationSelector.selectConfigurationUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponent, consumerSchema, requestedArtifacts, AttributeMatchingExplanationBuilder.logging());
    }

    private static ConfigurationMetadata selectConfigurationUsingAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentResolveMetadata targetComponent, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts, AttributeMatchingExplanationBuilder explanationBuilder) {
        AttributeDescriber describer;
        List<ConfigurationMetadata> matches;
        Optional<ImmutableList<? extends ConfigurationMetadata>> variantsForGraphTraversal = targetComponent.getVariantsForGraphTraversal();
        ImmutableList<ConfigurationMetadata> consumableConfigurations = (ImmutableList<ConfigurationMetadata>)variantsForGraphTraversal.or((Object)ImmutableList.of());
        AttributesSchemaInternal producerAttributeSchema = targetComponent.getAttributesSchema();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(producerAttributeSchema);
        ConfigurationMetadata fallbackConfiguration = targetComponent.getConfiguration("default");
        if (fallbackConfiguration != null && !fallbackConfiguration.isCanBeConsumed()) {
            fallbackConfiguration = null;
        }
        ModuleVersionIdentifier versionId = targetComponent.getModuleVersionId();
        if (!consumableConfigurations.isEmpty()) {
            ImmutableList<ConfigurationMetadata> variantsProvidingRequestedCapabilities = AttributeConfigurationSelector.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, (Collection<? extends ConfigurationMetadata>)consumableConfigurations, versionId.getGroup(), versionId.getName(), true, explanationBuilder);
            if (variantsProvidingRequestedCapabilities.isEmpty()) {
                throw new NoMatchingCapabilitiesException(targetComponent, explicitRequestedCapabilities, consumableConfigurations);
            }
            consumableConfigurations = variantsProvidingRequestedCapabilities;
        }
        if ((matches = attributeMatcher.matches(consumableConfigurations, consumerAttributes, fallbackConfiguration, explanationBuilder)).size() > 1) {
            List<ConfigurationMetadata> sameClassifier;
            String classifier;
            Object strictlyMatchingCapabilities = AttributeConfigurationSelector.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, matches, versionId.getGroup(), versionId.getName(), false, explanationBuilder);
            if (strictlyMatchingCapabilities.size() == 1) {
                return AttributeConfigurationSelector.singleVariant(variantsForGraphTraversal, strictlyMatchingCapabilities);
            }
            if (strictlyMatchingCapabilities.size() > 1 && (strictlyMatchingCapabilities = attributeMatcher.matches(strictlyMatchingCapabilities, consumerAttributes, fallbackConfiguration, explanationBuilder)).size() == 1) {
                return AttributeConfigurationSelector.singleVariant(variantsForGraphTraversal, (List<ConfigurationMetadata>)strictlyMatchingCapabilities);
            }
            if (requestedArtifacts.size() == 1 && (classifier = requestedArtifacts.get(0).getClassifier()) != null && (sameClassifier = AttributeConfigurationSelector.findVariantsProvidingExactlySameClassifier(matches, classifier)) != null && sameClassifier.size() == 1) {
                return AttributeConfigurationSelector.singleVariant(variantsForGraphTraversal, sameClassifier);
            }
        }
        if (matches.size() == 1) {
            return AttributeConfigurationSelector.singleVariant(variantsForGraphTraversal, matches);
        }
        if (!matches.isEmpty()) {
            describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
            if (explanationBuilder instanceof TraceDiscardedConfigurations) {
                Set discarded = (Set)Cast.uncheckedCast(((TraceDiscardedConfigurations)explanationBuilder).discarded);
                throw new AmbiguousConfigurationSelectionException(describer, consumerAttributes, attributeMatcher, matches, targetComponent, variantsForGraphTraversal.isPresent(), discarded);
            }
            return AttributeConfigurationSelector.selectConfigurationUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponent, consumerSchema, requestedArtifacts, new TraceDiscardedConfigurations());
        }
        describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
        throw new NoMatchingConfigurationSelectionException(describer, consumerAttributes, attributeMatcher, targetComponent, variantsForGraphTraversal.isPresent());
    }

    private static List<ConfigurationMetadata> findVariantsProvidingExactlySameClassifier(List<ConfigurationMetadata> matches, String classifier) {
        ArrayList sameClassifier = null;
        for (ConfigurationMetadata match : matches) {
            ArtifactIdentifier artifactIdentifier;
            ComponentArtifactMetadata componentArtifactMetadata;
            ImmutableList<? extends ComponentArtifactMetadata> artifacts = match.getArtifacts();
            if (artifacts.size() != 1 || !((componentArtifactMetadata = (ComponentArtifactMetadata)artifacts.get(0)) instanceof ModuleComponentArtifactMetadata) || !classifier.equals((artifactIdentifier = ((ModuleComponentArtifactMetadata)componentArtifactMetadata).toArtifactIdentifier()).getClassifier())) continue;
            if (sameClassifier == null) {
                sameClassifier = Collections.singletonList(match);
                continue;
            }
            sameClassifier = Lists.newArrayList(sameClassifier);
            sameClassifier.add(match);
        }
        return sameClassifier;
    }

    private static ConfigurationMetadata singleVariant(Optional<ImmutableList<? extends ConfigurationMetadata>> variantsForGraphTraversal, List<ConfigurationMetadata> matches) {
        ConfigurationMetadata match = matches.get(0);
        if (variantsForGraphTraversal.isPresent()) {
            return SelectedByVariantMatchingConfigurationMetadata.of(match);
        }
        return match;
    }

    private static ImmutableList<ConfigurationMetadata> filterVariantsByRequestedCapabilities(ComponentResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, Collection<? extends ConfigurationMetadata> consumableConfigurations, String group, String name, boolean lenient, AttributeMatchingExplanationBuilder explanationBuilder) {
        if (consumableConfigurations.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)consumableConfigurations.size());
        boolean explicitlyRequested = !explicitRequestedCapabilities.isEmpty();
        for (ConfigurationMetadata configurationMetadata : consumableConfigurations) {
            CapabilitiesMetadata capabilitiesMetadata = configurationMetadata.getCapabilities();
            List<? extends Capability> capabilities = capabilitiesMetadata.getCapabilities();
            MatchResult result = explicitlyRequested ? AttributeConfigurationSelector.providesAllCapabilities(targetComponent, explicitRequestedCapabilities, capabilities) : AttributeConfigurationSelector.containsImplicitCapability(capabilitiesMetadata, capabilities, group, name);
            if (!result.matches || !lenient && result != MatchResult.EXACT_MATCH) continue;
            builder.add((Object)configurationMetadata);
        }
        return builder.build();
    }

    private static boolean isShadowedCapabilityOnly(CapabilitiesMetadata capabilitiesMetadata) {
        return capabilitiesMetadata instanceof ShadowedCapabilityOnly;
    }

    private static MatchResult providesAllCapabilities(ComponentResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, List<? extends Capability> providerCapabilities) {
        if (providerCapabilities.isEmpty() && explicitRequestedCapabilities.size() == 1) {
            Capability requested = explicitRequestedCapabilities.iterator().next();
            ModuleVersionIdentifier moduleVersionIdentifier = targetComponent.getModuleVersionId();
            if (requested.getGroup().equals(moduleVersionIdentifier.getGroup()) && requested.getName().equals(moduleVersionIdentifier.getName())) {
                return MatchResult.EXACT_MATCH;
            }
        }
        for (Capability capability : explicitRequestedCapabilities) {
            String requestedGroup = capability.getGroup();
            String requestedName = capability.getName();
            boolean found = false;
            for (Capability capability2 : providerCapabilities) {
                if (!capability2.getGroup().equals(requestedGroup) || !capability2.getName().equals(requestedName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return MatchResult.NO_MATCH;
        }
        boolean exactMatch = explicitRequestedCapabilities.size() == providerCapabilities.size();
        return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
    }

    private static MatchResult containsImplicitCapability(CapabilitiesMetadata capabilitiesMetadata, Collection<? extends Capability> capabilities, String group, String name) {
        if (AttributeConfigurationSelector.fastContainsImplicitCapability(capabilitiesMetadata, capabilities)) {
            return MatchResult.EXACT_MATCH;
        }
        for (Capability capability : capabilities) {
            Capability capability2 = AttributeConfigurationSelector.unwrap(capability);
            if (!group.equals(capability2.getGroup()) || !name.equals(capability2.getName())) continue;
            boolean exactMatch = capabilities.size() == 1;
            return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
        }
        return MatchResult.NO_MATCH;
    }

    private static boolean fastContainsImplicitCapability(CapabilitiesMetadata capabilitiesMetadata, Collection<? extends Capability> capabilities) {
        return capabilities.isEmpty() || AttributeConfigurationSelector.isShadowedCapabilityOnly(capabilitiesMetadata);
    }

    private static Capability unwrap(Capability capability) {
        if (capability instanceof ShadowedCapability) {
            return ((ShadowedCapability)capability).getShadowedCapability();
        }
        return capability;
    }

    private static class TraceDiscardedConfigurations
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = Sets.newHashSet();

        private TraceDiscardedConfigurations() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }

    private static enum MatchResult {
        NO_MATCH(false),
        MATCHES_ALL(true),
        EXACT_MATCH(true);

        private final boolean matches;

        private MatchResult(boolean match) {
            this.matches = match;
        }
    }
}

