/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.List;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AbstractScriptTransformer;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;

public class ImperativeStatementDetectingTransformer
extends AbstractScriptTransformer {
    private boolean imperativeStatementDetected;

    @Override
    public void register(CompilationUnit compilationUnit) {
        super.register(compilationUnit);
    }

    @Override
    protected int getPhase() {
        return 5;
    }

    public boolean isImperativeStatementDetected() {
        return this.imperativeStatementDetected;
    }

    public void call(SourceUnit source) throws CompilationFailedException {
        BlockStatement statementBlock = source.getAST().getStatementBlock();
        List statements = statementBlock.getStatements();
        for (Statement statement : statements) {
            ScriptBlock scriptBlock;
            if (!AstUtils.mayHaveAnEffect(statement) || (scriptBlock = AstUtils.detectScriptBlock(statement)) != null && scriptBlock.getName().equals("model")) continue;
            this.imperativeStatementDetected = true;
            break;
        }
    }
}

