/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.util.Deque;
import java.util.LinkedList;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.impldep.com.google.common.base.CharMatcher;

public class RelativePathParser {
    private static final CharMatcher IS_SLASH = CharMatcher.is((char)'/');
    private String currentName;
    private int sizeOfCommonPrefix;
    private int rootLength;
    private Deque<String> directoryPaths = new LinkedList<String>();

    public String getRelativePath() {
        return this.currentName.substring(this.rootLength);
    }

    public String getName() {
        return this.currentName.substring(this.sizeOfCommonPrefix + 1);
    }

    public int nextPath(String nextPath, boolean directory) {
        this.currentName = directory ? nextPath.substring(0, nextPath.length() - 1) : nextPath;
        String lastDirPath = this.directoryPaths.peekLast();
        this.sizeOfCommonPrefix = FilePathUtil.sizeOfCommonPrefix(lastDirPath, this.currentName, 0, '/');
        int directoriesLeft = this.determineDirectoriesLeft(lastDirPath, this.sizeOfCommonPrefix);
        for (int i = 0; i < directoriesLeft; ++i) {
            this.directoryPaths.removeLast();
        }
        if (directory && this.getDepth() > 0) {
            this.directoryPaths.addLast(this.currentName);
        }
        return directoriesLeft;
    }

    private int determineDirectoriesLeft(String lastDirPath, int sizeOfCommonPrefix) {
        if (sizeOfCommonPrefix == lastDirPath.length()) {
            return 0;
        }
        int rootDirAdjustment = sizeOfCommonPrefix == 0 ? 1 : 0;
        return rootDirAdjustment + IS_SLASH.countIn((CharSequence)lastDirPath.substring(sizeOfCommonPrefix));
    }

    public void rootPath(String path) {
        this.directoryPaths.addLast(path.substring(0, path.length() - 1));
        this.rootLength = path.length();
    }

    public int getDepth() {
        return this.directoryPaths.size();
    }
}

