/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.authentication.Authentication;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.http.HttpBuildCache;
import org.gradle.caching.http.HttpBuildCacheCredentials;
import org.gradle.caching.http.internal.HttpBuildCacheRequestCustomizer;
import org.gradle.caching.http.internal.HttpBuildCacheService;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.verifier.HttpRedirectVerifier;
import org.gradle.internal.verifier.HttpRedirectVerifierFactory;

public class DefaultHttpBuildCacheServiceFactory
implements BuildCacheServiceFactory<HttpBuildCache> {
    private final SslContextFactory sslContextFactory;
    private final HttpBuildCacheRequestCustomizer requestCustomizer;

    @Inject
    public DefaultHttpBuildCacheServiceFactory(SslContextFactory sslContextFactory, HttpBuildCacheRequestCustomizer requestCustomizer) {
        this.sslContextFactory = sslContextFactory;
        this.requestCustomizer = requestCustomizer;
    }

    @Override
    public BuildCacheService createBuildCacheService(HttpBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        URI url = configuration.getUrl();
        if (url == null) {
            throw new IllegalStateException("HTTP build cache has no URL configured");
        }
        URI noUserInfoUrl = DefaultHttpBuildCacheServiceFactory.stripUserInfo(url);
        HttpBuildCacheCredentials credentials = configuration.getCredentials();
        if (!DefaultHttpBuildCacheServiceFactory.credentialsPresent(credentials) && url.getUserInfo() != null) {
            credentials = DefaultHttpBuildCacheServiceFactory.extractCredentialsFromUserInfo(url);
        }
        List<Authentication> authentications = Collections.emptyList();
        if (DefaultHttpBuildCacheServiceFactory.credentialsPresent(credentials)) {
            DefaultBasicAuthentication basicAuthentication = new DefaultBasicAuthentication("basic");
            basicAuthentication.setCredentials(credentials);
            basicAuthentication.addHost(url.getHost(), url.getPort());
            authentications = Collections.singleton(basicAuthentication);
        }
        boolean authenticated = !authentications.isEmpty();
        boolean allowUntrustedServer = configuration.isAllowUntrustedServer();
        boolean allowInsecureProtocol = configuration.isAllowInsecureProtocol();
        HttpRedirectVerifier redirectVerifier = this.createRedirectVerifier(noUserInfoUrl, allowInsecureProtocol);
        DefaultHttpSettings.Builder builder = DefaultHttpSettings.builder().withAuthenticationSettings(authentications).followRedirects(false).withRedirectVerifier(redirectVerifier);
        if (allowUntrustedServer) {
            builder.allowUntrustedConnections();
        } else {
            builder.withSslContextFactory(this.sslContextFactory);
        }
        HttpClientHelper httpClientHelper = new HttpClientHelper(builder.build());
        describer.type("HTTP").config("url", noUserInfoUrl.toASCIIString()).config("authenticated", Boolean.toString(authenticated)).config("allowUntrustedServer", Boolean.toString(allowUntrustedServer)).config("allowInsecureProtocol", Boolean.toString(allowInsecureProtocol));
        return new HttpBuildCacheService(httpClientHelper, noUserInfoUrl, this.requestCustomizer);
    }

    private HttpRedirectVerifier createRedirectVerifier(URI url, boolean allowInsecureProtocol) {
        return HttpRedirectVerifierFactory.create(url, allowInsecureProtocol, () -> ((DeprecationMessageBuilder)DeprecationLogger.deprecate("Using insecure protocols with remote build cache").withAdvice("Switch remote build cache to a secure protocol (like HTTPS) or allow insecure protocols.")).willBeRemovedInGradle7().withDslReference(HttpBuildCache.class, "allowInsecureProtocol").nagUser(), redirect -> {
            throw new IllegalStateException("Redirects are unsupported by the the build cache.");
        });
    }

    @VisibleForTesting
    static HttpBuildCacheCredentials extractCredentialsFromUserInfo(URI url) {
        HttpBuildCacheCredentials credentials = new HttpBuildCacheCredentials();
        String userInfo = url.getUserInfo();
        int indexOfSeparator = userInfo.indexOf(58);
        if (indexOfSeparator > -1) {
            String username = userInfo.substring(0, indexOfSeparator);
            String password = userInfo.substring(indexOfSeparator + 1);
            credentials.setUsername(username);
            credentials.setPassword(password);
        }
        return credentials;
    }

    private static URI stripUserInfo(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new GradleException("Error constructing URL for http build cache", e);
        }
    }

    private static boolean credentialsPresent(HttpBuildCacheCredentials credentials) {
        return credentials.getUsername() != null && credentials.getPassword() != null;
    }
}

