/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.maven;

import java.io.File;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.mvnsettings.MavenSettingsProvider;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.maven.Maven2Gradle;
import org.gradle.buildinit.plugins.internal.maven.MavenConversionException;
import org.gradle.buildinit.plugins.internal.maven.MavenProjectsCreator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;
import org.gradle.internal.impldep.org.apache.maven.settings.Settings;
import org.gradle.util.IncubationLogger;

public class PomProjectInitDescriptor
implements BuildConverter {
    private final MavenSettingsProvider settingsProvider;
    private final BuildScriptBuilderFactory scriptBuilderFactory;
    private final DocumentationRegistry documentationRegistry;
    private final PathToFileResolver fileResolver;

    public PomProjectInitDescriptor(PathToFileResolver fileResolver, MavenSettingsProvider mavenSettingsProvider, BuildScriptBuilderFactory scriptBuilderFactory, DocumentationRegistry documentationRegistry) {
        this.fileResolver = fileResolver;
        this.settingsProvider = mavenSettingsProvider;
        this.scriptBuilderFactory = scriptBuilderFactory;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public String getId() {
        return "pom";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.BASIC;
    }

    @Override
    public Language getLanguage() {
        return Language.NONE;
    }

    @Override
    public String getSourceBuildDescription() {
        return "Maven";
    }

    @Override
    public void generate(InitSettings initSettings) {
        IncubationLogger.incubatingFeatureUsed("Maven to Gradle conversion");
        File pom = this.fileResolver.resolve("pom.xml");
        try {
            Settings settings = this.settingsProvider.buildSettings();
            Set<MavenProject> mavenProjects = new MavenProjectsCreator().create(settings, pom);
            new Maven2Gradle(mavenProjects, this.fileResolver.resolve("."), this.scriptBuilderFactory).convert();
        }
        catch (Exception exception) {
            throw new MavenConversionException(String.format("Could not convert Maven POM %s to a Gradle build.", pom), exception);
        }
    }

    @Override
    public boolean supportsProjectName() {
        return false;
    }

    @Override
    public boolean canApplyToCurrentDirectory() {
        return this.fileResolver.resolve("pom.xml").isFile();
    }

    @Override
    public Set<BuildInitDsl> getDsls() {
        return Collections.singleton(BuildInitDsl.GROOVY);
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.GROOVY;
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.NONE;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.NONE);
    }

    @Override
    public Optional<String> getFurtherReading() {
        return Optional.of(this.documentationRegistry.getDocumentationFor("migrating_from_maven"));
    }
}

