/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public abstract class JavaProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private static final Description DESCRIPTION = new Description("Java", "Java Quickstart", "tutorial_java_projects", "java");
    private final TemplateLibraryVersionProvider libraryVersionProvider;
    private final DocumentationRegistry documentationRegistry;

    public JavaProjectInitDescriptor(TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        this.libraryVersionProvider = libraryVersionProvider;
        this.documentationRegistry = documentationRegistry;
    }

    @Override
    public Language getLanguage() {
        return Language.JAVA;
    }

    @Override
    public void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder, TemplateFactory templateFactory) {
        super.generate(settings, buildScriptBuilder, templateFactory);
        Description desc = this.getDescription();
        buildScriptBuilder.fileComment("This generated file contains a sample " + desc.projectType + " project to get you started.").fileComment("For more details take a look at the " + desc.chapterName + " chapter in the Gradle").fileComment("User Manual available at " + this.documentationRegistry.getDocumentationFor(desc.userguideId)).plugin("Apply the " + desc.pluginName + " plugin to add support for " + desc.projectType, desc.pluginName);
        this.configureBuildScript(settings, buildScriptBuilder);
        this.addTestFramework(settings.getTestFramework(), buildScriptBuilder);
        TemplateOperation sourceTemplate = this.sourceTemplateOperation(settings, templateFactory);
        TemplateOperation testSourceTemplate = this.testTemplateOperation(settings, templateFactory);
        templateFactory.whenNoSourcesAvailable(sourceTemplate, testSourceTemplate).generate();
    }

    protected Description getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Optional<String> getFurtherReading() {
        return Optional.of(this.documentationRegistry.getDocumentationFor(this.getDescription().userguideId));
    }

    private void addTestFramework(BuildInitTestFramework testFramework, BuildScriptBuilder buildScriptBuilder) {
        switch (testFramework) {
            case SPOCK: {
                buildScriptBuilder.plugin("Apply the groovy plugin to also add support for Groovy (needed for Spock)", "groovy").testImplementationDependency("Use the latest Groovy version for Spock testing", "org.codehaus.groovy:groovy-all:" + this.libraryVersionProvider.getVersion("groovy")).testImplementationDependency("Use the awesome Spock testing and specification framework even with Java", "org.spockframework:spock-core:" + this.libraryVersionProvider.getVersion("spock"), "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
                break;
            }
            case TESTNG: {
                buildScriptBuilder.testImplementationDependency("Use TestNG framework, also requires calling test.useTestNG() below", "org.gradle.internal.impldep.org.testng:testng:" + this.libraryVersionProvider.getVersion("testng")).taskMethodInvocation("Use TestNG for unit tests", "test", "Test", "useTestNG", new Object[0]);
                break;
            }
            case JUNIT_JUPITER: {
                buildScriptBuilder.testImplementationDependency("Use JUnit Jupiter API for testing.", "org.gradle.internal.impldep.org.junit.jupiter:junit-jupiter-api:" + this.libraryVersionProvider.getVersion("junit-jupiter")).testRuntimeOnlyDependency("Use JUnit Jupiter Engine for testing.", "org.gradle.internal.impldep.org.junit.jupiter:junit-jupiter-engine:" + this.libraryVersionProvider.getVersion("junit-jupiter")).taskMethodInvocation("Use junit platform for unit tests", "test", "Test", "useJUnitPlatform", new Object[0]);
                break;
            }
            default: {
                buildScriptBuilder.testImplementationDependency("Use JUnit test framework", "junit:junit:" + this.libraryVersionProvider.getVersion("junit"));
            }
        }
    }

    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
    }

    protected abstract TemplateOperation sourceTemplateOperation(InitSettings var1, TemplateFactory var2);

    protected abstract TemplateOperation testTemplateOperation(InitSettings var1, TemplateFactory var2);

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.JUNIT;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return new TreeSet<BuildInitTestFramework>(Arrays.asList(BuildInitTestFramework.JUNIT, BuildInitTestFramework.JUNIT_JUPITER, BuildInitTestFramework.TESTNG, BuildInitTestFramework.SPOCK));
    }

    protected static class Description {
        private final String projectType;
        private final String chapterName;
        private final String userguideId;
        private final String pluginName;

        public Description(String projectType, String chapterName, String userguideId, String pluginName) {
            this.projectType = projectType;
            this.chapterName = chapterName;
            this.userguideId = userguideId;
            this.pluginName = pluginName;
        }
    }
}

