/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JavaProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;

public class JavaApplicationProjectInitDescriptor
extends JavaProjectInitDescriptor {
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public JavaApplicationProjectInitDescriptor(TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(libraryVersionProvider, documentationRegistry);
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public String getId() {
        return "java-application";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.APPLICATION;
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.configureBuildScript(settings, buildScriptBuilder);
        buildScriptBuilder.plugin("Apply the application plugin to add support for building a CLI application.", "application").implementationDependency("This dependency is used by the application.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava")).block(null, "application", b -> b.propertyAssignment("Define the main class for the application.", "mainClassName", this.withPackage(settings, "App")));
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings, TemplateFactory templateFactory) {
        return templateFactory.fromSourceTemplate("javaapp/App.java.template", "main");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings, TemplateFactory templateFactory) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return templateFactory.fromSourceTemplate("groovyapp/AppTest.groovy.template", "test", Language.GROOVY);
            }
            case TESTNG: {
                return templateFactory.fromSourceTemplate("javaapp/testng/AppTest.java.template", "test");
            }
            case JUNIT: {
                return templateFactory.fromSourceTemplate("javaapp/AppTest.java.template", "test");
            }
            case JUNIT_JUPITER: {
                return templateFactory.fromSourceTemplate("javaapp/junitjupiter/AppTest.java.template", "test");
            }
        }
        throw new IllegalArgumentException();
    }
}

