/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public class JavaLibraryPlugin
implements Plugin<Project> {
    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        SourceSetContainer sourceSets = project.getExtensions().getByType(SourceSetContainer.class);
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSet sourceSet = (SourceSet)sourceSets.getByName("main");
        JvmPluginsHelper.addApiToSourceSet(sourceSet, configurations);
        JvmPluginsHelper.configureClassesDirectoryVariant(sourceSet, project, sourceSet.getApiElementsConfigurationName(), "java-api");
        this.deprecateConfigurationsForDeclaration(sourceSets, configurations);
    }

    private void deprecateConfigurationsForDeclaration(SourceSetContainer sourceSets, ConfigurationContainer configurations) {
        SourceSet sourceSet = (SourceSet)sourceSets.getByName("main");
        DeprecatableConfiguration compileConfiguration = (DeprecatableConfiguration)configurations.getByName(sourceSet.getCompileConfigurationName());
        DeprecatableConfiguration apiElementsConfiguration = (DeprecatableConfiguration)configurations.getByName(sourceSet.getApiElementsConfigurationName());
        DeprecatableConfiguration runtimeElementsConfiguration = (DeprecatableConfiguration)configurations.getByName(sourceSet.getRuntimeElementsConfigurationName());
        DeprecatableConfiguration compileClasspathConfiguration = (DeprecatableConfiguration)configurations.getByName(sourceSet.getCompileClasspathConfigurationName());
        DeprecatableConfiguration runtimeClasspathConfiguration = (DeprecatableConfiguration)configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName());
        String implementationConfigurationName = sourceSet.getImplementationConfigurationName();
        String compileOnlyConfigurationName = sourceSet.getCompileOnlyConfigurationName();
        String runtimeOnlyConfigurationName = sourceSet.getRuntimeOnlyConfigurationName();
        String apiConfigurationName = sourceSet.getApiConfigurationName();
        compileConfiguration.deprecateForDeclaration(implementationConfigurationName, apiConfigurationName);
        apiElementsConfiguration.deprecateForDeclaration(implementationConfigurationName, apiConfigurationName, compileOnlyConfigurationName);
        runtimeElementsConfiguration.deprecateForDeclaration(implementationConfigurationName, apiConfigurationName, compileOnlyConfigurationName, runtimeOnlyConfigurationName);
        compileClasspathConfiguration.deprecateForDeclaration(implementationConfigurationName, apiConfigurationName, compileOnlyConfigurationName);
        runtimeClasspathConfiguration.deprecateForDeclaration(implementationConfigurationName, apiConfigurationName, compileOnlyConfigurationName, runtimeOnlyConfigurationName);
    }
}

