/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.Comparator;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.ActionConfiguration;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.internal.ReusableAction;
import org.gradle.api.internal.artifacts.JavaEcosystemAttributesDescriber;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.DescribableAttributesSchema;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;

public abstract class JavaEcosystemSupport {
    private static final String DEPRECATED_JAVA_API_JARS = "java-api-jars";
    private static final String DEPRECATED_JAVA_RUNTIME_JARS = "java-runtime-jars";

    public static void configureSchema(AttributesSchema attributesSchema, ObjectFactory objectFactory) {
        JavaEcosystemSupport.configureUsage(attributesSchema, objectFactory);
        JavaEcosystemSupport.configureLibraryElements(attributesSchema, objectFactory);
        JavaEcosystemSupport.configureBundling(attributesSchema);
        JavaEcosystemSupport.configureTargetPlatform(attributesSchema);
        JavaEcosystemSupport.configureConsumerDescriptors((DescribableAttributesSchema)attributesSchema);
    }

    private static void configureConsumerDescriptors(DescribableAttributesSchema attributesSchema) {
        attributesSchema.addConsumerDescriber(new JavaEcosystemAttributesDescriber());
    }

    public static void configureDefaultTargetPlatform(HasAttributes configuration, int majorVersion) {
        AttributeContainerInternal attributes = (AttributeContainerInternal)configuration.getAttributes();
        if (!attributes.contains(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE)) {
            attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, majorVersion);
        }
    }

    private static void configureTargetPlatform(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy<Integer> targetPlatformSchema = attributesSchema.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE);
        targetPlatformSchema.getCompatibilityRules().ordered((Comparator<Integer>)Ordering.natural());
        targetPlatformSchema.getDisambiguationRules().pickLast((Comparator<Integer>)Ordering.natural());
    }

    private static void configureBundling(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy<Bundling> bundlingSchema = attributesSchema.attribute(Bundling.BUNDLING_ATTRIBUTE);
        bundlingSchema.getCompatibilityRules().add(BundlingCompatibilityRules.class);
        bundlingSchema.getDisambiguationRules().add(BundlingDisambiguationRules.class);
    }

    private static void configureUsage(AttributesSchema attributesSchema, final ObjectFactory objectFactory) {
        AttributeMatchingStrategy<Usage> usageSchema = attributesSchema.attribute(Usage.USAGE_ATTRIBUTE);
        usageSchema.getCompatibilityRules().add(UsageCompatibilityRules.class);
        usageSchema.getDisambiguationRules().add(UsageDisambiguationRules.class, new Action<ActionConfiguration>(){

            @Override
            public void execute(ActionConfiguration actionConfiguration) {
                actionConfiguration.params(objectFactory.named(Usage.class, "java-api"));
                actionConfiguration.params(objectFactory.named(Usage.class, JavaEcosystemSupport.DEPRECATED_JAVA_API_JARS));
                actionConfiguration.params(objectFactory.named(Usage.class, "java-runtime"));
                actionConfiguration.params(objectFactory.named(Usage.class, JavaEcosystemSupport.DEPRECATED_JAVA_RUNTIME_JARS));
            }
        });
    }

    private static void configureLibraryElements(AttributesSchema attributesSchema, ObjectFactory objectFactory) {
        AttributeMatchingStrategy<LibraryElements> libraryElementsSchema = attributesSchema.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE);
        libraryElementsSchema.getCompatibilityRules().add(LibraryElementsCompatibilityRules.class);
        libraryElementsSchema.getDisambiguationRules().add(LibraryElementsDisambiguationRules.class, actionConfiguration -> actionConfiguration.params(objectFactory.named(LibraryElements.class, "jar")));
    }

    @VisibleForTesting
    public static class BundlingDisambiguationRules
    implements AttributeDisambiguationRule<Bundling>,
    ReusableAction {
        @Override
        public void execute(MultipleCandidatesDetails<Bundling> details) {
            Bundling consumerValue = details.getConsumerValue();
            Set<Bundling> candidateValues = details.getCandidateValues();
            if (candidateValues.contains(consumerValue)) {
                details.closestMatch(consumerValue);
                return;
            }
            if (consumerValue == null) {
                Bundling embedded = null;
                for (Bundling candidateValue : candidateValues) {
                    if ("external".equals(candidateValue.getName())) {
                        details.closestMatch(candidateValue);
                        return;
                    }
                    if (!"embedded".equals(candidateValue.getName())) continue;
                    embedded = candidateValue;
                }
                if (embedded != null) {
                    details.closestMatch(embedded);
                }
            } else {
                String consumerValueName = consumerValue.getName();
                if ("external".equals(consumerValueName)) {
                    for (Bundling candidateValue : candidateValues) {
                        if (!"embedded".equals(candidateValue.getName())) continue;
                        details.closestMatch(candidateValue);
                        return;
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public static class BundlingCompatibilityRules
    implements AttributeCompatibilityRule<Bundling>,
    ReusableAction {
        private static final Set<String> COMPATIBLE_WITH_EXTERNAL = ImmutableSet.of((Object)"embedded", (Object)"shadowed");

        @Override
        public void execute(CompatibilityCheckDetails<Bundling> details) {
            Bundling consumerValue = details.getConsumerValue();
            Bundling producerValue = details.getProducerValue();
            if (consumerValue == null) {
                details.compatible();
                return;
            }
            String consumerValueName = consumerValue.getName();
            String producerValueName = producerValue.getName();
            if ("external".equals(consumerValueName)) {
                if (COMPATIBLE_WITH_EXTERNAL.contains(producerValueName)) {
                    details.compatible();
                }
            } else if ("embedded".equals(consumerValueName) && "shadowed".equals(producerValueName)) {
                details.compatible();
            }
        }
    }

    @VisibleForTesting
    public static class LibraryElementsCompatibilityRules
    implements AttributeCompatibilityRule<LibraryElements>,
    ReusableAction {
        @Override
        public void execute(CompatibilityCheckDetails<LibraryElements> details) {
            LibraryElements consumerValue = details.getConsumerValue();
            LibraryElements producerValue = details.getProducerValue();
            if (consumerValue == null) {
                details.compatible();
                return;
            }
            String consumerValueName = consumerValue.getName();
            String producerValueName = producerValue.getName();
            if (("classes".equals(consumerValueName) || "resources".equals(consumerValueName) || "classes+resources".equals(consumerValueName)) && "jar".equals(producerValueName)) {
                details.compatible();
                return;
            }
        }
    }

    @VisibleForTesting
    public static class LibraryElementsDisambiguationRules
    implements AttributeDisambiguationRule<LibraryElements>,
    ReusableAction {
        final LibraryElements jar;

        @Inject
        LibraryElementsDisambiguationRules(LibraryElements jar) {
            this.jar = jar;
        }

        @Override
        public void execute(MultipleCandidatesDetails<LibraryElements> details) {
            Set<LibraryElements> candidateValues = details.getCandidateValues();
            LibraryElements consumerValue = details.getConsumerValue();
            if (consumerValue == null) {
                if (candidateValues.contains(this.jar)) {
                    details.closestMatch(this.jar);
                }
            } else if (candidateValues.contains(consumerValue)) {
                details.closestMatch(consumerValue);
            }
        }
    }

    @VisibleForTesting
    public static class UsageCompatibilityRules
    implements AttributeCompatibilityRule<Usage>,
    ReusableAction {
        private static final Set<String> COMPATIBLE_WITH_JAVA_API = ImmutableSet.of((Object)"java-api-jars", (Object)"java-runtime-jars", (Object)"java-runtime");

        @Override
        public void execute(CompatibilityCheckDetails<Usage> details) {
            String consumerValue = details.getConsumerValue().getName();
            String producerValue = details.getProducerValue().getName();
            if (consumerValue.equals("java-api")) {
                if (COMPATIBLE_WITH_JAVA_API.contains(producerValue)) {
                    details.compatible();
                }
                return;
            }
            if (consumerValue.equals("java-runtime") && producerValue.equals(JavaEcosystemSupport.DEPRECATED_JAVA_RUNTIME_JARS)) {
                details.compatible();
                return;
            }
        }
    }

    @VisibleForTesting
    public static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage>,
    ReusableAction {
        final Usage javaApi;
        final Usage javaRuntime;
        final Usage javaApiJars;
        final Usage javaRuntimeJars;
        final ImmutableSet<Usage> apiVariants;
        final ImmutableSet<Usage> runtimeVariants;

        @Inject
        UsageDisambiguationRules(Usage javaApi, Usage javaApiJars, Usage javaRuntime, Usage javaRuntimeJars) {
            this.javaApi = javaApi;
            this.javaApiJars = javaApiJars;
            this.apiVariants = ImmutableSet.of((Object)javaApi, (Object)javaApiJars);
            this.javaRuntime = javaRuntime;
            this.javaRuntimeJars = javaRuntimeJars;
            this.runtimeVariants = ImmutableSet.of((Object)javaRuntime, (Object)javaRuntimeJars);
        }

        @Override
        public void execute(MultipleCandidatesDetails<Usage> details) {
            Set<Usage> candidateValues = details.getCandidateValues();
            Usage consumerValue = details.getConsumerValue();
            if (consumerValue == null) {
                if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch(this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch(this.javaRuntime);
                }
            } else if (this.javaRuntime.equals(consumerValue)) {
                if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch(this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch(this.javaRuntime);
                }
            } else if (candidateValues.contains(consumerValue)) {
                details.closestMatch(consumerValue);
            } else if (this.javaApi.equals(consumerValue)) {
                if (candidateValues.contains(this.javaApiJars)) {
                    details.closestMatch(this.javaApiJars);
                } else if (candidateValues.contains(this.javaRuntimeJars)) {
                    details.closestMatch(this.javaRuntimeJars);
                } else if (candidateValues.contains(this.javaRuntime)) {
                    details.closestMatch(this.javaRuntime);
                }
            }
        }
    }
}

