/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointFiltersPanel;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpoint;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointPropertiesPanel;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFieldBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinPropertyBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.breakpoints.dialog.AddFieldBreakpointDialog;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016J0\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u001b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0007\u0018\u00010\u001cH\u0016J\u001e\u0010\u001d\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0007\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020\u0012H\u0016J\u0018\u0010,\u001a\u0004\u0018\u00010\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\rH\u0016J\b\u0010.\u001a\u00020\rH\u0016J\u0018\u0010/\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\u0006\u00101\u001a\u00020\u0018H\u0002\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFieldBreakpointType;", "Lcom/intellij/debugger/ui/breakpoints/JavaBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinPropertyBreakpointProperties;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lorg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinBreakpointType;", "()V", "addBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljavax/swing/JComponent;", "canBeHitInOtherPlaces", "", "canPutAt", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "createBreakpointIfPropertyExists", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationContainer;", "Lorg/jetbrains/kotlin/psi/KtFile;", "className", "", "fieldName", "createBreakpointProperties", "createCustomPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "createCustomRightPropertiesPanel", "createJavaBreakpoint", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "createProperties", "getDisabledIcon", "Ljavax/swing/Icon;", "getDisplayText", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getEnabledIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getPriority", "getShortText", "isAddBreakpointButtonVisible", "isSuspendThreadSupported", "reportError", "", "message", "kotlin.jvm-debugger.core"})
public final class KotlinFieldBreakpointType
extends XLineBreakpointType<KotlinPropertyBreakpointProperties>
implements JavaBreakpointType<KotlinPropertyBreakpointProperties>,
KotlinBreakpointType {
    @NotNull
    public Breakpoint<KotlinPropertyBreakpointProperties> createJavaBreakpoint(@NotNull Project project, @NotNull XBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        return (Breakpoint)new KotlinFieldBreakpoint(project, breakpoint2);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)canPutAt.1.INSTANCE));
    }

    public int getPriority() {
        return 120;
    }

    @Nullable
    public KotlinPropertyBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public XLineBreakpoint<KotlinPropertyBreakpointProperties> addBreakpoint(@NotNull Project project, @Nullable JComponent parentComponent) {
        void result2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        AddFieldBreakpointDialog dialog2 = new AddFieldBreakpointDialog(this, project, (Ref.ObjectRef)result2, project){
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef $result;

            protected boolean validateData() {
                Object object;
                String fieldName;
                String className;
                String string = className = this.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
                CharSequence charSequence = string;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    String string2 = JavaDebuggerBundle.message((String)"error.field.breakpoint.class.name.not.specified", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JavaDebuggerBundle.messa\u2026lass.name.not.specified\")");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string2);
                    return false;
                }
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.$project).findClass(className, GlobalSearchScope.allScope((Project)this.$project));
                if (!(psiClass instanceof KtLightClass)) {
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, KotlinDebuggerCoreBundle.message("couldn.t.find.0.class", className));
                    return false;
                }
                String string3 = fieldName = this.getFieldName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fieldName");
                CharSequence charSequence2 = string3;
                boolean bl2 = false;
                if (charSequence2.length() == 0) {
                    String string4 = JavaDebuggerBundle.message((String)"error.field.breakpoint.field.name.not.specified", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"JavaDebuggerBundle.messa\u2026ield.name.not.specified\")");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string4);
                    return false;
                }
                charSequence2 = psiClass;
                if (charSequence2 instanceof KtLightClassForFacade) {
                    object = (XLineBreakpoint)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((KtLightClassForFacade)psiClass).getFiles()), (Function1)((Function1)new Function1<KtFile, XLineBreakpoint<KotlinPropertyBreakpointProperties>>(this, className, fieldName){
                        final /* synthetic */ addBreakpoint.dialog.1 this$0;
                        final /* synthetic */ String $className;
                        final /* synthetic */ String $fieldName;

                        @Nullable
                        public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke(@NotNull KtFile it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            KotlinFieldBreakpointType kotlinFieldBreakpointType = this.this$0.this$0;
                            KtDeclarationContainer ktDeclarationContainer = (KtDeclarationContainer)it;
                            String string = this.$className;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
                            String string2 = this.$fieldName;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fieldName");
                            return KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(kotlinFieldBreakpointType, ktDeclarationContainer, it, string, string2);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$className = string;
                            this.$fieldName = string2;
                            super(1);
                        }
                    })));
                } else if (charSequence2 instanceof KtLightClassForSourceDeclaration) {
                    KtClassOrObject jetClass = ((KtLightClassForSourceDeclaration)psiClass).getKotlinOrigin();
                    KtDeclarationContainer ktDeclarationContainer = (KtDeclarationContainer)jetClass;
                    KtFile ktFile = jetClass.getContainingKtFile();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"jetClass.containingKtFile");
                    object = KotlinFieldBreakpointType.access$createBreakpointIfPropertyExists(this.this$0, ktDeclarationContainer, ktFile, className, fieldName);
                } else {
                    object = this.$result.element = null;
                }
                if ((XLineBreakpoint)this.$result.element == null) {
                    String string5 = JavaDebuggerBundle.message((String)"error.field.breakpoint.field.not.found", (Object[])new Object[]{className, fieldName, fieldName});
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"JavaDebuggerBundle.messa\u2026me, fieldName, fieldName)");
                    KotlinFieldBreakpointType.access$reportError(this.this$0, this.$project, string5);
                }
                return (XLineBreakpoint)this.$result.element != null;
            }
            {
                this.this$0 = this$0;
                this.$project = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        dialog2.show();
        return (XLineBreakpoint)result2.element;
    }

    private final XLineBreakpoint<KotlinPropertyBreakpointProperties> createBreakpointIfPropertyExists(KtDeclarationContainer declaration2, KtFile file, String className, String fieldName) {
        Object v2;
        Project project;
        block3: {
            Project project2 = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            project = project2;
            List list = declaration2.getDeclarations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"declaration.declarations");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)fieldName))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtDeclaration ktDeclaration = v2;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration property = ktDeclaration;
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file);
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026ment(file) ?: return null");
        Document document2 = document;
        int line = document2.getLineNumber(property.getTextOffset());
        return (XLineBreakpoint)ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<XLineBreakpoint<KotlinPropertyBreakpointProperties>>(this, project, file, line, fieldName, className){
            final /* synthetic */ KotlinFieldBreakpointType this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ int $line;
            final /* synthetic */ String $fieldName;
            final /* synthetic */ String $className;

            @NotNull
            public final XLineBreakpoint<KotlinPropertyBreakpointProperties> invoke() {
                XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
                XBreakpointManager xBreakpointManager = xDebuggerManager.getBreakpointManager();
                XLineBreakpointType xLineBreakpointType = this.this$0;
                VirtualFile virtualFile2 = this.$file.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.virtualFile");
                return xBreakpointManager.addLineBreakpoint(xLineBreakpointType, virtualFile2.getUrl(), this.$line, (XBreakpointProperties)new KotlinPropertyBreakpointProperties(this.$fieldName, this.$className));
            }
            {
                this.this$0 = kotlinFieldBreakpointType;
                this.$project = project;
                this.$file = ktFile;
                this.$line = n;
                this.$fieldName = string;
                this.$className = string2;
                super(0);
            }
        }));
    }

    private final void reportError(Project project, String message) {
        Messages.showMessageDialog((Project)project, (String)message, (String)JavaDebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Debugger.Db_muted_field_breakpoint");
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Debugger.Db_disabled_field_breakpoint");
        return icon;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Debugger.Db_field_breakpoint");
        return icon;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_muted_disabled_field_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Debugger.Db_mut\u2026disabled_field_breakpoint");
        return icon;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    @Nullable
    public String getShortText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        KotlinPropertyBreakpointProperties properties = (KotlinPropertyBreakpointProperties)breakpoint2.getProperties();
        String className = properties.getMyClassName();
        CharSequence charSequence = className;
        boolean bl = false;
        return charSequence.length() > 0 ? className + "." + properties.getMyFieldName() : properties.getMyFieldName();
    }

    @Nullable
    public KotlinPropertyBreakpointProperties createProperties() {
        return new KotlinPropertyBreakpointProperties(null, null, 3, null);
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomPropertiesPanel() {
        return new KotlinFieldBreakpointPropertiesPanel();
    }

    @Nullable
    public String getDisplayText(@NotNull XLineBreakpoint<KotlinPropertyBreakpointProperties> breakpoint2) {
        BreakpointWithHighlighter kotlinBreakpoint;
        Object object;
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        Breakpoint breakpoint3 = BreakpointManager.getJavaBreakpoint((XBreakpoint)((XBreakpoint)breakpoint2));
        if (!(breakpoint3 instanceof BreakpointWithHighlighter)) {
            breakpoint3 = null;
        }
        if ((object = (kotlinBreakpoint = (BreakpointWithHighlighter)breakpoint3)) == null || (object = object.getDescription()) == null) {
            object = super.getDisplayText(breakpoint2);
        }
        return object;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<KotlinPropertyBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new KotlinBreakpointFiltersPanel(project);
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public KotlinFieldBreakpointType() {
        super("kotlin-field", KotlinDebuggerCoreBundle.message("field.watchpoint.tab.title", new Object[0]));
    }

    public static final /* synthetic */ void access$reportError(KotlinFieldBreakpointType $this, Project project, String message) {
        $this.reportError(project, message);
    }

    public static final /* synthetic */ XLineBreakpoint access$createBreakpointIfPropertyExists(KotlinFieldBreakpointType $this, KtDeclarationContainer declaration2, KtFile file, String className, String fieldName) {
        return $this.createBreakpointIfPropertyExists(declaration2, file, className, fieldName);
    }
}

