/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.LocalVariableDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.CodeFragmentContextUtilsKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinSourcePositionProvider;", "Lcom/intellij/debugger/engine/SourcePositionProvider;", "()V", "computeSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "descriptor", "Lcom/intellij/debugger/ui/tree/FieldDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "nearest", "", "Lcom/intellij/debugger/ui/tree/LocalVariableDescriptor;", "Lcom/intellij/debugger/ui/tree/NodeDescriptor;", "findClassByType", "Lcom/intellij/psi/PsiElement;", "type", "Lcom/sun/jdi/ReferenceType;", "getLastSourcePosition", "kotlin.jvm-debugger.core"})
public final class KotlinSourcePositionProvider
extends SourcePositionProvider {
    @Nullable
    protected SourcePosition computeSourcePosition(@NotNull NodeDescriptor descriptor, @NotNull Project project, @NotNull DebuggerContextImpl context, boolean nearest) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getFrameProxy() == null) {
            return null;
        }
        if (descriptor instanceof FieldDescriptor) {
            return this.computeSourcePosition((FieldDescriptor)descriptor, project, context, nearest);
        }
        if (descriptor instanceof LocalVariableDescriptor) {
            return this.computeSourcePosition((LocalVariableDescriptor)descriptor, project, context, nearest);
        }
        return null;
    }

    private final SourcePosition computeSourcePosition(LocalVariableDescriptor descriptor, Project project, DebuggerContextImpl context, boolean nearest) {
        PsiElement psiElement = PositionUtil.getContextElement((StackFrameContext)((StackFrameContext)context));
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PositionUtil.getContextE\u2026t(context) ?: return null");
        PsiElement place = psiElement;
        if (!(place.getContainingFile() instanceof KtFile)) {
            return null;
        }
        PsiElement psiElement2 = CodeFragmentContextUtilsKt.getContextElement((PsiElement)place);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement contextElement = psiElement2;
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string = descriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name");
        KtExpressionCodeFragment codeFragment = ktPsiFactory.createExpressionCodeFragment(string, contextElement);
        KtExpression expression = codeFragment.getContentElement();
        if (expression instanceof KtSimpleNameExpression) {
            SourceElement sourceElement;
            VariableDescriptor declarationDescriptor;
            BindingContext bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)expression), (BodyResolveMode)BodyResolveMode.PARTIAL);
            VariableDescriptor variableDescriptor = declarationDescriptor = BindingContextUtils.extractVariableDescriptorFromReference((BindingContext)bindingContext, (KtElement)((KtElement)expression));
            Object object = sourceElement = variableDescriptor != null ? variableDescriptor.getSource() : null;
            if (sourceElement instanceof KotlinSourceElement) {
                PsiElement psiElement3 = KotlinSourceElementKt.getPsi((SourceElement)sourceElement);
                if (psiElement3 == null) {
                    return null;
                }
                PsiElement element = psiElement3;
                if (nearest) {
                    return DebuggerContextUtil.findNearest((DebuggerContextImpl)context, (PsiElement)element, (PsiFile)element.getContainingFile());
                }
                return SourcePosition.createFromOffset((PsiFile)element.getContainingFile(), (int)element.getTextOffset());
            }
        }
        return null;
    }

    private final SourcePosition computeSourcePosition(FieldDescriptor descriptor, Project project, DebuggerContextImpl context, boolean nearest) {
        Object v5;
        KtClassOrObject myClass;
        block8: {
            ReferenceType type;
            String fieldName;
            block10: {
                block9: {
                    fieldName = descriptor.getField().name();
                    if (Intrinsics.areEqual((Object)fieldName, (Object)"this$0") || Intrinsics.areEqual((Object)fieldName, (Object)"receiver$0")) break block9;
                    String string = fieldName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fieldName");
                    if (!StringsKt.startsWith$default((String)string, (String)"this_", (boolean)false, (int)2, null)) break block10;
                }
                return null;
            }
            ReferenceType referenceType = type = descriptor.getField().declaringType();
            Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"type");
            PsiElement psiElement = this.findClassByType(project, referenceType, context);
            Object object = psiElement != null ? psiElement.getNavigationElement() : null;
            if (!(object instanceof KtClassOrObject)) {
                object = null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)object;
            if (ktClassOrObject == null) {
                return null;
            }
            myClass = ktClassOrObject;
            Iterable $this$firstOrNull$iv = myClass.getDeclarations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)fieldName, (Object)it.getName())) continue;
                v5 = element$iv;
                break block8;
            }
            v5 = null;
        }
        KtDeclaration ktDeclaration = v5;
        if (ktDeclaration == null) {
            return null;
        }
        KtDeclaration field = ktDeclaration;
        if (nearest) {
            return DebuggerContextUtil.findNearest((DebuggerContextImpl)context, (PsiElement)((PsiElement)field), (PsiFile)myClass.getContainingFile());
        }
        return SourcePosition.createFromOffset((PsiFile)field.getContainingFile(), (int)field.getTextOffset());
    }

    private final PsiElement findClassByType(Project project, ReferenceType type, DebuggerContextImpl context) {
        PsiElement element;
        DebuggerSession session = context.getDebuggerSession();
        DebuggerSession debuggerSession = session;
        if (debuggerSession == null || (debuggerSession = debuggerSession.getSearchScope()) == null) {
            debuggerSession = GlobalSearchScope.allScope((Project)project);
        }
        Intrinsics.checkNotNullExpressionValue((Object)debuggerSession, (String)"session?.searchScope ?: \u2026chScope.allScope(project)");
        DebuggerSession scope = debuggerSession;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)type.name());
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"JvmClassName.byInternalName(type.name())");
        String string = jvmClassName.getFqNameForClassNameWithoutDollars().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JvmClassName.byInternalN\u2026WithoutDollars.asString()");
        String className = string;
        PsiClass myClass = JavaPsiFacade.getInstance((Project)project).findClass(className, (GlobalSearchScope)scope);
        if (myClass != null) {
            return (PsiElement)myClass;
        }
        SourcePosition position = this.getLastSourcePosition(type, context);
        if (position != null && (element = position.getElementAt()) != null) {
            PsiElement $this$getStrictParentOfType$iv = element;
            boolean $i$f$getStrictParentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
        }
        return null;
    }

    private final SourcePosition getLastSourcePosition(ReferenceType type, DebuggerContextImpl context) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        if (debugProcess != null) {
            try {
                List locations = SafeUtilKt.safeAllLineLocations((ReferenceType)type);
                Collection collection = locations;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    Location lastLocation = (Location)locations.get(locations.size() - 1);
                    return debugProcess.getPositionManager().getSourcePosition(lastLocation);
                }
            }
            catch (AbsentInformationException absentInformationException) {
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                // empty catch block
            }
        }
        return null;
    }
}

