/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a7\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\b*\u0002H\t2\u0014\b\u0004\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\b0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"findTargetClasses", "", "Lcom/sun/jdi/ReferenceType;", "Lcom/intellij/debugger/engine/DebugProcess;", "outerClass", "lineAt", "", "readAction", "V", "U", "f", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin.jvm-debugger.core"})
public final class KotlinPositionManagerKt {
    public static final <U, V> V readAction(U $this$readAction, @NotNull Function1<? super U, ? extends V> f) {
        int $i$f$readAction = 0;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return (V)ApplicationUtilsKt.runReadAction((Function0)new Function0<V>($this$readAction, f){
            final /* synthetic */ Object $this_readAction;
            final /* synthetic */ Function1 $f;

            public final V invoke() {
                return (V)this.$f.invoke(this.$this_readAction);
            }
            {
                this.$this_readAction = object;
                this.$f = function1;
                super(0);
            }
        });
    }

    private static final List<ReferenceType> findTargetClasses(DebugProcess $this$findTargetClasses, ReferenceType outerClass, int lineAt) {
        VirtualMachineProxy vmProxy = $this$findTargetClasses.getVirtualMachineProxy();
        try {
            if (!outerClass.isPrepared()) {
                return CollectionsKt.emptyList();
            }
        }
        catch (ObjectCollectedException e) {
            return CollectionsKt.emptyList();
        }
        ArrayList targetClasses = new ArrayList(1);
        try {
            boolean bl;
            Iterable iterable;
            for (Location location : SafeUtilKt.safeAllLineLocations((ReferenceType)outerClass)) {
                Method method;
                int locationLine = location.lineNumber() - 1;
                if (locationLine < 0 || lineAt != locationLine || (method = location.method()) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                iterable = targetClasses;
                bl = false;
                iterable.add(outerClass);
                break;
            }
            List nestedTypes = vmProxy.nestedTypes(outerClass);
            for (ReferenceType nested : nestedTypes) {
                Collection collection = targetClasses;
                ReferenceType referenceType = nested;
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"nested");
                iterable = KotlinPositionManagerKt.findTargetClasses($this$findTargetClasses, referenceType, lineAt);
                bl = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return targetClasses;
    }

    public static final /* synthetic */ List access$findTargetClasses(DebugProcess $this$access_u24findTargetClasses, ReferenceType outerClass, int lineAt) {
        return KotlinPositionManagerKt.findTargetClasses($this$access_u24findTargetClasses, outerClass, lineAt);
    }
}

