/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import git4idea.config.GitExecutable;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class GitXmlRpcHandlerService<T>
implements Disposable {
    private static final Logger LOG = Logger.getInstance(GitXmlRpcHandlerService.class);
    @NotNull
    private final String myScriptTempFilePrefix;
    @NotNull
    private final String myHandlerName;
    @NotNull
    private final Class<? extends GitExternalApp> myScriptMainClass;
    @NotNull
    private final Map<String, File> myScriptPaths = new HashMap<String, File>();
    @NotNull
    private final Object SCRIPT_FILE_LOCK = new Object();
    @NotNull
    private final THashMap<UUID, T> handlers = new THashMap();
    @NotNull
    private final Object HANDLERS_LOCK = new Object();

    protected GitXmlRpcHandlerService(@NotNull String prefix, @NotNull String handlerName, @NotNull Class<? extends GitExternalApp> aClass) {
        this.myScriptTempFilePrefix = prefix;
        this.myHandlerName = handlerName;
        this.myScriptMainClass = aClass;
    }

    public int getXmlRcpPort() {
        return BuiltInServerManager.getInstance().waitForStart().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public File getScriptPath(@NotNull GitExecutable executable, boolean useBatchFile) throws IOException {
        Object object = this.SCRIPT_FILE_LOCK;
        synchronized (object) {
            String id = executable.getId() + (useBatchFile ? "-bat" : "");
            File scriptPath = this.myScriptPaths.get(id);
            if (scriptPath == null || !scriptPath.exists()) {
                ScriptGenerator generator = new ScriptGenerator(this.myScriptTempFilePrefix + "-" + executable.getId(), this.myScriptMainClass);
                scriptPath = generator.generate(executable, useBatchFile);
                this.myScriptPaths.put(id, scriptPath);
            }
            return scriptPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public UUID registerHandler(@NotNull T handler) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
            if (!xmlRpcServer.hasHandler(this.myHandlerName)) {
                xmlRpcServer.addHandler(this.myHandlerName, this.createRpcRequestHandlerDelegate());
            }
            UUID key = UUID.randomUUID();
            this.handlers.put((Object)key, handler);
            return key;
        }
    }

    public void dispose() {
        XmlRpcServer xmlRpcServer = (XmlRpcServer)ApplicationManager.getApplication().getServiceIfCreated(XmlRpcServer.class);
        if (xmlRpcServer != null) {
            xmlRpcServer.removeHandler(this.myHandlerName);
        }
    }

    @NotNull
    protected abstract Object createRpcRequestHandlerDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected T getHandler(UUID key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            Object rc = this.handlers.get((Object)key);
            if (rc == null) {
                throw new IllegalStateException("No handler for the key " + key);
            }
            return (T)rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(UUID key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            if (this.handlers.remove((Object)key) == null) {
                LOG.error("The handler " + key + " is not registered");
            }
        }
    }
}

