/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

@Deprecated
public final class GitFetchResult {
    private final Type myType;
    private Collection<Exception> myErrors = new ArrayList<Exception>();
    private final Collection<String> myPrunedRefs = new ArrayList<String>();

    public GitFetchResult(@NotNull Type type) {
        this.myType = type;
    }

    @NotNull
    public static GitFetchResult success() {
        return new GitFetchResult(Type.SUCCESS);
    }

    @NotNull
    public static GitFetchResult cancel() {
        return new GitFetchResult(Type.CANCELLED);
    }

    @NotNull
    public static GitFetchResult error(Collection<Exception> errors) {
        GitFetchResult result2 = new GitFetchResult(Type.ERROR);
        result2.myErrors = errors;
        return result2;
    }

    @NotNull
    public static GitFetchResult error(Exception error) {
        return GitFetchResult.error(Collections.singletonList(error));
    }

    @NotNull
    public static GitFetchResult error(@NotNull String errorMessage) {
        return GitFetchResult.error(new Exception(errorMessage));
    }

    public boolean isSuccess() {
        return this.myType == Type.SUCCESS;
    }

    public boolean isCancelled() {
        return this.myType == Type.CANCELLED;
    }

    public boolean isNotAuthorized() {
        return this.myType == Type.NOT_AUTHORIZED;
    }

    public boolean isError() {
        return this.myType == Type.ERROR;
    }

    @NotNull
    public Collection<? extends Exception> getErrors() {
        return this.myErrors;
    }

    public void addPruneInfo(@NotNull Collection<String> prunedRefs) {
        this.myPrunedRefs.addAll(prunedRefs);
    }

    @NotNull
    public Collection<String> getPrunedRefs() {
        return this.myPrunedRefs;
    }

    @NotNull
    public String getAdditionalInfo() {
        if (!this.myPrunedRefs.isEmpty()) {
            return "Pruned obsolete remote " + StringUtil.pluralize((String)"reference", (int)this.myPrunedRefs.size()) + ": " + StringUtil.join(this.myPrunedRefs, (String)", ");
        }
        return "";
    }

    public static enum Type {
        SUCCESS,
        CANCELLED,
        NOT_AUTHORIZED,
        ERROR;

    }
}

