/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringTree<T extends DefaultMutableTreeNode, U> {
    public static final SpeedSearchSupply DUMMY_SEARCH = new SpeedSearchSupply(){

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String text) {
            return null;
        }

        public void refreshSelection() {
        }

        public boolean isPopupActive() {
            return false;
        }

        public void addChangeListener(@NotNull PropertyChangeListener listener) {
        }

        public void removeChangeListener(@NotNull PropertyChangeListener listener) {
        }

        public void findAndSelectElement(@NotNull String searchQuery) {
        }
    };
    private final Project myProject;
    private final T myRoot;
    private final Tree myTree;

    public FilteringTree(@NotNull Project project, @NotNull Tree tree, @NotNull T root) {
        this.myProject = project;
        this.myRoot = root;
        this.myTree = tree;
        this.myTree.setModel(new SearchTreeModel(this.myRoot, DUMMY_SEARCH, o -> this.getText(o), this::createNode, this::getChildren));
    }

    @NotNull
    public SearchTextField installSearchField(final @Nullable Border textFieldBorder) {
        SearchTextField field = new SearchTextField(false){

            protected boolean preprocessEventForTextField(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    FilteringTree.this.myTree.dispatchEvent((AWTEvent)e);
                    return true;
                }
                if (e.getKeyCode() == 27 && this.getText().isEmpty()) {
                    UIUtil.requestFocus((JComponent)FilteringTree.this.myTree);
                    return true;
                }
                return false;
            }

            public void updateUI() {
                super.updateUI();
                UIUtil.setNotOpaqueRecursively((Component)((Object)this));
                JBTextField editor = this.getTextEditor();
                if (textFieldBorder != null && editor != null) {
                    editor.setBorder(textFieldBorder);
                }
            }
        };
        JBTextField fieldTextEditor = field.getTextEditor();
        if (textFieldBorder != null) {
            fieldTextEditor.setBorder(textFieldBorder);
        }
        MySpeedSearch speedSearch = new MySpeedSearch<T>((JComponent)this.myTree, (JTextComponent)fieldTextEditor){

            @Override
            protected void onSearchFieldUpdated(String pattern) {
                TreePath[] paths = FilteringTree.this.myTree.getSelectionModel().getSelectionPaths();
                FilteringTree.this.getSearchModel().refilter();
                FilteringTree.this.onSpeedSearchUpdateComplete();
                FilteringTree.this.myTree.getSelectionModel().setSelectionPaths(paths);
            }

            @Override
            public void select(@NotNull T node) {
                TreeUtil.selectInTree(node, (boolean)false, (JTree)FilteringTree.this.myTree);
            }

            @Override
            public boolean isMatching(@NotNull T node) {
                String text = FilteringTree.this.getText(FilteringTree.this.getUserObject((TreeNode)node));
                return text != null && this.matchingFragments(text) != null;
            }

            @Override
            @Nullable
            public T getSelection() {
                return (DefaultMutableTreeNode)ArrayUtil.getFirstElement((Object[])FilteringTree.this.myTree.getSelectedNodes(FilteringTree.this.getNodeClass(), null));
            }

            @Override
            @NotNull
            public Iterator<T> iterate(@Nullable T start, boolean fwd) {
                JBTreeTraverser traverser = (JBTreeTraverser)JBTreeTraverser.from(n -> {
                    int count = n.getChildCount();
                    ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>(count);
                    for (int i2 = 0; i2 < count; ++i2) {
                        DefaultMutableTreeNode c = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)n.getChildAt(fwd ? i2 : count - i2 - 1), FilteringTree.this.getNodeClass());
                        if (c == null) continue;
                        children.add(c);
                    }
                    return children;
                }).expand(Conditions.alwaysTrue());
                if (start == null) {
                    traverser = (JBTreeTraverser)traverser.withRoot(FilteringTree.this.getRoot());
                } else {
                    ArrayList<DefaultMutableTreeNode> roots = new ArrayList<DefaultMutableTreeNode>();
                    TreeNode node = null;
                    Object parent = start;
                    while (parent != null) {
                        int c;
                        int idx = node == null ? -1 : parent.getIndex(node);
                        int n2 = c = fwd ? parent.getChildCount() : idx;
                        for (int i2 = fwd ? idx + 1 : 0; i2 < c; ++i2) {
                            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(fwd ? i2 : idx - i2 - 1), FilteringTree.this.getNodeClass());
                            if (child == null) continue;
                            roots.add(child);
                        }
                        node = (TreeNode)parent;
                        parent = node.getParent();
                    }
                    traverser = (JBTreeTraverser)traverser.withRoots(roots);
                }
                return traverser.preOrderDfsTraversal().iterator();
            }
        };
        this.getSearchModel().setSpeedSearch((SpeedSearchSupply)speedSearch);
        return field;
    }

    public void installSimple() {
        TreeSpeedSearch supply = new TreeSpeedSearch(this.myTree, p -> StringUtil.notNullize((String)this.getText(p == null ? null : (U)this.getUserObject((TreeNode)p.getLastPathComponent()))), true){

            protected void onSearchFieldUpdated(String pattern) {
                if (StringUtil.isEmpty((String)pattern)) {
                    this.hidePopup();
                }
                if (StringUtil.isNotEmpty((String)pattern) && !this.isPopupActive()) {
                    GuiUtils.invokeLaterIfNeeded(FilteringTree.this.getSearchModel()::refilter, (ModalityState)ModalityState.defaultModalityState());
                } else {
                    FilteringTree.this.getSearchModel().refilter();
                }
            }
        };
        this.getSearchModel().setSpeedSearch((SpeedSearchSupply)supply);
    }

    protected abstract Class<? extends T> getNodeClass();

    @NotNull
    protected abstract T createNode(@NotNull U var1);

    @NotNull
    protected abstract Iterable<U> getChildren(@NotNull U var1);

    @NotNull
    public Tree getTree() {
        return this.myTree;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myTree;
    }

    protected boolean rebuildTree(boolean initial) {
        return false;
    }

    protected void onSpeedSearchUpdateComplete() {
    }

    @Nullable
    protected abstract String getText(@Nullable U var1);

    @NotNull
    public SearchTreeModel<T, U> getSearchModel() {
        return (SearchTreeModel)this.myTree.getModel();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public T getRoot() {
        return this.myRoot;
    }

    public void update(boolean initial) {
        if (this.rebuildTree(initial)) {
            this.myTree.revalidate();
            this.myTree.repaint();
        }
    }

    @Nullable
    public final U getUserObject(@Nullable TreeNode node) {
        return (U)(node == null || !this.getNodeClass().isAssignableFrom(node.getClass()) ? null : ((DefaultMutableTreeNode)node).getUserObject());
    }

    private static class MySpeedSearch<Item>
    extends SpeedSearch {
        private boolean myUpdating = false;
        private final JTextComponent myField;
        private final Set<MinusculeMatcher> wordMatchers = new HashSet<MinusculeMatcher>();

        MySpeedSearch(@NotNull JComponent comp, @NotNull JTextComponent field) {
            this.myField = field;
            this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (!myUpdating) {
                        myUpdating = true;
                        try {
                            String text = myField.getText();
                            this.updatePattern(text);
                            this.buildWordMatchers(text);
                            this.update();
                        }
                        finally {
                            myUpdating = false;
                        }
                    }
                }
            });
            this.setEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (this.selectTargetElement(e.getKeyCode())) {
                        e.consume();
                    }
                }
            });
            comp.addKeyListener((KeyListener)((Object)this));
            this.installSupplyTo(comp);
        }

        private void buildWordMatchers(@Nullable String text) {
            this.wordMatchers.clear();
            if (text == null) {
                return;
            }
            for (String word : StringUtil.split((String)text, (String)" ")) {
                this.wordMatchers.add((MinusculeMatcher)new FixingLayoutMatcher("*" + word, NameUtil.MatchingCaseSensitivity.NONE, ""));
            }
        }

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String text) {
            Iterable allTextRanges = super.matchingFragments(text);
            ArrayList<TextRange> wordRanges = new ArrayList<TextRange>();
            for (MinusculeMatcher wordMatcher : this.wordMatchers) {
                FList fragments = wordMatcher.matchingFragments(text);
                if (fragments == null) continue;
                wordRanges.addAll((Collection<TextRange>)fragments);
            }
            return allTextRanges != null ? ContainerUtil.concat((Iterable)allTextRanges, wordRanges) : (!wordRanges.isEmpty() ? wordRanges : null);
        }

        public void update() {
            String filter = this.getFilter();
            if (!this.myUpdating) {
                this.myUpdating = true;
                try {
                    this.myField.setText(filter);
                }
                finally {
                    this.myUpdating = false;
                }
            }
            this.onSearchFieldUpdated(filter);
            this.updateSelection();
        }

        public void noHits() {
            this.myField.setBackground(LightColors.RED);
        }

        public void updateSelection() {
            Item selection = this.getSelection();
            if (selection != null && this.isMatching(selection)) {
                return;
            }
            JBIterator it = JBIterator.from(this.iterate(selection, true, true)).filter(item -> item != selection && this.isMatching(item));
            if (!it.advance()) {
                return;
            }
            this.select(it.current());
        }

        protected void onSearchFieldUpdated(String pattern) {
        }

        public void select(@NotNull Item item) {
        }

        @Nullable
        public Item getSelection() {
            return null;
        }

        public boolean isMatching(@NotNull Item item) {
            return false;
        }

        @NotNull
        public Iterator<Item> iterate(@Nullable Item start, boolean fwd) {
            return new JBIterator<Item>(){

                protected Item nextImpl() {
                    return this.stop();
                }
            };
        }

        @NotNull
        public Iterator<Item> iterate(final @Nullable Item start, final boolean fwd, boolean wrap2) {
            if (!wrap2 || start == null) {
                return this.iterate(start, fwd);
            }
            return new JBIterator<Item>(){
                boolean wrapped = false;
                Iterator<Item> it = this.iterate(start, fwd);

                protected Item nextImpl() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    if (this.wrapped) {
                        return this.stop();
                    }
                    this.wrapped = true;
                    this.it = JBIterator.from(this.iterate(null, fwd)).takeWhile(item -> item != start);
                    return this.it.hasNext() ? this.it.next() : this.stop();
                }
            };
        }

        private boolean selectTargetElement(int keyCode) {
            JBIterator it;
            if (!this.isPopupActive()) {
                return false;
            }
            if (keyCode == 38) {
                it = this.iterate(this.getSelection(), false, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 40) {
                it = this.iterate(this.getSelection(), true, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 36) {
                it = this.iterate(null, true);
            } else if (keyCode == 35) {
                it = this.iterate(null, false);
            } else {
                return false;
            }
            it = JBIterator.from(it).filter(item -> this.isMatching(item));
            if (it.hasNext()) {
                this.select(it.next());
            }
            return true;
        }
    }

    public static class SearchTreeModel<N extends DefaultMutableTreeNode, U>
    extends DefaultTreeModel {
        private final Function<U, String> myNamer;
        private final Function<U, N> myFactory;
        private final U myRootObject;
        private final Function<U, Iterable<U>> myStructure;
        private SpeedSearchSupply mySpeedSearch;
        private Map<U, N> myNodeCache = new IdentityHashMap<U, N>();
        private final EventDispatcher<Listener> myNodeChanged = EventDispatcher.create(Listener.class);

        public SearchTreeModel(@NotNull N root, @NotNull SpeedSearchSupply speedSearch, @NotNull Function<U, String> namer, @NotNull Function<U, N> nodeFactory, @NotNull Function<U, Iterable<U>> structure) {
            super((TreeNode)root);
            this.myRootObject = Objects.requireNonNull(this.getUserObject(root));
            this.mySpeedSearch = speedSearch;
            this.myNamer = namer;
            this.myFactory = nodeFactory;
            this.myStructure = structure;
            this.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    Object object = this.getUserObject((DefaultMutableTreeNode)e.getTreePath().getLastPathComponent());
                    if (object != null) {
                        ((Listener)myNodeChanged.getMulticaster()).nodeChanged(object);
                    }
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }

        public void modifyNode(@NotNull U object, @NotNull Runnable r) {
            ((Listener)this.myNodeChanged.getMulticaster()).beforeNodeChanged(object);
            try {
                r.run();
            }
            finally {
                ((Listener)this.myNodeChanged.getMulticaster()).nodeChanged(object);
            }
        }

        public void setSpeedSearch(@NotNull SpeedSearchSupply supply) {
            this.mySpeedSearch = supply;
            this.updateStructure();
        }

        protected SpeedSearchSupply getSpeedSearchSupply() {
            return this.mySpeedSearch;
        }

        public void addNodeListener(@NotNull Listener<U> listener) {
            this.myNodeChanged.addListener(listener);
        }

        public void updateStructure() {
            IdentityHashMap<U, N> newNodes = new IdentityHashMap<U, N>();
            Iterator iterator = ((JBTreeTraverser)JBTreeTraverser.from(this.myStructure).withRoot(this.getRootObject())).iterator();
            while (iterator.hasNext()) {
                Object node;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myNodeCache.get(node = iterator.next());
                newNodes.put(node, treeNode == null ? this.createNode(node) : treeNode);
            }
            ArrayList<N> oldNodes = new ArrayList<N>();
            for (Map.Entry<U, N> entry : this.myNodeCache.entrySet()) {
                if (newNodes.containsKey(entry.getKey())) continue;
                oldNodes.add(entry.getValue());
            }
            this.myNodeCache = newNodes;
            for (DefaultMutableTreeNode node : oldNodes) {
                if (!this.myNodeCache.containsKey(node.getUserObject())) continue;
                List children = ContainerUtil.toList(node.children());
                node.removeAllChildren();
                for (DefaultMutableTreeNode child : children) {
                    if (!this.myNodeCache.containsKey(child.getUserObject())) continue;
                    node.add(child);
                }
            }
            this.refilter();
        }

        public N getRoot() {
            return (N)((DefaultMutableTreeNode)this.root);
        }

        @NotNull
        public U getRootObject() {
            return this.myRootObject;
        }

        @NotNull
        public N getNode(@NotNull U object) {
            N node = this.getCachedNode(object);
            if (node == null) {
                node = this.createNode(object);
                this.myNodeCache.put(object, node);
            }
            return node;
        }

        @Nullable
        public N getCachedNode(@Nullable U object) {
            if (object == null) {
                return null;
            }
            if (object == this.myRootObject) {
                return (N)this.getRoot();
            }
            return (N)((DefaultMutableTreeNode)this.myNodeCache.get(object));
        }

        @NotNull
        protected N createNode(@NotNull U object) {
            assert (!(object instanceof DefaultMutableTreeNode));
            return (N)((DefaultMutableTreeNode)this.myFactory.fun(object));
        }

        public void refilter() {
            if (this.mySpeedSearch.isPopupActive()) {
                THashSet acceptCache = ContainerUtil.newIdentityTroveSet();
                this.computeAcceptCache(this.myRootObject, (Set<U>)acceptCache);
                this.filterChildren(this.myRootObject, arg_0 -> SearchTreeModel.lambda$refilter$0((Set)acceptCache, arg_0));
            } else {
                this.filterChildren(this.myRootObject, x -> true);
            }
        }

        private boolean computeAcceptCache(@NotNull U object, @NotNull Set<U> cache2) {
            boolean isAccepted = false;
            Iterable<U> children = this.getChildren(object);
            for (U child : children) {
                isAccepted |= this.computeAcceptCache(child, cache2);
            }
            String name = (String)this.myNamer.fun(object);
            if (isAccepted |= object == this.myRootObject || name != null && this.accept(name)) {
                for (U child : children) {
                    if (this.myNamer.fun(child) != null) continue;
                    cache2.add(child);
                }
                cache2.add(object);
            }
            return isAccepted;
        }

        @NotNull
        public Iterable<U> getChildren(@Nullable U object) {
            return object == null ? JBIterable.empty() : (Iterable)this.myStructure.fun(object);
        }

        @NotNull
        public Function<U, Iterable<U>> getStructure() {
            return this.myStructure;
        }

        @Nullable
        public static <N extends DefaultMutableTreeNode> N getChildSafe(@NotNull N node, int i2) {
            return node.getChildCount() <= i2 ? null : (N)SearchTreeModel.getChild(node, i2);
        }

        public static <N extends DefaultMutableTreeNode> N getChild(@NotNull N node, int i2) {
            return (N)((DefaultMutableTreeNode)node.getChildAt(i2));
        }

        private void filterChildren(@Nullable U object, @NotNull Condition<U> filter) {
            if (object == null) {
                return;
            }
            N node = this.getNode(object);
            this.filterDirectChildren(node, filter);
            int c = ((DefaultMutableTreeNode)node).getChildCount();
            for (int i2 = 0; i2 < c; ++i2) {
                this.filterChildren(this.getUserObject(SearchTreeModel.getChild(node, i2)), filter);
            }
        }

        private void filterDirectChildren(@NotNull N node, @NotNull Condition<U> filter) {
            LinkedHashSet<U> accepted = new LinkedHashSet<U>();
            for (U child : this.getChildren(this.getUserObject(node))) {
                if (!filter.value(child)) continue;
                accepted.add(child);
            }
            this.removeNotAccepted(node, accepted);
            this.mergeAcceptedNodes(node, accepted);
        }

        private void mergeAcceptedNodes(@NotNull N node, Set<U> accepted) {
            int k = 0;
            N cur = SearchTreeModel.getChildSafe(node, 0);
            TIntArrayList newIds = new TIntArrayList();
            for (U child : accepted) {
                boolean isCur;
                boolean bl = isCur = cur != null && this.getUserObject(cur) == child;
                if (isCur) {
                    cur = SearchTreeModel.getChildSafe(node, k + 1);
                } else {
                    newIds.add(k);
                    ((DefaultMutableTreeNode)node).insert((MutableTreeNode)this.getNode(child), k);
                }
                ++k;
            }
            if (newIds.size() > 0) {
                this.nodesWereInserted((TreeNode)node, newIds.toNativeArray());
            }
            if (((DefaultMutableTreeNode)node).getChildCount() > k) {
                TIntArrayList leftIds = new TIntArrayList();
                ArrayList<N> leftNodes = new ArrayList<N>();
                for (int i2 = ((DefaultMutableTreeNode)node).getChildCount() - 1; i2 >= k; --i2) {
                    leftNodes.add(SearchTreeModel.getChild(node, i2));
                    ((DefaultMutableTreeNode)node).remove(i2);
                    leftIds.add(i2);
                }
                leftIds.reverse();
                Collections.reverse(leftNodes);
                if (leftIds.size() > 0) {
                    this.nodesWereRemoved((TreeNode)node, leftIds.toNativeArray(), leftNodes.toArray());
                }
            }
        }

        private void removeNotAccepted(@NotNull N node, Set<U> accepted) {
            TIntArrayList removedIds = new TIntArrayList();
            ArrayList<N> removedNodes = new ArrayList<N>();
            for (int i2 = ((DefaultMutableTreeNode)node).getChildCount() - 1; i2 >= 0; --i2) {
                N child = SearchTreeModel.getChild(node, i2);
                if (accepted.contains(this.getUserObject(child))) continue;
                removedIds.add(i2);
                removedNodes.add(child);
                ((DefaultMutableTreeNode)node).remove(i2);
            }
            removedIds.reverse();
            Collections.reverse(removedNodes);
            if (removedIds.size() > 0) {
                this.nodesWereRemoved((TreeNode)node, removedIds.toNativeArray(), removedNodes.toArray());
            }
        }

        protected boolean accept(@Nullable String name) {
            if (name == null) {
                return true;
            }
            return this.mySpeedSearch.matchingFragments(name) != null;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getRoot() != node && super.isLeaf(node);
        }

        @Nullable
        public final U getUserObject(@Nullable N node) {
            return (U)(node == null ? null : ((DefaultMutableTreeNode)node).getUserObject());
        }

        private static /* synthetic */ boolean lambda$refilter$0(Set acceptCache, Object x) {
            return acceptCache.contains(x);
        }

        public static interface Listener<U>
        extends EventListener {
            public void beforeNodeChanged(U var1);

            public void nodeChanged(U var1);
        }
    }
}

