/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.CustomIconProvider;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import git4idea.GitLocalBranch;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.GitOngoingOperationAction;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.branch.GitBranchOperationType;
import git4idea.branch.GitBranchType;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.push.GitPushSource;
import git4idea.rebase.GitRebaseSpec;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.ui.branch.GitRefDialog;
import icons.DvcsImplIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchPopupActions {
    private final Project myProject;
    private final GitRepository myRepository;

    GitBranchPopupActions(Project project, GitRepository repository) {
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, null, false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @Nullable GitRepository specificRepository, boolean firstLevelGroup) {
        LightActionGroup popupGroup = new LightActionGroup(false);
        List<GitRepository> repositoryList = Collections.singletonList(this.myRepository);
        GitRebaseSpec rebaseSpec = GitRepositoryManager.getInstance(this.myProject).getOngoingRebaseSpec();
        if (rebaseSpec != null && GitBranchPopupActions.isSpecForRepo(rebaseSpec, this.myRepository)) {
            popupGroup.addAll(GitBranchPopupActions.getRebaseActions());
        } else {
            popupGroup.addAll(GitBranchPopupActions.createPerRepoRebaseActions(this.myRepository));
        }
        popupGroup.addAction((AnAction)new GitNewBranchAction(this.myProject, repositoryList));
        popupGroup.addAction((AnAction)new CheckoutRevisionActions(this.myProject, repositoryList));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.local.branches", new Object[0]) : GitBundle.message("branches.local.branches.in.repo", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        GitLocalBranch currentBranch = this.myRepository.getCurrentBranch();
        GitBranchesCollection branchesCollection = this.myRepository.getBranches();
        List localBranchActions = ((StreamEx)((StreamEx)StreamEx.of(branchesCollection.getLocalBranches()).filter(branch -> !branch.equals(currentBranch))).map(branch -> new LocalBranchActions(this.myProject, repositoryList, branch.getName(), this.myRepository)).sorted((b1, b2) -> {
            int delta = BranchActionUtil.FAVORITE_BRANCH_COMPARATOR.compare(b1, b2);
            if (delta != 0) {
                return delta;
            }
            return StringUtil.naturalCompare((String)b1.myBranchName, (String)b2.myBranchName);
        })).toList();
        int topShownBranches = BranchActionUtil.getNumOfTopShownBranches((List)localBranchActions);
        if (currentBranch != null) {
            localBranchActions.add(0, new CurrentBranchActions(this.myProject, repositoryList, currentBranch.getName(), this.myRepository));
            ++topShownBranches;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)localBranchActions, (int)topShownBranches, (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllLocals" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator(specificRepository == null ? GitBundle.message("branches.remote.branches", new Object[0]) : GitBundle.message("branches.remote.branches.in.repo", specificRepository));
        List remoteBranchActions = ((StreamEx)StreamEx.of(branchesCollection.getRemoteBranches()).map(GitReference::getName).sorted(StringUtil::naturalCompare)).map(remoteName -> new RemoteBranchActions(this.myProject, (List<? extends GitRepository>)repositoryList, (String)remoteName, this.myRepository)).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches((List)remoteBranchActions), (String)(firstLevelGroup ? "Git.Branch.Popup.ShowAllRemotes" : null));
        return popupGroup;
    }

    private static boolean isSpecForRepo(@NotNull GitRebaseSpec spec, @NotNull GitRepository repository) {
        Collection<GitRepository> repositoriesFromSpec = spec.getAllRepositories();
        return repositoriesFromSpec.size() == 1 && repository.equals(ContainerUtil.getFirstItem(repositoriesFromSpec));
    }

    @NotNull
    private static List<AnAction> createPerRepoRebaseActions(@NotNull GitRepository repository) {
        return ContainerUtil.mapNotNull(GitBranchPopupActions.getRebaseActions(), action -> GitBranchPopupActions.createRepositoryRebaseAction(action, repository));
    }

    @NotNull
    static List<AnAction> getRebaseActions() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Git.Ongoing.Rebase.Actions");
        return Arrays.asList(group.getChildren(null));
    }

    @Nullable
    private static AnAction createRepositoryRebaseAction(@NotNull AnAction rebaseAction, final @NotNull GitRepository repository) {
        if (!(rebaseAction instanceof GitOngoingOperationAction)) {
            return null;
        }
        final GitOngoingOperationAction ongoingAction = (GitOngoingOperationAction)rebaseAction;
        DumbAwareAction repositoryAction = new DumbAwareAction(){

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(ongoingAction.isEnabled(repository));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ongoingAction.performInBackground(repository);
            }
        };
        repositoryAction.getTemplatePresentation().copyFrom(rebaseAction.getTemplatePresentation());
        return repositoryAction;
    }

    @NotNull
    private static String getCurrentBranchPresentation(@NotNull Collection<? extends GitRepository> repositories) {
        Set currentBranches = ContainerUtil.map2Set(repositories, repo -> (String)ObjectUtils.notNull((Object)repo.getCurrentBranchName(), (Object)DvcsUtil.getShortHash((String)Objects.requireNonNull(repo.getCurrentRevision()))));
        if (currentBranches.size() == 1) {
            return GitBranchPopupActions.getBranchPresentation((String)currentBranches.iterator().next());
        }
        return GitBundle.message("branches.current.branch", new Object[0]);
    }

    @NotNull
    private static String getBranchPresentation(@NotNull String branch) {
        return "'" + branch + "'";
    }

    static class TagActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myTagName;

        TagActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String tagName) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myTagName = tagName;
            this.getTemplatePresentation().setText(tagName, false);
            this.setIcons(EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16, EmptyIcon.ICON_16);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new DeleteTagAction(this.myProject, this.myRepositories, this.myTagName)};
        }

        private static class DeleteTagAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myTagName;

            DeleteTagAction(Project project, List<? extends GitRepository> repositories, String tagName) {
                super(IdeBundle.message((String)"button.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myTagName = tagName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteTag(this.myTagName, this.myRepositories);
            }
        }
    }

    private static class UpdateSelectedBranchAction
    extends DumbAwareAction
    implements CustomIconProvider {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final List<String> myBranchNameList;
        private final boolean myHasIncoming;

        UpdateSelectedBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean hasIncoming) {
            super(GitBundle.messagePointer("branches.update", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myBranchNameList = Collections.singletonList(branchName);
            this.myHasIncoming = hasIncoming;
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !GitBranchActionsUtilKt.hasRemotes(project)) {
                presentation.setEnabledAndVisible(false);
                return;
            }
            String branchPresentation = GitBranchPopupActions.getBranchPresentation(this.myBranchName);
            String description = GitBundle.message("branches.fetch.remote.and.fast.forward", branchPresentation, this.myBranchName);
            presentation.setDescription(description);
            if (GitFetchSupport.fetchSupport(this.myProject).isFetchRunning()) {
                presentation.setEnabled(false);
                presentation.setDescription(GitBundle.message("branches.update.is.already.running", new Object[0]));
                return;
            }
            boolean trackingInfosExist = GitBranchActionsUtilKt.isTrackingInfosExist(this.myBranchNameList, this.myRepositories);
            presentation.setEnabled(trackingInfosExist);
            if (!trackingInfosExist) {
                presentation.setDescription(GitBundle.message("branches.tracking.branch.doesn.t.configured.for.s", branchPresentation));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBranchActionsUtilKt.updateBranches(this.myProject, this.myRepositories, this.myBranchNameList);
        }

        @Nullable
        public Icon getRightIcon() {
            return this.myHasIncoming ? DvcsImplIcons.Incoming : null;
        }
    }

    private static class CheckoutWithRebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CheckoutWithRebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.checkout.and.rebase.onto.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            String description = GitBundle.message("branches.checkout.and.rebase.onto.in.one.step", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories), this.myBranchName);
            e.getPresentation().setDescription(description);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebaseOnCurrent(this.myRepositories, this.myBranchName);
        }
    }

    private static class RebaseAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        RebaseAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.rebase.current.onto.selected", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isOnBranch = ContainerUtil.and(this.myRepositories, GitRepository::isOnBranch);
            String description = isOnBranch ? GitBundle.message("branches.rebase.onto", GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories), GitBranchPopupActions.getBranchPresentation(this.myBranchName)) : GitBundle.message("branches.rebase.is.not.possible.in.the.detached.head.state", new Object[0]);
            e.getPresentation().setDescription(description);
            e.getPresentation().setEnabled(isOnBranch);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.rebase(this.myRepositories, this.myBranchName);
        }
    }

    private static class MergeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        private final boolean myLocalBranch;

        MergeAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, boolean localBranch) {
            super(GitBundle.messagePointer("branches.merge.into.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.myLocalBranch = localBranch;
        }

        public void update(@NotNull AnActionEvent e) {
            String description = GitBundle.message("branches.merge.into", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories));
            e.getPresentation().setDescription(description);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.merge(this.myBranchName, this.deleteOnMerge(), this.myRepositories);
        }

        private GitBrancher.DeleteOnMergeOption deleteOnMerge() {
            if (this.myLocalBranch && !this.myBranchName.equals("master")) {
                return GitBrancher.DeleteOnMergeOption.PROPOSE;
            }
            return GitBrancher.DeleteOnMergeOption.NOTHING;
        }
    }

    private static class ShowDiffWithBranchAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        ShowDiffWithBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.show.diff.with.working.tree", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBrancher.getInstance(this.myProject).showDiffWithLocal(this.myBranchName, ContainerUtil.filter(this.myRepositories, repository -> !this.myBranchName.equals(repository.getCurrentBranchName())));
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(!new GitMultiRootBranchConfig(this.myRepositories).diverged());
            String description = GitBundle.message("branches.compare.the.current.working.tree.with", GitBranchPopupActions.getBranchPresentation(this.myBranchName));
            e.getPresentation().setDescription(description);
        }
    }

    private static class CompareAction
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CompareAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.compare.with.current", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            FileDocumentManager.getInstance().saveAllDocuments();
            GitBrancher brancher = GitBrancher.getInstance(this.myProject);
            brancher.compare(this.myBranchName, this.myRepositories);
        }

        public void update(@NotNull AnActionEvent e) {
            String description = GitBundle.message("branches.show.commits.in", GitBranchPopupActions.getBranchPresentation(this.myBranchName), GitBranchPopupActions.getCurrentBranchPresentation(this.myRepositories));
            e.getPresentation().setDescription(description);
        }
    }

    private static class CheckoutAsNewBranch
    extends DumbAwareAction {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;

        CheckoutAsNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
            super(GitBundle.messagePointer("branches.new.branch.from.selected", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, this.myBranchName + "^0", GitBundle.message("action.Git.New.Branch.dialog.title", this.myBranchName));
        }
    }

    public static class RemoteBranchActions
    extends BranchActionGroup {
        private final Project myProject;
        private final List<? extends GitRepository> myRepositories;
        private final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        @NotNull
        private final GitBranchManager myGitBranchManager;

        public RemoteBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = repositories;
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.getTemplatePresentation().setText(this.myBranchName, false);
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.REMOTE, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.REMOTE, this.myRepositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName, this.isFavorite());
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutRemoteBranchAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, false), new Separator(), new RemoteDeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        private static class RemoteDeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            RemoteDeleteAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.deleteRemoteBranch(this.myBranchName, this.myRepositories);
            }

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(!GitProtectedBranchesKt.isRemoteBranchProtected(this.myRepositories, this.myBranchName));
            }
        }

        public static class CheckoutRemoteBranchAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myRemoteBranchName;

            CheckoutRemoteBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myRemoteBranchName = remoteBranchName;
            }

            public static void checkoutRemoteBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName) {
                boolean hasCommits;
                GitRepository repository = repositories.get(0);
                GitRemoteBranch remoteBranch = Objects.requireNonNull(repository.getBranches().findRemoteBranch(remoteBranchName));
                String suggestedLocalName = remoteBranch.getNameForRemoteOperations();
                if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)suggestedLocalName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories, remoteBranchName, suggestedLocalName);
                    return;
                }
                Map conflictingLocalBranches = ContainerUtil.map2MapNotNull(repositories, r -> {
                    GitLocalBranch local = r.getBranches().findLocalBranch(suggestedLocalName);
                    return local != null ? Pair.create((Object)r, (Object)local) : null;
                });
                if (CheckoutRemoteBranchAction.hasTrackingConflicts(conflictingLocalBranches, remoteBranchName)) {
                    CheckoutRemoteBranchAction.askNewBranchNameAndCheckout(project, repositories, remoteBranchName, suggestedLocalName);
                    return;
                }
                boolean bl = hasCommits = !conflictingLocalBranches.isEmpty() && GitBranchActionsUtilKt.checkCommitsUnderProgress(project, repositories, remoteBranchName, suggestedLocalName);
                if (hasCommits) {
                    int result2 = Messages.showYesNoCancelDialog((String)GitBundle.message("branch.0.already.exists.and.has.commits.which.do.not.exist.in.1.would.you.like.to.rebase.or.reset.them", suggestedLocalName, remoteBranchName), (String)GitBundle.message("checkout.0", remoteBranchName), (String)GitBundle.message("checkout.and.rebase", new Object[0]), (String)CommonBundle.message((String)"button.overwrite", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), null);
                    if (result2 == 2) {
                        return;
                    }
                    if (result2 == 0) {
                        GitBranchActionsUtilKt.checkout(project, repositories, remoteBranchName, suggestedLocalName, true);
                        return;
                    }
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkoutNewBranchStartingFrom(suggestedLocalName, remoteBranchName, !conflictingLocalBranches.isEmpty(), repositories, null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CheckoutRemoteBranchAction.checkoutRemoteBranch(this.myProject, this.myRepositories, this.myRemoteBranchName);
            }

            private static void askNewBranchNameAndCheckout(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String remoteBranchName, @NotNull String suggestedLocalName) {
                GitNewBranchOptions options = new GitNewBranchDialog(project, repositories, GitBundle.message("branches.checkout.s", remoteBranchName), suggestedLocalName, false, true).showAndGetOptions();
                if (options == null) {
                    return;
                }
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkoutNewBranchStartingFrom(options.getName(), remoteBranchName, options.shouldReset(), repositories, null);
            }

            private static boolean hasTrackingConflicts(@NotNull Map<GitRepository, GitLocalBranch> conflictingLocalBranches, @NotNull String remoteBranchName) {
                return StreamEx.of(conflictingLocalBranches.keySet()).anyMatch(r -> {
                    GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(r, (GitLocalBranch)conflictingLocalBranches.get(r));
                    return trackInfo != null && !GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)remoteBranchName, (Object)trackInfo.getRemoteBranch().getName());
                });
            }
        }
    }

    public static class CurrentBranchActions
    extends LocalBranchActions {
        public CurrentBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            super(project, repositories, branchName, selectedRepository);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new LocalBranchActions.RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new LocalBranchActions.PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits())};
        }
    }

    public static class LocalBranchActions
    extends BranchActionGroup
    implements PopupElementWithAdditionalInfo {
        protected final Project myProject;
        protected final List<GitRepository> myRepositories;
        protected final String myBranchName;
        @NotNull
        private final GitRepository mySelectedRepository;
        private final GitBranchManager myGitBranchManager;
        @NotNull
        private final GitBranchIncomingOutgoingManager myIncomingOutgoingManager;

        public LocalBranchActions(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName, @NotNull GitRepository selectedRepository) {
            this.myProject = project;
            this.myRepositories = ContainerUtil.immutableList(repositories);
            this.myBranchName = branchName;
            this.mySelectedRepository = selectedRepository;
            this.myGitBranchManager = (GitBranchManager)((Object)ServiceManager.getService((Project)project, GitBranchManager.class));
            this.myIncomingOutgoingManager = GitBranchIncomingOutgoingManager.getInstance(this.myProject);
            this.getTemplatePresentation().setText(this.calcBranchText(), false);
            this.getTemplatePresentation().putClientProperty("ToolTipText", (Object)this.constructTooltip());
            this.setFavorite(this.myGitBranchManager.isFavorite(GitBranchType.LOCAL, repositories.size() > 1 ? null : this.mySelectedRepository, this.myBranchName));
        }

        @NotNull
        private String calcBranchText() {
            return this.myBranchName;
        }

        @NotNull
        List<GitRepository> getRepositories() {
            return this.myRepositories;
        }

        @NotNull
        public String getBranchName() {
            return this.myBranchName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        private String constructTooltip() {
            boolean incoming = this.hasIncomingCommits();
            boolean outgoing = this.hasOutgoingCommits();
            if (!incoming && !outgoing) {
                return null;
            }
            if (incoming && outgoing) {
                return GitBundle.message("branches.there.are.incoming.and.outgoing.commits", new Object[0]);
            }
            if (incoming) {
                return GitBundle.message("branches.there.are.incoming.commits", new Object[0]);
            }
            return GitBundle.message("branches.there.are.outgoing.commits", new Object[0]);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            return new AnAction[]{new CheckoutAction(this.myProject, this.myRepositories, this.myBranchName), new CheckoutAsNewBranch(this.myProject, this.myRepositories, this.myBranchName), new CheckoutWithRebaseAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new CompareAction(this.myProject, this.myRepositories, this.myBranchName), new ShowDiffWithBranchAction(this.myProject, this.myRepositories, this.myBranchName), new Separator(), new RebaseAction(this.myProject, this.myRepositories, this.myBranchName), new MergeAction(this.myProject, this.myRepositories, this.myBranchName, true), new Separator(), new UpdateSelectedBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasIncomingCommits()), new PushBranchAction(this.myProject, this.myRepositories, this.myBranchName, this.hasOutgoingCommits()), new Separator(), new RenameBranchAction(this.myProject, this.myRepositories, this.myBranchName), new DeleteAction(this.myProject, this.myRepositories, this.myBranchName)};
        }

        @Nullable
        public String getInfoText() {
            return new GitMultiRootBranchConfig(this.myRepositories).getTrackedBranch(this.myBranchName);
        }

        public void toggle() {
            super.toggle();
            this.myGitBranchManager.setFavorite(GitBranchType.LOCAL, this.chooseRepo(), this.myBranchName, this.isFavorite());
        }

        @Nullable
        private GitRepository chooseRepo() {
            return this.myRepositories.size() > 1 ? null : this.mySelectedRepository;
        }

        public boolean hasIncomingCommits() {
            return this.myIncomingOutgoingManager.hasIncomingFor(this.chooseRepo(), this.myBranchName);
        }

        public boolean hasOutgoingCommits() {
            return this.myIncomingOutgoingManager.hasOutgoingFor(this.chooseRepo(), this.myBranchName);
        }

        private static class DeleteAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            DeleteAction(Project project, List<? extends GitRepository> repositories, String branchName) {
                super(IdeBundle.messagePointer((String)"action.delete", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitBrancher.getInstance(this.myProject).deleteBranch(this.myBranchName, ContainerUtil.filter(this.myRepositories, repository -> !this.myBranchName.equals(repository.getCurrentBranchName())));
            }
        }

        public static class RenameBranchAction
        extends DumbAwareAction {
            @NotNull
            private final Project myProject;
            @NotNull
            private final List<? extends GitRepository> myRepositories;
            @NotNull
            private final String myCurrentBranchName;

            RenameBranchAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
                super(ActionsBundle.messagePointer((String)"action.RenameAction.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myCurrentBranchName = currentBranchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                RenameBranchAction.rename(this.myProject, this.myRepositories, this.myCurrentBranchName);
            }

            public static void rename(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String currentBranchName) {
                GitNewBranchOptions options = new GitNewBranchDialog(project, repositories, GitBundle.message("branches.rename.branch", currentBranchName), currentBranchName, false, false, false, false, GitBranchOperationType.RENAME).showAndGetOptions();
                if (options != null) {
                    GitBrancher brancher = GitBrancher.getInstance(project);
                    brancher.renameBranch(currentBranchName, options.getName(), repositories);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (this.myRepositories.stream().anyMatch(Repository::isFresh)) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setDescription(GitBundle.message("branches.renaming.branch.is.not.possible.before.the.first.commit", new Object[0]));
                }
            }
        }

        private static class PushBranchAction
        extends DumbAwareAction
        implements CustomIconProvider {
            private final Project myProject;
            private final List<GitRepository> myRepositories;
            private final String myBranchName;
            private final boolean myHasCommitsToPush;

            PushBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull String branchName, boolean hasCommitsToPush) {
                super(ActionsBundle.messagePointer((String)"action.Vcs.Push.text", (Object[])new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
                this.myHasCommitsToPush = hasCommitsToPush;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                GitLocalBranch localBranch = this.myRepositories.get(0).getBranches().findLocalBranch(this.myBranchName);
                assert (localBranch != null);
                new VcsPushDialog(this.myProject, this.myRepositories, this.myRepositories, null, (PushSource)GitPushSource.create(localBranch)).show();
            }

            @Nullable
            public Icon getRightIcon() {
                return this.myHasCommitsToPush ? DvcsImplIcons.Outgoing : null;
            }
        }

        public static class CheckoutAction
        extends DumbAwareAction {
            private final Project myProject;
            private final List<? extends GitRepository> myRepositories;
            private final String myBranchName;

            public CheckoutAction(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                super(GitBundle.messagePointer("branches.checkout", new Object[0]));
                this.myProject = project;
                this.myRepositories = repositories;
                this.myBranchName = branchName;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CheckoutAction.checkoutBranch(this.myProject, this.myRepositories, this.myBranchName);
            }

            public static void checkoutBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
                GitBrancher brancher = GitBrancher.getInstance(project);
                brancher.checkout(branchName, false, repositories, null);
            }
        }
    }

    public static class CheckoutRevisionActions
    extends DumbAwareAction {
        private final Project myProject;
        private final List<GitRepository> myRepositories;

        CheckoutRevisionActions(Project project, List<GitRepository> repositories) {
            super(GitBundle.message("branches.checkout.tag.or.revision", new Object[0]));
            this.myProject = project;
            this.myRepositories = repositories;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitRefDialog dialog2 = new GitRefDialog(this.myProject, this.myRepositories, GitBundle.message("branches.checkout", new Object[0]), GitBundle.message("branches.enter.reference.branch.tag.name.or.commit.hash", new Object[0]));
            if (dialog2.showAndGet()) {
                String reference = dialog2.getReference();
                GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                brancher.checkout(reference, true, this.myRepositories, null);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            boolean isFresh = ContainerUtil.and(this.myRepositories, repository -> repository.isFresh());
            if (isFresh) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription(GitBundle.message("branches.checkout.is.not.possible.before.the.first.commit", new Object[0]));
            }
        }
    }

    public static class GitNewBranchAction
    extends NewBranchAction<GitRepository> {
        public GitNewBranchAction(@NotNull Project project, @NotNull List<GitRepository> repositories) {
            super(project, repositories);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            GitBranchActionsUtilKt.createOrCheckoutNewBranch(this.myProject, this.myRepositories, "HEAD");
        }
    }
}

