/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StashInfo {
    @NotNull
    private final String myStash;
    private final String myBranch;
    private final String myMessage;
    private final String myText;

    public StashInfo(@NotNull String stash, @Nullable String branch, @NotNull String message) {
        this.myStash = stash;
        this.myBranch = branch;
        this.myMessage = message;
        StringBuilder sb = new StringBuilder();
        sb.append("<html><b><tt>").append(StringUtil.escapeXmlEntities((String)stash)).append("</tt></b>: ");
        if (branch != null) {
            sb.append("<i>").append(StringUtil.escapeXmlEntities((String)branch)).append("</i>: ");
        }
        sb.append(StringUtil.escapeXmlEntities((String)message)).append("</html>");
        this.myText = sb.toString();
    }

    public String toString() {
        return this.myText;
    }

    @NotNull
    public String getStash() {
        return this.myStash;
    }

    @Nullable
    public String getBranch() {
        return this.myBranch;
    }

    @NotNull
    public String getMessage() {
        return this.myMessage;
    }

    public String getText() {
        return this.myText;
    }
}

