/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.stash.GitStashUtils;
import git4idea.ui.GitUnstashDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStashChangesSaver
extends GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitStashChangesSaver.class);
    private static final String NO_LOCAL_CHANGES_TO_SAVE = "No local changes to save";
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final Map<VirtualFile, Hash> myStashedRoots = new HashMap<VirtualFile, Hash>();

    public GitStashChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage) {
        super(project, git, progressIndicator, GitSaveChangesPolicy.STASH, stashMessage);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    @Override
    protected void save(@NotNull Collection<? extends VirtualFile> rootsToSave) throws VcsException {
        LOG.info("saving " + rootsToSave);
        for (VirtualFile virtualFile : rootsToSave) {
            String message = GitBundle.message("stash.progress.indicator.title", virtualFile.getName());
            LOG.info(message);
            String oldProgressTitle = this.myProgressIndicator.getText();
            this.myProgressIndicator.setText(message);
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(virtualFile);
            if (repository == null) {
                LOG.error("Repository is null for root " + virtualFile);
            } else {
                GitCommandResult result2 = this.myGit.stashSave(repository, this.myStashMessage);
                if (result2.success() && GitStashChangesSaver.somethingWasStashed(result2)) {
                    this.myStashedRoots.put(virtualFile, this.myGit.resolveReference(repository, "stash@{0}"));
                } else {
                    if (!result2.success()) {
                        throw new VcsException("Couldn't stash " + repository.getRoot() + ": " + result2.getErrorOutputAsJoinedString());
                    }
                    LOG.warn("There was nothing to stash in " + repository.getRoot());
                }
            }
            this.myProgressIndicator.setText(oldProgressTitle);
        }
    }

    private static boolean somethingWasStashed(@NotNull GitCommandResult result2) {
        return !StringUtil.containsIgnoreCase((String)result2.getErrorOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE) && !StringUtil.containsIgnoreCase((String)result2.getOutputAsJoinedString(), (String)NO_LOCAL_CHANGES_TO_SAVE);
    }

    @Override
    public void load() {
        String oldProgressTitle = this.myProgressIndicator.getText();
        GitStashUtils.unstash(this.myProject, this.myStashedRoots, (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)root -> {
            String message = GitBundle.message("stash.unstash.progress.indicator.title", root.getName());
            this.myProgressIndicator.setText(message);
            GitLineHandler handler = new GitLineHandler(this.myProject, (VirtualFile)root, GitCommand.STASH);
            handler.addParameters("pop");
            return handler;
        }), new UnstashConflictResolver(this.myProject, this.myGit, this.myStashedRoots.keySet(), this.myParams));
        this.myProgressIndicator.setText(oldProgressTitle);
    }

    @Override
    public boolean wereChangesSaved() {
        return !this.myStashedRoots.isEmpty();
    }

    @Override
    public void showSavedChanges() {
        GitUnstashDialog.showUnstashDialog(this.myProject, new ArrayList<VirtualFile>(this.myStashedRoots.keySet()), this.myStashedRoots.keySet().iterator().next());
    }

    public String toString() {
        return "StashChangesSaver. Roots: " + this.myStashedRoots;
    }

    private static class UnstashMergeDialogCustomizer
    extends MergeDialogCustomizer {
        private UnstashMergeDialogCustomizer() {
        }

        @NotNull
        public String getMultipleFileMergeDescription(@NotNull Collection<VirtualFile> files) {
            return GitBundle.getString("stash.unstash.conflict.dialog.description.label.text");
        }

        @NotNull
        public String getLeftPanelTitle(@NotNull VirtualFile file) {
            return GitChangesSaver.getConflictLeftPanelTitle();
        }

        @NotNull
        public String getRightPanelTitle(@NotNull VirtualFile file, VcsRevisionNumber revisionNumber) {
            return GitChangesSaver.getConflictRightPanelTitle();
        }
    }

    private static class UnstashConflictResolver
    extends GitConflictResolver {
        private final Set<? extends VirtualFile> myStashedRoots;

        UnstashConflictResolver(@NotNull Project project, @NotNull Git git, @NotNull Set<? extends VirtualFile> stashedRoots, @Nullable GitConflictResolver.Params params) {
            super(project, stashedRoots, UnstashConflictResolver.makeParamsOrUse(params, project));
            this.myStashedRoots = stashedRoots;
        }

        private static GitConflictResolver.Params makeParamsOrUse(@Nullable GitConflictResolver.Params givenParams, Project project) {
            if (givenParams != null) {
                return givenParams;
            }
            GitConflictResolver.Params params = new GitConflictResolver.Params(project);
            params.setErrorNotificationTitle(GitBundle.message("preserving.process.local.changes.not.restored.error.title", new Object[0]));
            params.setMergeDialogCustomizer(new UnstashMergeDialogCustomizer());
            params.setReverse(true);
            return params;
        }

        @Override
        protected void notifyUnresolvedRemain() {
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning(GitBundle.getString("stash.unstash.unresolved.conflict.warning.notification.title"), GitBundle.getString("stash.unstash.unresolved.conflict.warning.notification.message"), new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        if (event.getDescription().equals("saver")) {
                            GitUnstashDialog.showUnstashDialog(myProject, new ArrayList<VirtualFile>(myStashedRoots), (VirtualFile)myStashedRoots.iterator().next());
                        } else if (event.getDescription().equals("resolve")) {
                            this.mergeNoProceed();
                        }
                    }
                }
            });
        }
    }
}

