/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRefUtil {
    private static final Logger LOG = Logger.getInstance(GitRefUtil.class);
    private static final Pattern BRANCH_PATTERN = Pattern.compile(" *(?:ref:)? */?((?:refs/heads/|refs/remotes/)?\\S+)");

    @Nullable
    public static String addRefsHeadsPrefixIfNeeded(@Nullable String branchName) {
        if (branchName != null && !branchName.startsWith("refs/heads/")) {
            return "refs/heads/" + branchName;
        }
        return branchName;
    }

    @Nullable
    public static Pair<String, String> parseRefsLine(@NotNull String line) {
        int i2;
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == '^') {
            return null;
        }
        String hash = null;
        for (i2 = 0; i2 < line.length(); ++i2) {
            char c = line.charAt(i2);
            if (Character.isLetterOrDigit(c)) continue;
            hash = line.substring(0, i2);
            break;
        }
        if (hash == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        String branch = null;
        int start = i2;
        if (start < line.length() && Character.isWhitespace(line.charAt(start++))) {
            char c;
            for (i2 = start; i2 < line.length() && !Character.isWhitespace(c = line.charAt(i2)); ++i2) {
            }
            branch = line.substring(start, i2);
        }
        if (branch == null || !branch.startsWith("refs/heads/") && !branch.startsWith("refs/remotes/")) {
            return null;
        }
        return Pair.create((Object)GitRefUtil.shortBuffer(branch), (Object)GitRefUtil.shortBuffer(hash.trim()));
    }

    @NotNull
    private static String shortBuffer(String raw) {
        return new String(raw);
    }

    @NotNull
    static Map<String, Hash> resolveRefs(@NotNull Map<String, String> data) {
        Map<String, Hash> resolved = GitRefUtil.getResolvedHashes(data);
        Map unresolved = ContainerUtil.filter(data, refName -> !resolved.containsKey(refName));
        boolean progressed = true;
        while (progressed && !unresolved.isEmpty()) {
            progressed = false;
            Iterator iterator = unresolved.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String refName2 = (String)entry.getKey();
                String refValue = (String)entry.getValue();
                String link = GitRefUtil.getTarget(refValue);
                if (link != null) {
                    if (GitRefUtil.duplicateEntry(resolved, refName2, refValue)) {
                        iterator.remove();
                        continue;
                    }
                    if (!resolved.containsKey(link)) {
                        LOG.debug("Unresolved symbolic link [" + refName2 + "] pointing to [" + refValue + "]");
                        continue;
                    }
                    Hash targetValue = resolved.get(link);
                    resolved.put(refName2, targetValue);
                    iterator.remove();
                    progressed = true;
                    continue;
                }
                LOG.warn("Unexpected record [" + refName2 + "] -> [" + refValue + "]");
                iterator.remove();
            }
        }
        if (!unresolved.isEmpty()) {
            LOG.warn("Cyclic symbolic links among .git/refs: " + unresolved);
        }
        return resolved;
    }

    @NotNull
    public static Map<String, Hash> getResolvedHashes(@NotNull Map<String, String> data) {
        HashMap<String, Hash> resolved = new HashMap<String, Hash>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String refName = entry.getKey();
            Hash hash = GitRefUtil.parseHash(entry.getValue());
            if (hash == null || GitRefUtil.duplicateEntry(resolved, refName, hash)) continue;
            resolved.put(refName, hash);
        }
        return resolved;
    }

    @Nullable
    static String getTarget(@NotNull String refName) {
        Matcher matcher = BRANCH_PATTERN.matcher(refName);
        if (!matcher.matches()) {
            return null;
        }
        String target = matcher.group(1);
        if (!target.startsWith("refs/heads/") && !target.startsWith("refs/remotes/")) {
            target = "refs/heads/" + target;
        }
        return target;
    }

    @Nullable
    static Hash parseHash(@NotNull String value) {
        try {
            return HashImpl.build((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean duplicateEntry(@NotNull Map<String, Hash> resolved, @NotNull String refName, @NotNull Object newValue) {
        if (resolved.containsKey(refName)) {
            LOG.error("Duplicate entry for [" + refName + "]. resolved: [" + resolved.get(refName).asString() + "], current: " + newValue + "]");
            return true;
        }
        return false;
    }
}

