/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class GitConflict {
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final Status myOurStatus;
    @NotNull
    private final Status myTheirStatus;

    public GitConflict(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull Status ourStatus, @NotNull Status theirStatus) {
        this.myRoot = root;
        this.myFilePath = filePath;
        this.myOurStatus = ourStatus;
        this.myTheirStatus = theirStatus;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @NotNull
    public FilePath getFilePath() {
        return this.myFilePath;
    }

    @NotNull
    public Status getStatus(@NotNull ConflictSide side) {
        return this.getStatus(side, false);
    }

    @NotNull
    public Status getStatus(@NotNull ConflictSide side, boolean isReversed) {
        if (side == ConflictSide.OURS) {
            return !isReversed ? this.myOurStatus : this.myTheirStatus;
        }
        return !isReversed ? this.myTheirStatus : this.myOurStatus;
    }

    public static enum ConflictSide {
        OURS,
        THEIRS;

    }

    public static enum Status {
        MODIFIED,
        DELETED,
        ADDED;

    }
}

