/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfigHelperKt;
import git4idea.repo.GitRemote;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitConfig {
    private static final Logger LOG = Logger.getInstance(GitConfig.class);
    private static final Pattern REMOTE_SECTION = Pattern.compile("(?:svn-)?remote \"(.*)\"", 2);
    private static final Pattern URL_SECTION = Pattern.compile("url \"(.*)\"", 2);
    private static final Pattern BRANCH_INFO_SECTION = Pattern.compile("branch \"(.*)\"", 2);
    private static final Pattern BRANCH_COMMON_PARAMS_SECTION = Pattern.compile("branch", 2);
    @NotNull
    private final Collection<? extends Remote> myRemotes;
    @NotNull
    private final Collection<? extends Url> myUrls;
    @NotNull
    private final Collection<? extends BranchConfig> myTrackedInfos;

    private GitConfig(@NotNull Collection<? extends Remote> remotes, @NotNull Collection<? extends Url> urls, @NotNull Collection<? extends BranchConfig> trackedInfos) {
        this.myRemotes = remotes;
        this.myUrls = urls;
        this.myTrackedInfos = trackedInfos;
    }

    @NotNull
    Collection<GitRemote> parseRemotes() {
        return ((StreamEx)StreamEx.of(this.myRemotes).map(remote -> GitConfig.convertRemoteToGitRemote(this.myUrls, remote)).filter(remote -> !remote.getUrls().isEmpty())).toList();
    }

    @NotNull
    private static GitRemote convertRemoteToGitRemote(@NotNull Collection<? extends Url> urls, @NotNull Remote remote) {
        UrlsAndPushUrls substitutedUrls = GitConfig.substituteUrls(urls, remote);
        return new GitRemote(remote.myName, substitutedUrls.getUrls(), substitutedUrls.getPushUrls(), remote.getFetchSpecs(), remote.getPushSpec());
    }

    @NotNull
    Collection<GitBranchTrackInfo> parseTrackInfos(@NotNull Collection<? extends GitLocalBranch> localBranches, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        return ContainerUtil.mapNotNull(this.myTrackedInfos, config -> GitConfig.convertBranchConfig(config, localBranches, remoteBranches));
    }

    @NotNull
    static GitConfig read(@NotNull File configFile) {
        Ini ini;
        GitConfig emptyConfig = new GitConfig(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        if (!configFile.exists()) {
            LOG.info("No .git/config file at " + configFile.getPath());
            return emptyConfig;
        }
        try {
            ini = GitConfigHelperKt.loadIniFile(configFile);
        }
        catch (IOException e) {
            return emptyConfig;
        }
        Pair<Collection<Remote>, Collection<Url>> remotesAndUrls = GitConfig.parseRemotes(ini);
        Collection<BranchConfig> trackedInfos = GitConfig.parseTrackedInfos(ini);
        return new GitConfig((Collection)remotesAndUrls.getFirst(), (Collection)remotesAndUrls.getSecond(), trackedInfos);
    }

    @NotNull
    private static Collection<BranchConfig> parseTrackedInfos(@NotNull Ini ini) {
        ArrayList<BranchConfig> configs = new ArrayList<BranchConfig>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            BranchConfig branchConfig;
            String sectionName = (String)stringSectionEntry.getKey();
            Profile.Section section = (Profile.Section)stringSectionEntry.getValue();
            if (!StringUtil.startsWithIgnoreCase((String)sectionName, (String)"branch") || (branchConfig = GitConfig.parseBranchSection(sectionName, section)) == null) continue;
            configs.add(branchConfig);
        }
        return configs;
    }

    @Nullable
    private static GitBranchTrackInfo convertBranchConfig(@Nullable BranchConfig branchConfig, @NotNull Collection<? extends GitLocalBranch> localBranches, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        if (branchConfig == null) {
            return null;
        }
        String branchName = branchConfig.getName();
        String remoteName = branchConfig.getRemote();
        String mergeName = branchConfig.getMerge();
        String rebaseName = branchConfig.getRebase();
        if (StringUtil.isEmptyOrSpaces((String)mergeName) && StringUtil.isEmptyOrSpaces((String)rebaseName)) {
            LOG.debug("No branch." + branchName + ".merge/rebase item in the .git/config");
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)remoteName)) {
            LOG.debug("No branch." + branchName + ".remote item in the .git/config");
            return null;
        }
        boolean merge = mergeName != null;
        String remoteBranchName = StringUtil.unquoteString((String)(merge ? mergeName : rebaseName));
        GitLocalBranch localBranch = GitConfig.findLocalBranch(branchName, localBranches);
        GitRemoteBranch remoteBranch = GitConfig.findRemoteBranch(remoteBranchName, remoteName, remoteBranches);
        if (localBranch == null || remoteBranch == null) {
            LOG.debug("localBranch: " + localBranch + ", remoteBranch: " + remoteBranch);
            return null;
        }
        return new GitBranchTrackInfo(localBranch, remoteBranch, merge);
    }

    @Nullable
    private static GitLocalBranch findLocalBranch(@NotNull String branchName, @NotNull Collection<? extends GitLocalBranch> localBranches) {
        String name = GitBranchUtil.stripRefsPrefix(branchName);
        return (GitLocalBranch)ContainerUtil.find(localBranches, input -> input.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull String remoteBranchName, @NotNull String remoteName, @NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        String branchName = GitBranchUtil.stripRefsPrefix(remoteBranchName);
        return (GitRemoteBranch)ContainerUtil.find(remoteBranches, branch -> branch.getNameForRemoteOperations().equals(branchName) && branch.getRemote().getName().equals(remoteName));
    }

    @Nullable
    private static BranchConfig parseBranchSection(@NotNull String sectionName, @NotNull Profile.Section section) {
        Matcher matcher = BRANCH_INFO_SECTION.matcher(sectionName);
        if (matcher.matches()) {
            String remote = (String)section.get((Object)"remote");
            String merge = (String)section.get((Object)"merge");
            String rebase = (String)section.get((Object)"rebase");
            return new BranchConfig(matcher.group(1), remote, merge, rebase);
        }
        if (BRANCH_COMMON_PARAMS_SECTION.matcher(sectionName).matches()) {
            LOG.debug(String.format("Common branch option(s) defined .git/config. sectionName: %s%n section: %s", sectionName, section));
            return null;
        }
        LOG.error(String.format("Invalid branch section format in .git/config. sectionName: %s%n section: %s", sectionName, section));
        return null;
    }

    @NotNull
    private static Pair<Collection<Remote>, Collection<Url>> parseRemotes(@NotNull Ini ini) {
        ArrayList<Remote> remotes = new ArrayList<Remote>();
        ArrayList<Url> urls = new ArrayList<Url>();
        for (Map.Entry stringSectionEntry : ini.entrySet()) {
            Profile.Section section;
            String sectionName = (String)stringSectionEntry.getKey();
            Remote remote = GitConfig.parseRemoteSection(sectionName, section = (Profile.Section)stringSectionEntry.getValue());
            if (remote != null) {
                remotes.add(remote);
                continue;
            }
            Url url = GitConfig.parseUrlSection(sectionName, section);
            if (url == null) continue;
            urls.add(url);
        }
        return Pair.create(remotes, urls);
    }

    @NotNull
    private static UrlsAndPushUrls substituteUrls(@NotNull Collection<? extends Url> urlSections, @NotNull Remote remote) {
        String insteadOf;
        boolean substituted;
        ArrayList<String> urls = new ArrayList<String>(remote.getUrls().size());
        ArrayList<String> pushUrls = new ArrayList<String>();
        for (String remoteUrl : remote.getUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                String pushInsteadOf = url.getPushInsteadOf();
                if (insteadOf != null && remoteUrl.startsWith(insteadOf)) {
                    urls.add(GitConfig.substituteUrl(remoteUrl, url, insteadOf));
                    substituted = true;
                    break;
                }
                if (pushInsteadOf == null || !remoteUrl.startsWith(pushInsteadOf)) continue;
                if (remote.getPushUrls().isEmpty()) {
                    pushUrls.add(GitConfig.substituteUrl(remoteUrl, url, pushInsteadOf));
                }
                urls.add(remoteUrl);
                substituted = true;
                break;
            }
            if (substituted) continue;
            urls.add(remoteUrl);
        }
        for (String remotePushUrl : remote.getPushUrls()) {
            substituted = false;
            for (Url url : urlSections) {
                insteadOf = url.getInsteadOf();
                if (insteadOf == null || !remotePushUrl.startsWith(insteadOf)) continue;
                pushUrls.add(GitConfig.substituteUrl(remotePushUrl, url, insteadOf));
                substituted = true;
                break;
            }
            if (substituted) continue;
            pushUrls.add(remotePushUrl);
        }
        if (pushUrls.isEmpty()) {
            pushUrls = new ArrayList(urls);
        }
        return new UrlsAndPushUrls(urls, pushUrls);
    }

    @NotNull
    private static String substituteUrl(@NotNull String remoteUrl, @NotNull Url url, @NotNull String insteadOf) {
        return url.myName + remoteUrl.substring(insteadOf.length());
    }

    @Nullable
    private static Remote parseRemoteSection(@NotNull String sectionName, @NotNull Profile.Section section) {
        Matcher matcher = REMOTE_SECTION.matcher(sectionName);
        if (matcher.matches() && matcher.groupCount() == 1) {
            List fetch2 = ContainerUtil.notNullize((List)section.getAll((Object)"fetch"));
            List push = ContainerUtil.notNullize((List)section.getAll((Object)"push"));
            List url = ContainerUtil.notNullize((List)section.getAll((Object)"url"));
            List pushurl = ContainerUtil.notNullize((List)section.getAll((Object)"pushurl"));
            return new Remote(matcher.group(1), fetch2, push, url, pushurl);
        }
        return null;
    }

    @Nullable
    private static Url parseUrlSection(@NotNull String sectionName, @NotNull Profile.Section section) {
        Matcher matcher = URL_SECTION.matcher(sectionName);
        if (matcher.matches() && matcher.groupCount() == 1) {
            String insteadof = (String)section.get((Object)"insteadof");
            String pushInsteadof = (String)section.get((Object)"pushinsteadof");
            return new Url(matcher.group(1), insteadof, pushInsteadof);
        }
        return null;
    }

    private static class BranchConfig {
        private final String myName;
        @Nullable
        private final String myRemote;
        @Nullable
        private final String myMerge;
        @Nullable
        private final String myRebase;

        private BranchConfig(String name, @Nullable String remote, @Nullable String merge, @Nullable String rebase) {
            this.myName = name;
            this.myRemote = remote;
            this.myMerge = merge;
            this.myRebase = rebase;
        }

        public String getName() {
            return this.myName;
        }

        @Nullable
        private String getRemote() {
            return this.myRemote;
        }

        @Nullable
        private String getMerge() {
            return this.myMerge;
        }

        @Nullable
        private String getRebase() {
            return this.myRebase;
        }
    }

    private static class Url {
        private final String myName;
        @Nullable
        private final String myInsteadof;
        @Nullable
        private final String myPushInsteadof;

        private Url(String name, @Nullable String insteadof, @Nullable String pushInsteadof) {
            this.myName = name;
            this.myInsteadof = insteadof;
            this.myPushInsteadof = pushInsteadof;
        }

        @Nullable
        public String getInsteadOf() {
            return this.myInsteadof;
        }

        @Nullable
        public String getPushInsteadOf() {
            return this.myPushInsteadof;
        }
    }

    private static class Remote {
        @NotNull
        private final String myName;
        @NotNull
        List<String> myFetchSpecs;
        @NotNull
        List<String> myPushSpec;
        @NotNull
        List<String> myUrls;
        @NotNull
        List<String> myPushUrls;

        private Remote(@NotNull String name, @NotNull List<String> fetchSpecs, @NotNull List<String> pushSpec, @NotNull List<String> urls, @NotNull List<String> pushUrls) {
            this.myName = name;
            this.myFetchSpecs = fetchSpecs;
            this.myPushSpec = pushSpec;
            this.myUrls = urls;
            this.myPushUrls = pushUrls;
        }

        @NotNull
        private Collection<String> getUrls() {
            return this.myUrls;
        }

        @NotNull
        private Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        @NotNull
        private List<String> getPushSpec() {
            return this.myPushSpec;
        }

        @NotNull
        private List<String> getFetchSpecs() {
            return this.myFetchSpecs;
        }
    }

    private static class UrlsAndPushUrls {
        final List<String> myUrls;
        final Collection<String> myPushUrls;

        private UrlsAndPushUrls(List<String> urls, Collection<String> pushUrls) {
            this.myPushUrls = pushUrls;
            this.myUrls = urls;
        }

        public Collection<String> getPushUrls() {
            return this.myPushUrls;
        }

        public List<String> getUrls() {
            return this.myUrls;
        }
    }
}

