/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import git4idea.commands.GitImplBase;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEditorHandler;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GitSimpleEditorHandler
implements GitRebaseEditorHandler {
    private static final Logger LOG = Logger.getInstance(GitSimpleEditorHandler.class);
    @NotNull
    private final Project myProject;

    public GitSimpleEditorHandler(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public int editCommits(@NotNull File file) {
        try {
            boolean cancelled = !GitImplBase.loadFileAndShowInSimpleEditor(this.myProject, null, file, GitBundle.getString("rebase.simple.editor.dialog.title"), CommonBundle.getOkButtonText());
            return cancelled ? 2 : 0;
        }
        catch (Exception e) {
            LOG.error("Failed to edit git rebase file: " + file, (Throwable)e);
            return 2;
        }
    }

    @Override
    public boolean wasCommitListEditorCancelled() {
        return false;
    }

    @Override
    public boolean wasUnstructuredEditorCancelled() {
        return false;
    }
}

