/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogDiffHandler
implements VcsLogDiffHandler {
    private static final Logger LOG = Logger.getInstance(GitLogDiffHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiffContentFactoryEx myDiffContentFactory;

    public GitLogDiffHandler(@NotNull Project project) {
        this.myProject = project;
        this.myDiffContentFactory = DiffContentFactoryEx.getInstanceEx();
    }

    public void showDiff(@NotNull VirtualFile root, @Nullable FilePath leftPath, @NotNull Hash leftHash, @Nullable FilePath rightPath, @NotNull Hash rightHash) {
        if (leftPath == null && rightPath == null) {
            return;
        }
        if (((FilePath)ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath)).isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath)), leftHash, rightHash);
        } else {
            this.loadDiffAndShow(() -> {
                DiffContent leftDiffContent = this.createDiffContent(root, leftPath, leftHash);
                DiffContent rightDiffContent = this.createDiffContent(root, rightPath, rightHash);
                return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)leftPath, (FilePath)rightPath, (String)" -> "), leftDiffContent, rightDiffContent, leftHash.asString(), rightHash.asString());
            }, request -> DiffManager.getInstance().showDiff(this.myProject, request), GitBundle.message("git.log.diff.handler.process", ((FilePath)ObjectUtils.chooseNotNull((Object)rightPath, (Object)leftPath)).getName()));
        }
    }

    public void showDiffWithLocal(@NotNull VirtualFile root, @Nullable FilePath revisionPath, @NotNull Hash revisionHash, @NotNull FilePath localPath) {
        if (localPath.isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(localPath), revisionHash, null);
        } else {
            this.loadDiffAndShow(() -> {
                DiffContent leftDiffContent = this.createDiffContent(root, revisionPath, revisionHash);
                DiffContent rightDiffContent = this.createCurrentDiffContent(localPath);
                return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)revisionPath, (FilePath)localPath, (String)" -> "), leftDiffContent, rightDiffContent, revisionHash.asString(), "(" + GitBundle.message("git.log.diff.handler.local.version.content.title", new Object[0]) + ")");
            }, request -> DiffManager.getInstance().showDiff(this.myProject, request), GitBundle.message("git.log.diff.handler.process", localPath.getName()));
        }
    }

    public void showDiffForPaths(@NotNull VirtualFile root, @Nullable Collection<FilePath> affectedPaths, @NotNull Hash leftRevision, @Nullable Hash rightRevision) {
        Collection<FilePath> filePaths = affectedPaths != null ? affectedPaths : Collections.singleton(VcsUtil.getFilePath((VirtualFile)root));
        this.loadDiffAndShow(() -> this.getDiff(root, filePaths, leftRevision, rightRevision), diff -> {
            String rightRevisionTitle = rightRevision == null ? GitBundle.message("git.log.diff.handler.local.version.name", new Object[0]) : rightRevision.toShortString();
            String dialogTitle = GitBundle.message("git.log.diff.handler.paths.diff.title", leftRevision.toShortString(), rightRevisionTitle, GitLogDiffHandler.getTitleForPaths(root, affectedPaths));
            VcsDiffUtil.showChangesDialog((Project)this.myProject, (String)dialogTitle, new ArrayList(diff));
        }, GitBundle.message("git.log.diff.handler.process", StringUtil.shortenTextWithEllipsis((String)StringUtil.join(filePaths, FilePath::getName, (String)", "), (int)100, (int)0)));
    }

    @NotNull
    private static String getTitleForPaths(@NotNull VirtualFile root, @Nullable Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            return DiffRequestFactoryImpl.getContentTitle((FilePath)VcsUtil.getFilePath((VirtualFile)root));
        }
        String joinedPaths = StringUtil.join(filePaths, path -> VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path), (String)", ");
        return StringUtil.shortenTextWithEllipsis((String)joinedPaths, (int)100, (int)0);
    }

    @NotNull
    private DiffContent createCurrentDiffContent(@NotNull FilePath localPath) throws VcsException {
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, localPath);
        if (submodule != null) {
            ContentRevision revision = GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
            String content = revision.getContent();
            return content != null ? this.myDiffContentFactory.create(this.myProject, content) : this.myDiffContentFactory.createEmpty();
        }
        VirtualFile file = localPath.getVirtualFile();
        LOG.assertTrue(file != null);
        return this.myDiffContentFactory.create(this.myProject, file);
    }

    @NotNull
    private Collection<Change> getDiff(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths, @NotNull Hash leftRevision, @Nullable Hash rightRevision) throws VcsException {
        if (rightRevision == null) {
            return GitChangeUtils.getDiffWithWorkingDir(this.myProject, root, leftRevision.asString(), filePaths, false);
        }
        return GitChangeUtils.getDiff(this.myProject, root, leftRevision.asString(), rightRevision.asString(), filePaths);
    }

    private <T> void loadDiffAndShow(final @NotNull ThrowableComputable<? extends T, VcsException> load, final @NotNull Consumer<? super T> show2, final @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title + "...", false){
                @Nullable
                private T myResult;

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        this.myResult = load.compute();
                    }
                    catch (VcsException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSuccess() {
                    if (this.myResult != null) {
                        show2.consume(this.myResult);
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)(GitBundle.message("git.log.diff.handler.failed.message", title) + "\n" + error.getMessage()), (MessageType)MessageType.ERROR);
                }
            });
        } else {
            try {
                Object result2 = load.compute();
                ApplicationManager.getApplication().invokeLater(() -> show2.consume(result2));
            }
            catch (VcsException e) {
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)(GitBundle.message("git.log.diff.handler.failed.message", title) + "\n" + e.getMessage()), (MessageType)MessageType.ERROR);
            }
        }
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull VirtualFile root, @Nullable FilePath path, @NotNull Hash hash) throws VcsException {
        EmptyContent diffContent;
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        if (path == null) {
            diffContent = new EmptyContent();
        } else {
            GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, path);
            if (submodule != null) {
                ContentRevision revision = GitSubmoduleContentRevision.createRevision(submodule, (VcsRevisionNumber)revisionNumber);
                String content = revision.getContent();
                diffContent = content != null ? this.myDiffContentFactory.create(this.myProject, content) : this.myDiffContentFactory.createEmpty();
            } else {
                try {
                    byte[] content = GitFileUtils.getFileContent(this.myProject, root, hash.asString(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
                    diffContent = this.myDiffContentFactory.createFromBytes(this.myProject, content, path);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
        }
        diffContent.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)new Pair((Object)path, (Object)revisionNumber));
        return diffContent;
    }

    @NotNull
    public ContentRevision createContentRevision(@NotNull FilePath filePath, @NotNull Hash hash) {
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        return GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, this.myProject);
    }
}

