/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.ide.dnd.DnDActionInfo;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.vcs.commit.ChangesViewCommitPanelKt;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitVcs;
import git4idea.i18n.GitBundle;
import git4idea.index.CommitListener;
import git4idea.index.GitCommitUtilKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.actions.GitAddOperation;
import git4idea.index.actions.GitFileStatusNodeActionKt;
import git4idea.index.actions.GitResetOperation;
import git4idea.index.ui.GitCommitPanel;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.GitStageDiffPreview;
import git4idea.index.ui.GitStagePanel;
import git4idea.index.ui.GitStagePanel$MyDnDSupport$WhenMappings;
import git4idea.index.ui.GitStagePanelKt;
import git4idea.index.ui.GitStageTree;
import git4idea.index.ui.NodeKind;
import git4idea.repo.GitRepository;
import git4idea.status.GitChangeProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0007#$%&'()B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u000bH\u0002J\u0006\u0010\"\u001a\u00020\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgit4idea/index/ui/GitStagePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/openapi/Disposable;", "tracker", "Lgit4idea/index/GitStageTracker;", "disposableParent", "(Lgit4idea/index/GitStageTracker;Lcom/intellij/openapi/Disposable;)V", "commitPanel", "Lgit4idea/index/ui/GitCommitPanel;", "hasPendingUpdates", "", "isCommitInProgress", "progressStripe", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lgit4idea/index/GitStageTracker$State;", "getState", "()Lgit4idea/index/GitStageTracker$State;", "tree", "Lgit4idea/index/ui/GitStageTree;", "commitFinished", "", "success", "commitStarted", "dispose", "getData", "", "dataId", "", "performCommit", "amend", "update", "MyChangesTree", "MyCommitListener", "MyDnDSupport", "MyDragBean", "MyGitChangeProviderListener", "MyGitCommitPanel", "MyGitStageTrackerListener", "intellij.vcs.git"})
public final class GitStagePanel
extends JPanel
implements DataProvider,
Disposable {
    private final Project project;
    private final GitStageTree tree;
    private final GitCommitPanel commitPanel;
    private final ProgressStripe progressStripe;
    private boolean isCommitInProgress;
    private boolean hasPendingUpdates;
    private final GitStageTracker tracker;

    private final GitStageTracker.State getState() {
        return this.tracker.getState();
    }

    private final void performCommit(boolean amend) {
        Set<VirtualFile> rootsToCommit = this.getState().getStagedRoots();
        if (rootsToCommit.isEmpty()) {
            return;
        }
        String commitMessage = this.commitPanel.getCommitMessage().getText();
        if (StringsKt.isBlank((CharSequence)commitMessage) && !ChangesViewCommitPanelKt.showEmptyCommitMessageConfirmation()) {
            return;
        }
        this.commitStarted();
        FileDocumentManager.getInstance().saveAllDocuments();
        GitCommitUtilKt.performCommit(this.project, (Collection<? extends VirtualFile>)rootsToCommit, commitMessage, amend, new MyCommitListener(commitMessage));
    }

    private final void commitStarted() {
        this.isCommitInProgress = true;
        this.commitPanel.getCommitButton().setEnabled(false);
    }

    private final void commitFinished(boolean success) {
        this.isCommitInProgress = false;
        if (success) {
            this.commitPanel.setAmend$intellij_vcs_git(false);
        }
        if (this.hasPendingUpdates) {
            this.hasPendingUpdates = false;
            this.update();
        }
    }

    public final void update() {
        if (this.isCommitInProgress) {
            this.hasPendingUpdates = true;
            return;
        }
        this.tree.update();
        this.commitPanel.getCommitButton().setEnabled(this.getState().hasStagedRoots());
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (GitStagePanelKt.getGIT_STAGE_TRACKER().is(dataId)) {
            return this.tracker;
        }
        return null;
    }

    public void dispose() {
    }

    public GitStagePanel(@NotNull GitStageTracker tracker, @NotNull Disposable disposableParent) {
        super(new BorderLayout());
        this.tracker = tracker;
        this.project = this.tracker.getProject();
        this.tree = new MyChangesTree(this.project);
        this.commitPanel = new MyGitCommitPanel();
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Git.Stage.Toolbar"));
        toolbarGroup.addSeparator();
        toolbarGroup.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
        toolbarGroup.addSeparator();
        toolbarGroup.addAll((Collection)TreeActionsToolbarPanel.createTreeActions((ChangesTree)this.tree));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)toolbarGroup, true);
        toolbar.setTargetComponent((JComponent)((Object)this.tree));
        PopupHandler.installPopupHandler((JComponent)((JComponent)((Object)this.tree)), (String)"Git.Stage.Tree.Menu", (String)"Git.Stage.Tree.Menu");
        JScrollPane scrolledTree = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.tree)), (int)2);
        this.progressStripe = new ProgressStripe((JComponent)scrolledTree, (Disposable)this, 300);
        OnePixelSplitter treeMessageSplitter = new OnePixelSplitter(true, "git.stage.tree.message.splitter", 0.7f);
        treeMessageSplitter.setFirstComponent((JComponent)this.progressStripe);
        treeMessageSplitter.setSecondComponent((JComponent)((Object)this.commitPanel));
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)toolbar.getComponent(), "North");
        leftPanel.add((Component)treeMessageSplitter, "Center");
        GitStageDiffPreview diffPreview = new GitStageDiffPreview(this.project, this.tree, this.tracker, this);
        diffPreview.getToolbarWrapper().setVerticalSizeReferent(toolbar.getComponent());
        OnePixelSplitter commitDiffSplitter = new OnePixelSplitter("git.stage.commit.diff.splitter", 0.5f);
        commitDiffSplitter.setFirstComponent((JComponent)leftPanel);
        commitDiffSplitter.setSecondComponent(diffPreview.getComponent());
        this.add((Component)commitDiffSplitter, "Center");
        this.tracker.addListener(new MyGitStageTrackerListener(), this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(GitChangeProvider.TOPIC, (Object)new MyGitChangeProviderListener());
        GitChangeProvider gitChangeProvider = GitVcs.getInstance(this.project).getChangeProvider();
        if (gitChangeProvider != null) {
            if (gitChangeProvider.isRefreshInProgress()) {
                this.tree.setEmptyText(GitBundle.message("stage.loading.status", new Object[0]));
                this.progressStripe.startLoadingImmediately();
            }
        }
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        BaseSingleTaskControllerKt.runInEdtAsync((Disposable)this, (Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                tree.rebuildTree();
            }
        }));
        new MyDnDSupport().install(this);
    }

    public static final /* synthetic */ ProgressStripe access$getProgressStripe$p(GitStagePanel $this) {
        return $this.progressStripe;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyChangesTree;", "Lgit4idea/index/ui/GitStageTree;", "project", "Lcom/intellij/openapi/project/Project;", "(Lgit4idea/index/ui/GitStagePanel;Lcom/intellij/openapi/project/Project;)V", "state", "Lgit4idea/index/GitStageTracker$State;", "getState", "()Lgit4idea/index/GitStageTracker$State;", "intellij.vcs.git"})
    private final class MyChangesTree
    extends GitStageTree {
        @Override
        @NotNull
        protected GitStageTracker.State getState() {
            return GitStagePanel.this.getState();
        }

        public MyChangesTree(Project project) {
            super(project);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014\u00a8\u0006\n"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyGitCommitPanel;", "Lgit4idea/index/ui/GitCommitPanel;", "(Lgit4idea/index/ui/GitStagePanel;)V", "isFocused", "", "performCommit", "", "rootsToCommit", "", "Lcom/intellij/openapi/vcs/VcsRoot;", "intellij.vcs.git"})
    private final class MyGitCommitPanel
    extends GitCommitPanel {
        @Override
        protected boolean isFocused() {
            return IdeFocusManager.getInstance((Project)GitStagePanel.this.project).getFocusedDescendantFor((Component)GitStagePanel.this) != null;
        }

        @Override
        protected void performCommit() {
            GitStagePanel.this.performCommit(this.isAmend());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected List<VcsRoot> rootsToCommit() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = GitStagePanel.this.getState().getStagedRoots();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VcsRoot vcsRoot = new VcsRoot((AbstractVcs)GitVcs.getInstance(GitStagePanel.this.project), (VirtualFile)it);
                collection.add(vcsRoot);
            }
            return (List)destination$iv$iv;
        }

        public MyGitCommitPanel() {
            super(GitStagePanel.this.project, GitStagePanel.this);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyGitStageTrackerListener;", "Lgit4idea/index/GitStageTrackerListener;", "(Lgit4idea/index/ui/GitStagePanel;)V", "update", "", "intellij.vcs.git"})
    private final class MyGitStageTrackerListener
    implements GitStageTrackerListener {
        @Override
        public void update() {
            GitStagePanel.this.update();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyGitChangeProviderListener;", "Lgit4idea/status/GitChangeProvider$ChangeProviderListener;", "(Lgit4idea/index/ui/GitStagePanel;)V", "progressStarted", "", "progressStopped", "repositoryUpdated", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
    private final class MyGitChangeProviderListener
    implements GitChangeProvider.ChangeProviderListener {
        @Override
        public void progressStarted() {
            BaseSingleTaskControllerKt.runInEdt((Disposable)GitStagePanel.this, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MyGitChangeProviderListener this$0;

                public final void invoke() {
                    GitStagePanel.access$getTree$p(this.this$0.GitStagePanel.this).setEmptyText(GitBundle.message("stage.loading.status", new Object[0]));
                    GitStagePanel.access$getProgressStripe$p(this.this$0.GitStagePanel.this).startLoading();
                }
                {
                    this.this$0 = myGitChangeProviderListener;
                    super(0);
                }
            }));
        }

        @Override
        public void progressStopped() {
            BaseSingleTaskControllerKt.runInEdt((Disposable)GitStagePanel.this, (Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MyGitChangeProviderListener this$0;

                public final void invoke() {
                    GitStagePanel.access$getProgressStripe$p(this.this$0.GitStagePanel.this).stopLoading();
                    GitStagePanel.access$getTree$p(this.this$0.GitStagePanel.this).setEmptyText("");
                }
                {
                    this.this$0 = myGitChangeProviderListener;
                    super(0);
                }
            }));
        }

        @Override
        public void repositoryUpdated(@NotNull GitRepository repository) {
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0014"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyDnDSupport;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTreeDnDSupport;", "(Lgit4idea/index/ui/GitStagePanel;)V", "acceptDrop", "", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "bean", "Lgit4idea/index/ui/GitStagePanel$MyDragBean;", "canAcceptDrop", "", "canHandleDropEvent", "aEvent", "Lcom/intellij/ide/dnd/DnDEvent;", "dropNode", "createDragStartBean", "Lcom/intellij/ide/dnd/DnDDragStartBean;", "info", "Lcom/intellij/ide/dnd/DnDActionInfo;", "drop", "intellij.vcs.git"})
    private final class MyDnDSupport
    extends ChangesTreeDnDSupport {
        @Nullable
        protected DnDDragStartBean createDragStartBean(@NotNull DnDActionInfo info) {
            if (info.isMove()) {
                List selection = StreamsKt.toList(GitStagePanel.this.tree.selectedStatusNodes());
                Collection collection = selection;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    return new DnDDragStartBean((Object)new MyDragBean(GitStagePanel.this.tree, selection));
                }
            }
            return null;
        }

        protected boolean canHandleDropEvent(@NotNull DnDEvent aEvent, @NotNull ChangesBrowserNode<?> dropNode) {
            Object dragBean = aEvent.getAttachedObject();
            if (dragBean instanceof MyDragBean && ((MyDragBean)dragBean).getSourceComponent() == GitStagePanel.this.tree && this.canAcceptDrop(dropNode, (MyDragBean)dragBean)) {
                ((MyDragBean)dragBean).setTargetNode(dropNode);
                return true;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent aEvent) {
            block1: {
                ChangesBrowserNode<?> changesBrowserNode;
                Object dragBean = aEvent.getAttachedObject();
                if (!(dragBean instanceof MyDragBean)) break block1;
                ChangesBrowserNode<?> changesBrowserNode2 = changesBrowserNode = ((MyDragBean)dragBean).getTargetNode();
                if (changesBrowserNode2 != null) {
                    ChangesBrowserNode<?> changesBrowserNode3 = changesBrowserNode2;
                    boolean bl = false;
                    boolean bl2 = false;
                    ChangesBrowserNode<?> it = changesBrowserNode3;
                    boolean bl3 = false;
                    this.acceptDrop(it, (MyDragBean)dragBean);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean canAcceptDrop(ChangesBrowserNode<?> node, MyDragBean bean) {
            boolean bl;
            Object object = node.getUserObject();
            if (!(object instanceof NodeKind)) {
                object = null;
            }
            NodeKind nodeKind = (NodeKind)((Object)object);
            if (nodeKind == null) {
                return false;
            }
            NodeKind targetKind = nodeKind;
            block0 : switch (GitStagePanel$MyDnDSupport$WhenMappings.$EnumSwitchMapping$0[targetKind.ordinal()]) {
                case 1: {
                    void $this$all$iv;
                    Iterable iterable = bean.getNodes();
                    GitAddOperation gitAddOperation = GitAddOperation.INSTANCE;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                        break;
                    }
                    for (Object element$iv : $this$all$iv) {
                        GitFileStatusNode p1 = (GitFileStatusNode)element$iv;
                        boolean bl2 = false;
                        if (gitAddOperation.matches(p1)) continue;
                        bl = false;
                        break block0;
                    }
                    bl = true;
                    break;
                }
                case 2: {
                    Iterable $this$all$iv = bean.getNodes();
                    GitResetOperation gitResetOperation = GitResetOperation.INSTANCE;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                        break;
                    }
                    for (Object element$iv : $this$all$iv) {
                        GitFileStatusNode p1 = (GitFileStatusNode)element$iv;
                        boolean bl3 = false;
                        if (gitResetOperation.matches(p1)) continue;
                        bl = false;
                        break block0;
                    }
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        private final void acceptDrop(ChangesBrowserNode<?> node, MyDragBean bean) {
            Object object = node.getUserObject();
            if (!(object instanceof NodeKind)) {
                object = null;
            }
            NodeKind nodeKind = (NodeKind)((Object)object);
            if (nodeKind == null) {
                return;
            }
            NodeKind targetKind = nodeKind;
            if (targetKind == NodeKind.STAGED) {
                GitFileStatusNodeActionKt.performStageOperation(GitStagePanel.this.project, bean.getNodes(), GitAddOperation.INSTANCE);
            } else if (targetKind == NodeKind.UNSTAGED) {
                GitFileStatusNodeActionKt.performStageOperation(GitStagePanel.this.project, bean.getNodes(), GitResetOperation.INSTANCE);
            }
        }

        public MyDnDSupport() {
            super((ChangesTree)GitStagePanel.this.tree);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyDragBean;", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "nodes", "", "Lgit4idea/index/ui/GitFileStatusNode;", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Ljava/util/List;)V", "getNodes", "()Ljava/util/List;", "sourceComponent", "Ljavax/swing/JComponent;", "getSourceComponent", "()Ljavax/swing/JComponent;", "targetNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "getTargetNode", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "setTargetNode", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;)V", "getTree", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "intellij.vcs.git"})
    private static final class MyDragBean {
        @Nullable
        private ChangesBrowserNode<?> targetNode;
        @NotNull
        private final ChangesTree tree;
        @NotNull
        private final List<GitFileStatusNode> nodes;

        @Nullable
        public final ChangesBrowserNode<?> getTargetNode() {
            return this.targetNode;
        }

        public final void setTargetNode(@Nullable ChangesBrowserNode<?> changesBrowserNode) {
            this.targetNode = changesBrowserNode;
        }

        @NotNull
        public final JComponent getSourceComponent() {
            return (JComponent)this.tree;
        }

        @NotNull
        public final ChangesTree getTree() {
            return this.tree;
        }

        @NotNull
        public final List<GitFileStatusNode> getNodes() {
            return this.nodes;
        }

        public MyDragBean(@NotNull ChangesTree tree, @NotNull List<GitFileStatusNode> nodes2) {
            this.tree = tree;
            this.nodes = nodes2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/index/ui/GitStagePanel$MyCommitListener;", "Lgit4idea/index/CommitListener;", "commitMessage", "", "(Lgit4idea/index/ui/GitStagePanel;Ljava/lang/String;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "commitProcessFinished", "", "successfulRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "failedRoots", "", "Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
    private final class MyCommitListener
    implements CommitListener {
        private final VcsNotifier notifier;
        private final String commitMessage;

        @Override
        public void commitProcessFinished(@NotNull Collection<? extends VirtualFile> successfulRoots, @NotNull Map<VirtualFile, ? extends VcsException> failedRoots) {
            Object object = successfulRoots;
            boolean bl = false;
            GitStagePanel.this.commitFinished(!object.isEmpty() && failedRoots.isEmpty());
            object = successfulRoots;
            bl = false;
            if (!object.isEmpty()) {
                this.notifier.notifySuccess(GitBundle.message("stage.commit.successful", CollectionsKt.joinToString$default((Iterable)successfulRoots, null, null, null, (int)0, null, (Function1)((Function1)new Function1<VirtualFile, CharSequence>(this){
                    final /* synthetic */ MyCommitListener this$0;

                    @NotNull
                    public final CharSequence invoke(@NotNull VirtualFile it) {
                        return '\'' + VcsImplUtil.getShortVcsRootName((Project)GitStagePanel.access$getProject$p(this.this$0.GitStagePanel.this), (VirtualFile)it) + '\'';
                    }
                    {
                        this.this$0 = myCommitListener;
                        super(1);
                    }
                }), (int)31, null), XmlStringUtil.escapeString((String)this.commitMessage)));
            }
            object = failedRoots;
            bl = false;
            if (!object.isEmpty()) {
                this.notifier.notifyError(GitBundle.message("stage.commit.failed", CollectionsKt.joinToString$default((Iterable)failedRoots.keySet(), null, null, null, (int)0, null, (Function1)((Function1)new Function1<VirtualFile, CharSequence>(this){
                    final /* synthetic */ MyCommitListener this$0;

                    @NotNull
                    public final CharSequence invoke(@NotNull VirtualFile it) {
                        return '\'' + VcsImplUtil.getShortVcsRootName((Project)GitStagePanel.access$getProject$p(this.this$0.GitStagePanel.this), (VirtualFile)it) + '\'';
                    }
                    {
                        this.this$0 = myCommitListener;
                        super(1);
                    }
                }), (int)31, null)), CollectionsKt.joinToString$default((Iterable)failedRoots.values(), (CharSequence)"<br/>", null, null, (int)0, null, (Function1)commitProcessFinished.3.INSTANCE, (int)30, null));
            }
        }

        public MyCommitListener(String commitMessage) {
            this.commitMessage = commitMessage;
            this.notifier = VcsNotifier.getInstance((Project)GitStagePanel.this.project);
        }
    }
}

