/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.index.GitFileStatus;
import git4idea.index.LightFileStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u001aJ\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u0019\u001a\u0014\u0010\u001c\u001a\u00020\u00192\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u001a \u0010\u001d\u001a\u00020\u00192\n\u0010\u001e\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u001f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u001a\u0014\u0010 \u001a\u00020\u00192\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u001a\u0014\u0010!\u001a\u00020\u00192\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u001a\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010#\u001a\u00020\u00192\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011\u001a\u0014\u0010$\u001a\u00020\u00192\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0000\u001a\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00132\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a0\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0010H\u0002\u001a2\u0010.\u001a\u00020)*\u00020/2\u0006\u00100\u001a\u0002012\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u0019H\u0002\u001a\n\u00102\u001a\u00020\u0019*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005*\n\u00103\"\u00020\u00102\u00020\u0010\u00a8\u00064"}, d2={"NUL", "", "repositoryPath", "Lgit4idea/index/LightFileStatus;", "getRepositoryPath", "(Lgit4idea/index/LightFileStatus;)Ljava/lang/String;", "getFilePath", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "executable", "Lgit4idea/config/GitExecutable;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "status", "", "Lgit4idea/index/StatusCode;", "getStatus", "", "Lgit4idea/index/GitFileStatus;", "project", "Lcom/intellij/openapi/project/Project;", "files", "withRenames", "", "withUntracked", "withIgnored", "isAdded", "isConflicted", "index", "workTree", "isDeleted", "isIgnored", "isKnownStatus", "isRenamed", "isUntracked", "parseGitStatusOutput", "Lgit4idea/index/LightFileStatus$StatusRecord;", "output", "throwGFE", "", "message", "line", "xStatus", "yStatus", "appendParameters", "Lgit4idea/commands/GitLineHandler;", "gitVersion", "Lgit4idea/config/GitVersion;", "isTracked", "StatusCode", "intellij.vcs.git"})
public final class GitIndexStatusUtilKt {
    @NotNull
    public static final String NUL = "\u0000";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<GitFileStatus> getStatus(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends FilePath> files, boolean withRenames, boolean withUntracked, boolean withIgnored) throws VcsException {
        void $this$mapTo$iv$iv;
        GitLineHandler h2 = (GitLineHandler)GitUtil.createHandlerWithPaths((Collection<? extends FilePath>)files, (Computable)new Computable<GitLineHandler>(project, root, withRenames, withUntracked, withIgnored){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ boolean $withRenames;
            final /* synthetic */ boolean $withUntracked;
            final /* synthetic */ boolean $withIgnored;

            /*
             * WARNING - void declaration
             */
            public final GitLineHandler compute() {
                void var1_1;
                GitLineHandler h2 = new GitLineHandler(this.$project, this.$root, GitCommand.STATUS);
                h2.setSilent(true);
                GitVersion gitVersion = GitExecutableManager.getInstance().tryGetVersion(this.$project);
                if (gitVersion == null) {
                    gitVersion = GitVersion.NULL;
                }
                GitIndexStatusUtilKt.access$appendParameters(h2, gitVersion, this.$withRenames, this.$withUntracked, this.$withIgnored);
                return var1_1;
            }
            {
                this.$project = project;
                this.$root = virtualFile;
                this.$withRenames = bl;
                this.$withUntracked = bl2;
                this.$withIgnored = bl3;
            }
        });
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Iterable $this$map$iv = GitIndexStatusUtilKt.parseGitStatusOutput(output);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LightFileStatus.StatusRecord statusRecord = (LightFileStatus.StatusRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            GitFileStatus gitFileStatus = new GitFileStatus(root, (LightFileStatus.StatusRecord)it);
            collection.add(gitFileStatus);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getStatus$default(Project project, VirtualFile virtualFile, List list, boolean bl, boolean bl2, boolean bl3, int n, Object object) throws VcsException {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        return GitIndexStatusUtilKt.getStatus(project, virtualFile, list, bl, bl2, bl3);
    }

    @NotNull
    public static final LightFileStatus getFileStatus(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull GitExecutable executable) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), executable, GitCommand.STATUS, CollectionsKt.emptyList());
        h2.setSilent(true);
        GitIndexStatusUtilKt.appendParameters(h2, GitExecutableManager.getInstance().getVersion(executable), false, true, true);
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        CharSequence charSequence = output;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            List<LightFileStatus.StatusRecord> gitStatusOutput = GitIndexStatusUtilKt.parseGitStatusOutput(output);
            LightFileStatus.StatusRecord statusRecord = (LightFileStatus.StatusRecord)CollectionsKt.firstOrNull(gitStatusOutput);
            return statusRecord != null ? (LightFileStatus)statusRecord : (LightFileStatus)LightFileStatus.Blank.INSTANCE;
        }
        String string = GitIndexStatusUtilKt.getFilePath(root, filePath, executable);
        if (string == null) {
            return LightFileStatus.Blank.INSTANCE;
        }
        String repositoryPath = string;
        return new LightFileStatus.NotChanged(repositoryPath);
    }

    private static final void appendParameters(GitLineHandler $this$appendParameters, GitVersion gitVersion, boolean withRenames, boolean withUntracked, boolean withIgnored) {
        $this$appendParameters.addParameters("--porcelain", "-z");
        if (!withRenames && GitVersionSpecialty.STATUS_SUPPORTS_NO_RENAMES.existsIn(gitVersion)) {
            $this$appendParameters.addParameters("--no-renames");
        }
        $this$appendParameters.addParameters("--untracked-files=" + (withUntracked ? "all" : "no"));
        if (GitVersionSpecialty.STATUS_SUPPORTS_IGNORED_MODES.existsIn(gitVersion)) {
            if (withIgnored) {
                $this$appendParameters.addParameters("--ignored=matching");
            } else {
                $this$appendParameters.addParameters("--ignored=no");
            }
        } else if (withIgnored) {
            $this$appendParameters.addParameters("--ignored");
        }
    }

    static /* synthetic */ void appendParameters$default(GitLineHandler gitLineHandler, GitVersion gitVersion, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        GitIndexStatusUtilKt.appendParameters(gitLineHandler, gitVersion, bl, bl2, bl3);
    }

    @Nullable
    public static final String getFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull GitExecutable executable) throws VcsException {
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), executable, GitCommand.LS_FILES, CollectionsKt.emptyList());
        handler.addParameters("--full-name");
        handler.addRelativePaths(filePath);
        handler.setSilent(true);
        return (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0])));
    }

    private static final List<LightFileStatus.StatusRecord> parseGitStatusOutput(String output) throws VcsException {
        boolean bl = false;
        List result2 = new ArrayList();
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)output, (String[])new String[]{NUL}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] split = objectArray;
        Iterator it = ArrayIteratorKt.iterator((Object[])split);
        while (it.hasNext()) {
            String pathPart;
            String line = (String)it.next();
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (line.length() < 4 || line.charAt(2) != ' ') {
                GitIndexStatusUtilKt.throwGFE("Line is too short.", output, line, '0', '0');
            }
            char xStatus = line.charAt(0);
            char yStatus = line.charAt(1);
            if (!GitIndexStatusUtilKt.isKnownStatus(xStatus) || !GitIndexStatusUtilKt.isKnownStatus(yStatus)) {
                GitIndexStatusUtilKt.throwGFE("Unexpected symbol as status.", output, line, xStatus, yStatus);
            }
            String string = line;
            int n = 3;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            if (GitIndexStatusUtilKt.isRenamed(xStatus) || GitIndexStatusUtilKt.isRenamed(yStatus)) {
                if (!it.hasNext()) {
                    GitIndexStatusUtilKt.throwGFE("Missing original path.", output, line, xStatus, yStatus);
                    continue;
                }
                String origPath = (String)it.next();
                result2.add(new LightFileStatus.StatusRecord(xStatus, yStatus, pathPart, origPath));
                continue;
            }
            result2.add(new LightFileStatus.StatusRecord(xStatus, yStatus, pathPart, null, 8, null));
        }
        return result2;
    }

    private static final void throwGFE(String message, String output, String line, char xStatus, char yStatus) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s\n xStatus=[%s], yStatus=[%s], line=[%s], \noutput: \n%s";
        Object[] objectArray = new Object[]{message, Character.valueOf(xStatus), Character.valueOf(yStatus), StringsKt.replace$default((String)line, (String)NUL, (String)"!", (boolean)false, (int)4, null), output};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        throw (Throwable)new VcsException(string2);
    }

    private static final boolean isKnownStatus(char status) {
        return status == ' ' || status == 'M' || status == 'A' || status == 'D' || status == 'C' || status == 'R' || status == 'U' || status == 'T' || status == '!' || status == '?';
    }

    @Nullable
    public static final FileStatus getFileStatus(char status) throws VcsException {
        FileStatus fileStatus;
        switch (status) {
            case ' ': {
                fileStatus = null;
                break;
            }
            case 'C': 
            case 'M': 
            case 'R': 
            case 'T': {
                fileStatus = FileStatus.MODIFIED;
                break;
            }
            case 'A': {
                fileStatus = FileStatus.ADDED;
                break;
            }
            case 'D': {
                fileStatus = FileStatus.DELETED;
                break;
            }
            case 'U': {
                fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
                break;
            }
            case '!': {
                fileStatus = FileStatus.IGNORED;
                break;
            }
            case '?': {
                fileStatus = FileStatus.UNKNOWN;
                break;
            }
            default: {
                throw (Throwable)new VcsException("Unexpected symbol as status: " + status);
            }
        }
        return fileStatus;
    }

    public static final boolean isIgnored(char status) {
        return status == '!';
    }

    public static final boolean isUntracked(char status) {
        return status == '?';
    }

    public static final boolean isRenamed(char status) {
        return status == 'R' || status == 'C';
    }

    public static final boolean isAdded(char status) {
        return status == 'A';
    }

    public static final boolean isDeleted(char status) {
        return status == 'D';
    }

    public static final boolean isConflicted(char index, char workTree) {
        return index == 'D' && workTree == 'D' || index == 'A' && workTree == 'A' || index == 'T' && workTree == 'T' || index == 'U' || workTree == 'U';
    }

    public static final boolean isTracked(@NotNull LightFileStatus $this$isTracked) {
        boolean bl;
        LightFileStatus lightFileStatus = $this$isTracked;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE)) {
            bl = false;
        } else if (lightFileStatus instanceof LightFileStatus.NotChanged) {
            bl = true;
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            bl = !GitIndexStatusUtilKt.isIgnored(((LightFileStatus.StatusRecord)$this$isTracked).getIndex()) && !GitIndexStatusUtilKt.isUntracked(((LightFileStatus.StatusRecord)$this$isTracked).getIndex());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final String getRepositoryPath(@NotNull LightFileStatus $this$repositoryPath) {
        String string;
        LightFileStatus lightFileStatus = $this$repositoryPath;
        if (Intrinsics.areEqual((Object)lightFileStatus, (Object)LightFileStatus.Blank.INSTANCE)) {
            string = null;
        } else if (lightFileStatus instanceof LightFileStatus.NotChanged) {
            string = ((LightFileStatus.NotChanged)$this$repositoryPath).getPath();
        } else if (lightFileStatus instanceof LightFileStatus.StatusRecord) {
            if (!GitIndexStatusUtilKt.isTracked($this$repositoryPath) || ((LightFileStatus.StatusRecord)$this$repositoryPath).getIndex() == 'A' || ((LightFileStatus.StatusRecord)$this$repositoryPath).getWorkTree() == 'A') {
                string = null;
            } else {
                string = ((LightFileStatus.StatusRecord)$this$repositoryPath).getOrigPath();
                if (string == null) {
                    string = ((LightFileStatus.StatusRecord)$this$repositoryPath).getPath();
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ void access$appendParameters(GitLineHandler $this$access_u24appendParameters, GitVersion gitVersion, boolean withRenames, boolean withUntracked, boolean withIgnored) {
        GitIndexStatusUtilKt.appendParameters($this$access_u24appendParameters, gitVersion, withRenames, withUntracked, withIgnored);
    }
}

